<!---

Copyright (C) 2022-2024 Intel Corporation

SPDX-License-Identifier: MIT

-->

# Intel® NPU driver

## Introduction

This repository contains driver for Intel® NPU device.

Intel® NPU device is an AI inference accelerator integrated with Intel client CPUs,
starting from Intel® Core™ Ultra generation of CPUs (formerly known as Meteor Lake).
It enables energy-efficient execution of artificial neural network tasks.

To make sure that your system has an NPU available, please follow
[the steps](https://www.intel.com/content/www/us/en/support/articles/000097597/processors.html).

The full device name is Neural Processing Unit, but the Linux kernel driver uses
the older name - Versatile Processing Unit (VPU).

## Releases

[The release page contains the binaries and supported component versions](https://github.com/intel/linux-npu-driver/releases).

## Build and troubleshooting

[See docs/overview.md](docs/overview.md)

## License

Intel® NPU driver is distributed under the MIT License.

You may obtain a copy of the license at: https://opensource.org/licenses/MIT

## See also

* [Intel® OneApi Level Zero](https://github.com/oneapi-src/level-zero/)
* [Intel® NPU Acceleration Library](https://intel.github.io/intel-npu-acceleration-library/)
* [OpenVINO™](https://github.com/openvinotoolkit/openvino.git)
* [OpenVINO™ AI Plugins for GIMP](https://github.com/intel/openvino-ai-plugins-gimp)
* [OpenVINO™ AI Plugins for Audacity*](https://github.com/intel/openvino-plugins-ai-audacity)
