[<img src="./art/standwithua.png" />](https://supportukrainenow.org)

* * *

[<img src="./art/logo.svg" alt="Logo Mixpost" />](https://mixpost.app)

[![Latest Version on Packagist](https://img.shields.io/packagist/v/inovector/mixpost.svg?style=flat-square)](https://packagist.org/packages/inovector/mixpost)
[![GitHub Tests Action Status](https://img.shields.io/github/workflow/status/inovector/mixpost/run-tests?label=tests)](https://github.com/inovector/mixpost/actions?query=workflow%3Arun-tests+branch%3Amain)
[![Total Downloads](https://img.shields.io/packagist/dt/inovector/mixpost.svg?style=flat-square)](https://packagist.org/packages/inovector/mixpost)

## Introduction
**Mixpost** it's the coolest **Self hosted social media management software**. 

This package is the **Lite version** of Mixpost Pro.

Mixpost is a robust and versatile **social media management platform**, designed to streamline **social media operations** and enhance **content marketing strategies**. Our platform empowers brands and businesses to effectively manage their **online presence**, leading them to success in the dynamic digital landscape. Mixpost's mission is to offer a comprehensive and powerful solution, enabling users to elevate their **social media management** and achieve tangible results.

The platform allows users to craft, organize, and schedule their content for times when their audience is most engaged and active. Mixpost's user-friendly **scheduling system** ensures that content publishing is seamless and efficient. It also facilitates team collaboration by allowing users to assign tasks, manage permissions, and monitor team performance, optimizing team interactions and workflow. Additionally, Mixpost automates post scheduling to ensure maximum audience reach and engagement, significantly boosting interaction and customer engagement.

Trusted by a wide range of users, Mixpost stands out as a proficient and influential tool for social media management and content marketing. It is perfectly suited for enterprises, small to medium businesses, marketing agencies, solopreneurs, and e-commerce stores.

**_Highlighting Features of Mixpost_**

**Mixpost** offers a multitude of features, making **social media management** more effective and simpler:

**Streamlined Social Account Management:**
Bring all your social media accounts together in one place for smarter and more efficient management.

**Advanced Analytics:**
Gain insights into your audience's behavior and preferences. Mixpost provides detailed analytics, for each platform according to the data shared. We do our best to make sure our API integrations are up to date, to provide seamless analytics experience accross all social media platforms.

**Post Versions and Conditions:**
Tailor your content for each social network and automate follow-up comments on high-performing posts, enhancing engagement and reach.

**Efficient Media Library:**
Quickly access and reuse media files like images, GIFs, and videos, and integrate with stock image sources for a diverse range of content.

**Team Collaboration and Workspaces:**
Foster team collaboration with dedicated workspaces. Discuss ideas, manage tasks, and monitor performance, all from a centralized platform.

**Queue and Calendar Management:**
Build a natural content posting schedule and visualize your strategy with an easy-to-use calendar.

**Customizable Post Templates:**
Boost efficiency with reusable post templates, perfect for maintaining consistency across your social media channels.

**Dynamic Variables and Hashtag Groups:**
Insert dynamic text and organize your hashtags strategically for increased post effectiveness.
And many more features that make Mixpost a standout choice for managing social media and content marketing. Discover all the features in detail at Mixpost Features.

It is the ideal social media management software for bloggers, artisans, entrepreneurs, and marketing teams looking to optimize internal costs.

**[Unlock the full potential of Mixpost with Mixpost Pro/Enterprise](https://mixpost.app/pricing)**

Join our community:

- [Discord](https://mixpost.app/discord)
- [Facebook Private Group](https://www.facebook.com/groups/getmixpost)

[<img src="./art/cover.png?v=3" />](https://mixpost.app)

## Installation

Read our [documentation](https://docs.mixpost.app/lite/) on how to get started.

## Changelog

Please see [Releases](../../releases) for more information what has changed recently.

## Contributing

By participating in this project you agree to these conditions 👇

Please note that this project is a [commercial product](https://mixpost.app/), and this repository is the lite version
of Mixpost Pro. We work hard to offer the community the best free social media manager solution and please read this
section carefully.

If you want to add a feature, it's better to open an issue before you start coding. It is important for us that features
from the Lite version do not correlate with features from the Mixpost Pro. PRs with optimizations, bug fixes are
welcome.

Please, be very clear on your commit messages and pull requests, empty pull request messages may be rejected.

When contributing code to Mixpost, you must follow
the [PSR-12 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-12-extended-coding-style-guide.md).
The golden rule is: Imitate the existing Mixpost code.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Dima Botezatu](https://github.com/lao9s)
- [All Contributors](../../contributors)

## License

Mixpost is licensed under the [MIT License](LICENSE.md), sponsored and supported by [Inovector](https://inovector.com).
