import mainConfig from "ember-ebau-core/config/main";

const { answerSlugs } = mainConfig;

export default {
  columns: {
    caluma: {
      default: [
        "dossierNumber",
        "form",
        "address",
        "submitDate",
        "instanceState",
        "intent",
        "applicants",
      ],
    },
  },
  activeFilters: {
    caluma: {
      default: [
        "form",
        "dossierNumber",
        "address",
        "parcel",
        "personalDetails",
        "intent",
        "submitDateAfter",
        "submitDateBefore",
        "keywords",
        "instanceState",
        "responsibleServiceUser",
        "decision",
        "paper",
        "projectModification",
        "appeal",
      ],
      service: [
        "form",
        "dossierNumber",
        "address",
        "parcel",
        "personalDetails",
        "intent",
        "submitDateAfter",
        "submitDateBefore",
        "keywords",
        "instanceState",
        "responsibleServiceUser",
        "municipality",
        "paper",
      ],
    },
  },
  availableOrderings: {
    dossierNumber: {
      caluma: [{ meta: `${answerSlugs.specialId}-sort` }],
    },
    submitDate: {
      caluma: [{ meta: "submit-date" }],
    },
  },
  defaultOrder: "dossierNumber",
  addressSlugs: [
    answerSlugs.objectStreet,
    answerSlugs.objectNumber,
    answerSlugs.objectLocation,
  ],
  parcelSlugs: [answerSlugs.parcelNumber],
};
