import { render, settled } from "@ember/test-helpers";
import { tracked } from "@glimmer/tracking";
import { hbs } from "ember-cli-htmlbars";
import { t } from "ember-intl/test-support";
import { module, test } from "qunit";

import { setupRenderingTest } from "camac-ng/tests/helpers";

module("Integration | Component | pagination-info", function (hooks) {
  setupRenderingTest(hooks);

  test("it renders", async function (assert) {
    this.query = new (class {
      @tracked value = Array.from({ length: 10 });
      @tracked totalCount = 20;
    })();

    await render(hbs`<PaginationInfo @query={{this.query}} />`);

    assert
      .dom(".uk-text-right")
      .hasText(
        t("global.paginationInfo", { count: 10, total: 20 }).replace(
          /<(\/)?strong>/g,
          "",
        ),
      );

    this.query.value = [];
    await settled();

    assert.dom(".uk-text-right").doesNotExist();
  });
});
