import { render } from "@ember/test-helpers";
import click from "@ember/test-helpers/dom/click";
import { hbs } from "ember-cli-htmlbars";
import { module, test } from "qunit";

import { setupRenderingTest } from "caluma-portal/tests/helpers";

const person = {
  juristicName: null,
  firstName: "John",
  lastName: "Doe",
  email: "jd@example.com",
};

module(
  "Integration | Component | personal-suggestions/entry",
  function (hooks) {
    setupRenderingTest(hooks);

    test("it renders", async function (assert) {
      this.person = person;

      await render(hbs`<PersonalSuggestions::Entry @person={{this.person}} />`);

      assert.dom("li a").hasText("John Doe jd@example.com");
    });

    test("it renders a juristic person", async function (assert) {
      this.person = { ...person, juristicName: "ACME Inc." };

      await render(hbs`<PersonalSuggestions::Entry @person={{this.person}} />`);

      assert.dom("li a").hasText("ACME Inc. jd@example.com");
    });

    test("it renders as used", async function (assert) {
      this.person = person;

      await render(
        hbs`<PersonalSuggestions::Entry @person={{this.person}} @used={{true}} />`,
      );

      assert.dom("li s").hasText("John Doe jd@example.com");
      assert.dom("span[icon=check].uk-text-success").exists();
    });

    test("it triggers an action on click", async function (assert) {
      this.person = person;
      this.select = (selectedEmail) => {
        assert.strictEqual(selectedEmail, person.email);
        assert.step("select");
      };

      await render(
        hbs`<PersonalSuggestions::Entry @person={{this.person}} @onSelect={{this.select}} />`,
      );

      await click("a");

      assert.verifySteps(["select"]);
    });
  },
);
