# Generated by Django 3.2.19 on 2023-11-24 11:57

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("user", "0023_user_name_surname_switch"),
    ]

    operations = [
        migrations.CreateModel(
            name="ServiceRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "function",
                    models.CharField(
                        choices=[("geometer", "Geometer")],
                        max_length=100,
                        verbose_name="Function the service provides",
                    ),
                ),
                (
                    "receiver",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="user.service",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="user.service",
                        verbose_name="Service providing the given function",
                    ),
                ),
            ],
            options={
                "unique_together": {("receiver", "function")},
            },
        ),
        migrations.AddField(
            model_name="service",
            name="functional_services",
            field=models.ManyToManyField(
                related_name="has_function_in",
                through="user.ServiceRelation",
                to="user.Service",
                verbose_name="Services that perform a specific function",
            ),
        ),
    ]
