# Generated by Django 3.2.19 on 2023-05-22 14:01

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def set_created_at_null(apps, schema_editor):
    apps.get_model("user", "UserGroup").objects.all().update(created_at=None)


class Migration(migrations.Migration):

    dependencies = [
        ("user", "0021_service_responsibility_construction_control"),
    ]

    operations = [
        migrations.AlterField(
            model_name="service",
            name="service_parent",
            field=models.ForeignKey(
                blank=True,
                db_column="SERVICE_PARENT_ID",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="service_children",
                to="user.service",
                verbose_name="Service parent",
            ),
        ),
        migrations.AddField(
            model_name="usergroup",
            name="created_at",
            field=models.DateTimeField(auto_now_add=True, null=True),
        ),
        migrations.AddField(
            model_name="usergroup",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.RunPython(set_created_at_null, migrations.RunPython.noop),
    ]
