# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-18 11:52
from __future__ import unicode_literals

import camac.user.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(db_column='USER_ID', primary_key=True, serialize=False)),
                ('username', models.CharField(db_column='USERNAME', max_length=250, unique=True)),
                ('password', models.CharField(blank=True, db_column='PASSWORD', max_length=50, null=True)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('surname', models.CharField(db_column='SURNAME', max_length=100)),
                ('email', models.CharField(blank=True, db_column='EMAIL', max_length=100, null=True)),
                ('phone', models.CharField(blank=True, db_column='PHONE', max_length=100, null=True)),
                ('disabled', models.PositiveSmallIntegerField(db_column='DISABLED', default=0)),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('last_login', models.DateTimeField(blank=True, db_column='LAST_REQUEST_DATE', null=True)),
                ('address', models.CharField(blank=True, db_column='ADDRESS', max_length=100, null=True)),
                ('city', models.CharField(blank=True, db_column='CITY', max_length=100, null=True)),
                ('zip', models.CharField(blank=True, db_column='ZIP', max_length=10, null=True)),
            ],
            options={
                'db_table': 'USER',
                'managed': True,
            },
            managers=[
                ('objects', camac.user.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('group_id', models.AutoField(db_column='GROUP_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('phone', models.CharField(blank=True, db_column='PHONE', max_length=100, null=True)),
                ('zip', models.CharField(blank=True, db_column='ZIP', max_length=10, null=True)),
                ('city', models.CharField(blank=True, db_column='CITY', max_length=100, null=True)),
                ('address', models.CharField(blank=True, db_column='ADDRESS', max_length=100, null=True)),
                ('email', models.CharField(blank=True, db_column='EMAIL', max_length=100, null=True)),
                ('website', models.CharField(blank=True, db_column='WEBSITE', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'GROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='GroupLocation',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'GROUP_LOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('location_id', models.AutoField(db_column='LOCATION_ID', primary_key=True, serialize=False)),
                ('communal_cantonal_number', models.IntegerField(blank=True, db_column='COMMUNAL_CANTONAL_NUMBER', null=True)),
                ('communal_federal_number', models.CharField(blank=True, db_column='COMMUNAL_FEDERAL_NUMBER', max_length=255, null=True)),
                ('district_number', models.IntegerField(blank=True, db_column='DISTRICT_NUMBER', null=True)),
                ('section_number', models.IntegerField(blank=True, db_column='SECTION_NUMBER', null=True)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
                ('commune_name', models.CharField(blank=True, db_column='COMMUNE_NAME', max_length=100, null=True)),
                ('district_name', models.CharField(blank=True, db_column='DISTRICT_NAME', max_length=100, null=True)),
                ('section_name', models.CharField(blank=True, db_column='SECTION_NAME', max_length=100, null=True)),
                ('zip', models.CharField(blank=True, db_column='ZIP', max_length=10, null=True)),
            ],
            options={
                'db_table': 'LOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('role_id', models.AutoField(db_column='ROLE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100, unique=True)),
                ('role_parent', models.ForeignKey(blank=True, db_column='ROLE_PARENT_ID', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'ROLE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('service_id', models.AutoField(db_column='SERVICE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100, unique=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=255, null=True)),
                ('sort', models.IntegerField(db_column='SORT')),
                ('phone', models.CharField(blank=True, db_column='PHONE', max_length=100, null=True)),
                ('zip', models.CharField(blank=True, db_column='ZIP', max_length=10, null=True)),
                ('city', models.CharField(blank=True, db_column='CITY', max_length=100, null=True)),
                ('address', models.CharField(blank=True, db_column='ADDRESS', max_length=100, null=True)),
                ('email', models.CharField(blank=True, db_column='EMAIL', max_length=100, null=True)),
                ('website', models.CharField(blank=True, db_column='WEBSITE', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'SERVICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ServiceGroup',
            fields=[
                ('service_group_id', models.AutoField(db_column='SERVICE_GROUP_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100, unique=True)),
            ],
            options={
                'db_table': 'SERVICE_GROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('default_group', models.PositiveSmallIntegerField(db_column='DEFAULT_GROUP')),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='user_groups', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'USER_GROUP',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='service',
            name='service_group',
            field=models.ForeignKey(db_column='SERVICE_GROUP_ID', on_delete=django.db.models.deletion.PROTECT, related_name='+', to='user.ServiceGroup'),
        ),
        migrations.AddField(
            model_name='service',
            name='service_parent',
            field=models.ForeignKey(blank=True, db_column='SERVICE_PARENT_ID', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='grouplocation',
            name='location',
            field=models.ForeignKey(db_column='LOCATION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Location'),
        ),
        migrations.AddField(
            model_name='group',
            name='locations',
            field=models.ManyToManyField(through='user.GroupLocation', to='user.Location'),
        ),
        migrations.AddField(
            model_name='group',
            name='role',
            field=models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.PROTECT, related_name='+', to='user.Role'),
        ),
        migrations.AddField(
            model_name='group',
            name='service',
            field=models.ForeignKey(blank=True, db_column='SERVICE_ID', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(through='user.UserGroup', to='user.Group'),
        ),
        migrations.AlterUniqueTogether(
            name='usergroup',
            unique_together=set([('user', 'group')]),
        ),
        migrations.AlterUniqueTogether(
            name='grouplocation',
            unique_together=set([('group', 'location')]),
        ),
    ]
