DMS = {
    "default": {
        "ADD_HEADER_DATA": True,
        "USE_NUMBER_SEPARATOR": False,
    },
    "demo": {
        "ENABLED": True,
        "FORM": {
            "_base": {
                "people_sources": [
                    "personalien-gesuchstellerin",
                    "personalien-vertreterin-mit-vollmacht",
                    "personalien-grundeigentumerin",
                    "personalien-gebaudeeigentumerin",
                    "personalien-projektverfasserin",
                ],
                "people_names": {
                    "name-gesuchstellerin": "familyName",
                    "vorname-gesuchstellerin": "givenName",
                    "name-juristische-person-gesuchstellerin": "juristicName",
                    "name-vertreterin": "familyName",
                    "vorname-vertreterin": "givenName",
                    "name-juristische-person-vertreterin": "juristicName",
                    "name-grundeigentuemerin": "familyName",
                    "vorname-grundeigentuemerin": "givenName",
                    "name-juristische-person-grundeigentuemerin": "juristicName",
                    "name-gebaeudeeigentuemerin": "familyName",
                    "vorname-gebaeudeeigentuemerin": "givenName",
                    "name-juristische-person-gebaeudeeigentuemerin": "juristicName",
                    "name-projektverfasserin": "familyName",
                    "vorname-projektverfasserin": "givenName",
                    "name-juristische-person-projektverfasserin": "juristicName",
                },
            },
            "baugesuch": {
                "forms": [
                    "baugesuch",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button",
                    "dokumente-platzhalter",
                ],
            },
        },
        "ADD_HEADER_DATA": False,
    },
    "kt_bern": {
        "ENABLED": True,
        "FORM": {
            "_base": {
                "people_sources": [
                    # bulding permit
                    "personalien-gesuchstellerin",
                    "personalien-vertreterin-mit-vollmacht",
                    "personalien-grundeigentumerin",
                    "personalien-gebaudeeigentumerin",
                    "personalien-projektverfasserin",
                    "personalien-tragwerksplanerin-v5",
                    "personalien-sb",
                    # sb1 & sb2
                    "personalien-sb1-sb2",
                ],
                "people_names": {
                    "name-gesuchstellerin": "familyName",
                    "vorname-gesuchstellerin": "givenName",
                    "name-juristische-person-gesuchstellerin": "juristicName",
                    "name-vertreterin": "familyName",
                    "vorname-vertreterin": "givenName",
                    "name-juristische-person-vertreterin": "juristicName",
                    "name-grundeigentuemerin": "familyName",
                    "vorname-grundeigentuemerin": "givenName",
                    "name-juristische-person-grundeigentuemerin": "juristicName",
                    "name-gebaeudeeigentuemerin": "familyName",
                    "vorname-gebaeudeeigentuemerin": "givenName",
                    "name-juristische-person-gebaeudeeigentuemerin": "juristicName",
                    "name-projektverfasserin": "familyName",
                    "vorname-projektverfasserin": "givenName",
                    "name-juristische-person-projektverfasserin": "juristicName",
                    "name-tragwerksplanerin-v5": "familyName",
                    "vorname-tragwerksplanerin-v5": "givenName",
                    "name-juristische-person-tragwerksplanerin-v5": "juristicName",
                },
            },
            "baugesuch": {
                "forms": [
                    "baugesuch",
                    "baugesuch-v2",
                    "baugesuch-v3",
                    "baugesuch-v5",
                    "baugesuch-mit-uvp",
                    "baugesuch-mit-uvp-v2",
                    "baugesuch-mit-uvp-v3",
                    "baugesuch-mit-uvp-v5",
                    "baugesuch-generell",
                    "baugesuch-generell-v2",
                    "baugesuch-generell-v3",
                    "baugesuch-generell-v5",
                    "hecken-feldgehoelze-baeume",
                    "baupolizeiliches-verfahren",
                    "zutrittsermaechtigung",
                    "klaerung-baubewilligungspflicht",
                    "verlaengerung-geltungsdauer",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "projektaenderung",
                    "einreichen-button",
                    "karte",
                    "dokumente-platzhalter",
                ],
            },
            "vorabklaerung": {
                "forms": [
                    "vorabklaerung-einfach",
                    "vorabklaerung-einfach-v4",
                    "vorabklaerung-vollstaendig",
                    "vorabklaerung-vollstaendig-v2",
                    "vorabklaerung-vollstaendig-v3",
                    "vorabklaerung-vollstaendig-v4",
                    "vorabklaerung-vollstaendig-v5",
                    "solaranlagen-meldung",
                    "heat-generator",
                    "heat-generator-v2",
                    "reklamegesuch",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "projektaenderung",
                    "einreichen-button",
                    "karte",
                    "dokumente-platzhalter",
                ],
            },
            "migriertes-dossier": {
                "forms": [
                    "migriertes-dossier",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [],
            },
            "selbstdeklaration": {
                "forms": ["sb1", "sb2", "sb1-v2"],
                "template": "form",
                "personalien": "personalien-sb1-sb2",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button-sb1",
                    "einreichen-button-sb2",
                    "dokumente-sb1",
                    "dokumente-sb2",
                    "dokumente-platzhalter",
                ],
            },
            "regular-exams": {
                "forms": ["fp-form", "fp-form-v2", "bab-form"],
                "template": "audit-form",
                "exclude_slugs": [
                    "bab-01-07-1972-um-und-ausgebaut-meldung",
                    "bab-naehe-von-schutzenswerten-gebaeuden-meldung",
                ],
            },
            "material-exam": {
                "forms": ["mp-form"],
                "template": "form",
            },
        },
    },
    "kt_gr": {
        "ENABLED": True,
        "USE_NUMBER_SEPARATOR": True,
        "FORM": {
            "_base": {
                "people_sources": [
                    "personalien-gesuchstellerin",
                    "personalien-vertreterin-mit-vollmacht",
                    "personalien-grundeigentumerin",
                    "personalien-gebaudeeigentumerin",
                    "personalien-projektverfasserin",
                ],
                "people_names": {
                    "name-gesuchstellerin": "familyName",
                    "vorname-gesuchstellerin": "givenName",
                    "name-juristische-person-gesuchstellerin": "juristicName",
                    "name-vertreterin": "familyName",
                    "vorname-vertreterin": "givenName",
                    "name-juristische-person-vertreterin": "juristicName",
                    "name-grundeigentuemerin": "familyName",
                    "vorname-grundeigentuemerin": "givenName",
                    "name-juristische-person-grundeigentuemerin": "juristicName",
                    "name-gebaeudeeigentuemerin": "familyName",
                    "vorname-gebaeudeeigentuemerin": "givenName",
                    "name-juristische-person-gebaeudeeigentuemerin": "juristicName",
                    "name-projektverfasserin": "familyName",
                    "vorname-projektverfasserin": "givenName",
                    "name-juristische-person-projektverfasserin": "juristicName",
                },
            },
            "baugesuch": {
                "forms": [
                    "baugesuch",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button",
                    "dokumente",
                    "einreichen",
                    "bestaetigung",
                    "gis-map",
                ],
            },
            "bauanzeige": {
                "forms": [
                    "bauanzeige",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button",
                    "dokumente-ohne-pflichtdokumente",
                    "dokumente-platzhalter",
                    "einreichen",
                    "bestaetigung",
                    "gis-map",
                ],
            },
            "vorlaeufige-beurteilung": {
                "forms": [
                    "vorlaeufige-beurteilung",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button",
                    "dokumente-ohne-pflichtdokumente",
                    "dokumente-platzhalter",
                    "einreichen",
                    "bestaetigung",
                    "gis-map",
                ],
            },
            "solaranlage": {
                "forms": [
                    "solaranlage",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen-button",
                    "dokumente-ohne-pflichtdokumente",
                    "dokumente-platzhalter",
                    "einreichen",
                    "bestaetigung",
                    "gis-map",
                ],
            },
        },
        "ALEXANDRIA_DOCUMENT_CATEGORIES": [
            "beilagen-zum-gesuch-grundstuecksangaben",
            "beilagen-zum-gesuch-gutachten-nachweise-begruendungen",
            "beilagen-zum-gesuch-brandschutz",
            "beilagen-zum-gesuch-weitere-gesuchsunterlagen",
        ],
    },
    "kt_so": {
        "ENABLED": True,
        "USE_NUMBER_SEPARATOR": True,
        "FORM": {
            "_base": {
                "people_sources": [
                    "bauherrin",
                    "grundeigentuemerin",
                    "projektverfasserin",
                ],
                "people_names": {
                    "nachname": "familyName",
                    "vorname": "givenName",
                    "juristische-person-name": "juristicName",
                },
            },
            "baugesuch": {
                "forms": [
                    "baugesuch",
                    "erdwaermesonden",
                    "migriertes-dossier",
                    "voranfrage",
                    "meldung",
                    "meldung-pv",
                ],
                "template": "form",
                "personalien": "personalien",
                "exclude_slugs": [
                    # Forms
                    "allgemeine-informationen",
                    "dokumente",
                    "einreichen",
                    # Questions
                    "is-paper",
                    "projektaenderung",
                ],
            },
        },
        "ALEXANDRIA_DOCUMENT_CATEGORIES": [
            "beilagen-zum-gesuch-grundstuecksangaben",
            "beilagen-zum-gesuch-gutachten-nachweise-begruendungen",
            "beilagen-zum-gesuch-projektplaene-projektbeschrieb",
            "beilagen-zum-gesuch-weitere-gesuchsunterlagen",
        ],
    },
    "kt_uri": {
        "ENABLED": True,
        "FORM": {
            "building-permit": {
                "forms": [
                    "building-permit",
                    "preliminary-clarification",
                    "commercial-permit",
                    "proposal-declaration",
                    "solar-declaration",
                    "cantonal-territory-usage",
                    "technische-bewilligung",
                    "oereb",
                    "mitbericht-kanton",
                    "mitbericht-bund",
                    "bgbb",
                    "archivdossier",
                    "konzession-waermeentnahme",
                    "bohrbewilligung-waermeentnahme",
                    "pgv-gemeindestrasse",
                    "oereb-verfahren-gemeinde",
                ],
                "people_sources": [
                    "applicant",
                    "landowner",
                    "project-author",
                ],
                "people_names": {
                    "last-name": "familyName",
                    "first-name": "givenName",
                },
                "template": "2-level-extended",
                "personalien": "personalien",
                "exclude_slugs": [
                    "is-paper",
                    "einreichen",
                    "gis-karte",
                    "form-type",
                    "allgemeine-informationen-baugesuch",
                    "allgemeine-informationen-reklamegesuch",
                    "allgemeine-informationen-baugesuch-vorabklaerung",
                    "allgemeine-informationen-meldung-solaranlage",
                    "allgemeine-informationen-proposal-declaration",
                    "allgemeine-informationen-cantonal-territory-usage",
                    "allgemeine-informationen-mitbericht-kanton",
                    "allgemeine-informationen-oereb-verfahren",
                    "allgemeine-informationen-mitberichtsverfahren-bund",
                    "parzellen-oder-baurechtsnummer",
                ],
            },
        },
        "ADD_HEADER_DATA": False,
    },
}
