# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-11-20 07:28
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0018_auto_20181119_1558'),
        ('instance', '0007_formt_instancestatet'),
        ('user', '0003_auto_20181119_1558'),
    ]

    operations = [
        migrations.CreateModel(
            name='ASetresponsiblegroup',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('table_name', models.CharField(db_column='TABLE_NAME', max_length=30)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
                ('is_service_responsible', models.NullBooleanField(db_column='IS_SERVICE_RESPONSIBLE')),
                ('is_required', models.NullBooleanField(db_column='IS_REQUIRED')),
            ],
            options={
                'db_table': 'A_SETRESPONSIBLEGROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditresponsiblegroup',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('table_name', models.CharField(db_column='TABLE_NAME', max_length=30)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
                ('responsible_role', models.ForeignKey(blank=True, db_column='RESPONSIBLE_ROLE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'IR_EDITRESPONSIBLEGROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditresponsibleuser',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('table_name', models.CharField(blank=True, db_column='TABLE_NAME', max_length=30, null=True)),
                ('column_name', models.CharField(blank=True, db_column='COLUMN_NAME', max_length=30, null=True)),
                ('is_service_responsible', models.NullBooleanField(db_column='IS_SERVICE_RESPONSIBLE')),
                ('is_required', models.NullBooleanField(db_column='IS_REQUIRED')),
            ],
            options={
                'db_table': 'IR_EDITRESPONSIBLEUSER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ResponsibleAllocation',
            fields=[
                ('allocation_id', models.AutoField(db_column='ALLOCATION_ID', primary_key=True, serialize=False)),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group')),
                ('location', models.ForeignKey(db_column='LOCATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Location')),
            ],
            options={
                'db_table': 'RESPONSIBLE_ALLOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ResponsibleService',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('responsible_user', models.ForeignKey(db_column='RESPONSIBLE_USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'RESPONSIBLE_SERVICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ResponsibleServiceAllocation',
            fields=[
                ('service_allocation_id', models.AutoField(db_column='SERVICE_ALLOCATION_ID', primary_key=True, serialize=False)),
                ('location', models.ForeignKey(db_column='LOCATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Location')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'RESPONSIBLE_SERVICE_ALLOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ResponsibleServiceLog',
            fields=[
                ('responsible_service_log_id', models.AutoField(db_column='RESPONSIBLE_SERVICE_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(blank=True, db_column='USER_ID', null=True)),
                ('action', models.CharField(blank=True, db_column='ACTION', max_length=5, null=True)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('id1', models.IntegerField(blank=True, db_column='ID1', null=True)),
                ('field1', models.CharField(blank=True, db_column='FIELD1', max_length=30, null=True)),
                ('id2', models.IntegerField(blank=True, db_column='ID2', null=True)),
                ('field2', models.CharField(blank=True, db_column='FIELD2', max_length=30, null=True)),
            ],
            options={
                'db_table': 'RESPONSIBLE_SERVICE_LOG',
                'managed': True,
            },
        ),
    ]
