# Generated by Django 3.2.19 on 2023-11-13 12:54

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import localized_fields.fields.text_field


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('instance', '0038_alexandria_reference'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('user', '0023_user_name_surname_switch'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessLevel',
            fields=[
                ('slug', models.SlugField(max_length=100, primary_key=True, serialize=False)),
                ('name', localized_fields.fields.text_field.LocalizedTextField(required=['de'])),
                ('description', localized_fields.fields.text_field.LocalizedTextField(required=['de'])),
                ('required_grant_type', models.CharField(blank=True, choices=[('SERVICE', 'Service'), ('USER', 'User'), ('AUTHENTICATED_PUBLIC', 'Authenticated Public'), ('ANONYMOUS_PUBLIC', 'Anonymous Public'), ('TOKEN', 'Token')], max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='InstanceACL',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(blank=True, default=None, max_length=250, null=True)),
                ('start_time', models.DateTimeField(auto_now_add=True, help_text='At this time, the ACL becomes valid')),
                ('end_time', models.DateTimeField(default=None, help_text='At this time, the ACL becomes invalid', null=True)),
                ('created_by_event', models.CharField(blank=True, max_length=250, null=True)),
                ('revoked_by_event', models.CharField(blank=True, max_length=250, null=True)),
                ('grant_type', models.CharField(choices=[('SERVICE', 'Service'), ('USER', 'User'), ('AUTHENTICATED_PUBLIC', 'Authenticated Public'), ('ANONYMOUS_PUBLIC', 'Anonymous Public'), ('TOKEN', 'Token')], max_length=50)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('revoked_at', models.DateTimeField(blank=True, default=None, null=True)),
                ('metainfo', models.JSONField(default=None, null=True)),
                ('access_level', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='acls', to='permissions.accesslevel')),
                ('created_by_service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.service')),
                ('created_by_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('instance', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='acls', to='instance.instance')),
                ('revoked_by_service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.service')),
                ('revoked_by_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='acls', to='user.service')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='acls', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
