# Generated by Django 2.2.9 on 2020-01-30 14:27
from datetime import date

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


def migrate_objection(apps, schema_editor):
    FormField = apps.get_model("instance", "FormField")
    Objection = apps.get_model("objection", "Objection")
    ObjectionParticipant = apps.get_model("objection", "ObjectionParticipant")

    for form_field in FormField.objects.filter(name="einsprecher"):
        objection = Objection.objects.create(
            creation_date=date.today(), instance=form_field.instance
        )
        for objecter in form_field.value:
            ObjectionParticipant.objects.create(
                company=objecter["firma"],
                name=objecter["name"],
                address=objecter["strasse"],
                city=objecter["ort"],
                phone=objecter["tel"],
                email=objecter["email"],
                objection=objection,
            )


class Migration(migrations.Migration):

    initial = True

    dependencies = [("instance", "0015_instance_service")]

    operations = [
        migrations.CreateModel(
            name="Objection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("creation_date", models.DateField()),
                (
                    "instance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="objections",
                        to="instance.Instance",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ObjectionParticipant",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("company", models.CharField(blank=True, max_length=200, null=True)),
                ("name", models.CharField(blank=True, max_length=200, null=True)),
                ("address", models.CharField(blank=True, max_length=100, null=True)),
                ("city", models.CharField(blank=True, max_length=100, null=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                ("phone", models.CharField(blank=True, max_length=50, null=True)),
                (
                    "representative",
                    models.PositiveSmallIntegerField(
                        default=0,
                        validators=[django.core.validators.MaxValueValidator(1)],
                    ),
                ),
                (
                    "objection",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="objection_participants",
                        to="objection.Objection",
                    ),
                ),
            ],
        ),
        migrations.RunPython(migrate_objection),
    ]
