# Generated by Django 2.2.9 on 2020-02-07 12:56

from django.db import migrations, models
import django.db.models.deletion
from django.utils.text import slugify
from django.utils import translation
from django.conf import settings


def add_slugs(apps, schema_editor):
    Notification = apps.get_model("notification", "NotificationTemplate")
    NotificationT = apps.get_model("notification", "NotificationTemplateT")

    for notification in Notification.objects.all():
        purpose = notification.purpose
        # Get translation if the field is not available
        if not purpose:
            lang = translation.get_language()
            match = notification.trans.filter(language=lang).first()
            if not match:
                match = notification.trans.filter(
                    language=settings.LANGUAGE_CODE
                ).first()
            purpose = match.purpose

        slug = slugify(purpose)
        notification.slug = slug
        notification.save()

        for notificationt in NotificationT.objects.filter(template=notification):
            notificationt.template_slug = notification
            notificationt.save()


class Migration(migrations.Migration):

    dependencies = [
        ("notification", "0005_auto_20190902_1604"),
    ]

    operations = [
        migrations.AddField(
            model_name="notificationtemplate",
            name="slug",
            # unique is required, otherwise we get an error on this step:
            # there is no unique constraint matching given keys for
            # referenced table "NOTIFICATION_TEMPLATE"
            #
            # TODO: check whether defining unique as true here is
            # problematic with existing data
            field=models.SlugField(
                db_index=False, unique=True, max_length=100, null=True
            ),
        ),
        migrations.AddField(
            model_name="notificationtemplatet",
            name="template_slug",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="notification.NotificationTemplate",
                to_field="slug",
                null=True,
            ),
        ),
        migrations.RunPython(add_slugs),
        migrations.AlterField(
            model_name="notificationtemplate",
            name="slug",
            field=models.SlugField(db_index=False, max_length=100, unique=True),
        ),
        migrations.AlterField(
            model_name="notificationtemplatet",
            name="template_slug",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="notification.NotificationTemplate",
                to_field="slug",
            ),
        ),
    ]
