# Generated by Django 3.2.19 on 2023-11-14 09:35

from django.db import migrations, models

CHAPTER = 20001
QUESTION = 20037
ITEM = 1


def migrate_feedback(apps, schema_editor):
    Answer = apps.get_model("core", "Answer")
    Instance = apps.get_model("instance", "Instance")

    Instance.objects.annotate(
        legacy_rejection_feedback=Answer.objects.filter(
            instance=models.OuterRef("pk"),
            chapter=CHAPTER,
            question=QUESTION,
            item=ITEM,
        ).values("answer")[:1]
    ).filter(legacy_rejection_feedback__isnull=False).update(
        rejection_feedback=models.F("legacy_rejection_feedback")
    )


class Migration(migrations.Migration):
    dependencies = [
        ("instance", "0038_alexandria_reference"),
    ]

    operations = [
        migrations.AddField(
            model_name="instance",
            name="rejection_feedback",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.RunPython(migrate_feedback, migrations.RunPython.noop),
    ]
