# Generated by Django 2.2.16 on 2020-09-28 11:46

from logging import getLogger

from caluma.caluma_user.models import BaseUser
from caluma.caluma_workflow.api import skip_work_item
from caluma.caluma_workflow.models import Case, WorkItem
from django.conf import settings
from django.db import migrations

log = getLogger(__name__)


def fix_cases(apps, schema_editor):
    Instance = apps.get_model("instance", "Instance")
    instances = Instance.objects.filter(
        instance_state__name__in=["sb2", "conclusion", "finished"]
    )

    if not instances.exists() or settings.APPLICATION_NAME != "kt_bern":
        return

    for instance in instances:
        # this uses imported models because we need to use the caluma API
        try:
            case = Case.objects.get(**{"meta__camac-instance-id": instance.pk})
        except Case.DoesNotExist:
            log.warning(f"No case for instance {instance.pk} found -- skipping")
            continue

        user = BaseUser()

        instance_service = instance.instance_services.filter(
            active=1, service__service_group__pk=3
        ).first()

        if instance_service:
            user.group = instance_service.service.pk
        else:
            log.warning(f"No construction control found for instance {instance.pk}")

        sb1 = case.work_items.filter(task_id="sb1", status=WorkItem.STATUS_READY)
        if sb1.exists():
            skip_work_item(sb1.first(), user)

        sb2 = case.work_items.filter(task_id="sb2", status=WorkItem.STATUS_READY)
        if sb2.exists() and instance.instance_state.name in ["conclusion", "finished"]:
            skip_work_item(sb2.first(), user)

        complete = case.work_items.filter(
            task_id="complete", status=WorkItem.STATUS_READY
        )
        if complete.exists() and instance.instance_state.name == "finished":
            skip_work_item(complete.first(), user)


class Migration(migrations.Migration):
    dependencies = [("instance", "0024_auto_20200917_1518")]
    operations = [migrations.RunPython(fix_cases, migrations.RunPython.noop)]
