# Generated by Django 2.2.10 on 2020-02-28 12:49

from django.db import migrations
from django.db.models import Q

from logging import getLogger

logger = getLogger()


def migrate(apps, schema):
    Document = apps.get_model("caluma_form", "Document")
    HistoricalDocument = apps.get_model("caluma_form", "HistoricalDocument")

    for document in Document.objects.filter(meta__has_key="submit-date"):
        # get the historical document which was created because the submit date
        # was first set
        submit_historical_document = (
            HistoricalDocument.objects.filter(
                Q(id=document.id)
                & Q(meta__has_key="submit-date")
                & ~Q(meta__has_key="ebau-number")
            )
            .order_by("history_date")
            .first()
        )

        if not submit_historical_document:
            # the document was created before the historical documents existed.
            # The history for that document does not exist
            logger.debug(
                f"Instance {document.meta.get('camac-instance-id')}: No historical document found for the submit date"
            )

            continue

        submit_date = submit_historical_document.history_date.strftime(
            "%Y-%m-%dT%H:%M:%S%z"
        )

        # update the document with the correct submit date
        document.meta.update({"submit-date": submit_date})
        document.save()

        for historical_doc in HistoricalDocument.objects.filter(
            id=document.id, meta__has_key="submit-date"
        ):
            # update the existing historical documents with the new submit date
            historical_doc.meta.update({"submit-date": submit_date})
            historical_doc.save()


class Migration(migrations.Migration):

    dependencies = [("instance", "0016_caluma_instance_id_index")]

    operations = [migrations.RunPython(migrate, migrations.RunPython.noop)]
