# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-06-27 10:42
from __future__ import unicode_literals

from django.db import migrations
from camac.constants import kt_bern as constants


def migrate_instance_states(apps, schema_editor):
    Instance = apps.get_model("instance.Instance")
    instances_with_old_states = Instance.objects.filter(
        instance_state__in=(
            constants.INSTANCE_STATE_ALLGEMEINE_INFORMATIONEN,
            constants.INSTANCE_STATE_FREIGABEQUITTUNG,
            constants.INSTANCE_STATE_NUTZUNG_BAUVORHABEN,
            constants.INSTANCE_STATE_VORABKLAERUNG_EINFACH,
            constants.INSTANCE_STATE_INFORMATION_UEBER_GRUNDSTUECK,
            constants.INSTANCE_STATE_AUSWAHL_SPEZIALFORMULARE,
            constants.INSTANCE_STATE_BAUWERK,
            constants.INSTANCE_STATE_BESTAETIGUNG,
            constants.INSTANCE_STATE_DOKUMENTE,
        )
    )

    instances_with_old_states.update(instance_state=constants.INSTANCE_STATE_NEW)


class Migration(migrations.Migration):

    dependencies = [("instance", "0012_auto_20190607_1500")]

    operations = [migrations.RunPython(migrate_instance_states)]
