# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-10-22 12:51
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


def assign_journal_entry_service(apps, schema_editor):
    JournalEntry = apps.get_model("instance", "JournalEntry")
    entries = JournalEntry.objects.all()
    for entry in entries:
        entry.service = entry.group.service
        entry.save()


class Migration(migrations.Migration):

    dependencies = [
        ("user", "0002_auto_20180531_1314"),
        ("instance", "0004_journalentry"),
    ]

    operations = [
        migrations.AddField(
            model_name="journalentry",
            name="service",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="user.Service",
            ),
        ),
        migrations.RunPython(assign_journal_entry_service),
    ]
