# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-11-20 07:28
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0018_auto_20181119_1558'),
        ('instance', '0007_formt_instancestatet'),
        ('user', '0003_auto_20181119_1558'),
    ]

    operations = [
        migrations.CreateModel(
            name='AFilecheckcontent',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'A_FILECHECKCONTENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFilesavepdf',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('file_name', models.CharField(blank=True, db_column='FILE_NAME', max_length=50, null=True)),
                ('show_all_page_form_mode', models.PositiveSmallIntegerField(db_column='SHOW_ALL_PAGE_FORM_MODE')),
                ('template', models.CharField(db_column='TEMPLATE', max_length=500)),
                ('pdf_class', models.CharField(db_column='PDF_CLASS', max_length=500)),
                ('separate_pages', models.PositiveSmallIntegerField(db_column='SEPARATE_PAGES')),
                ('new_version', models.NullBooleanField(db_column='NEW_VERSION')),
            ],
            options={
                'db_table': 'A_FILESAVEPDF',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFilesavepdfContentpage',
            fields=[
                ('a_filesavepdf_contentpage_id', models.AutoField(db_column='A_FILESAVEPDF_CONTENTPAGE_ID', primary_key=True, serialize=False)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.AFilesavepdf')),
            ],
            options={
                'db_table': 'A_FILESAVEPDF_CONTENTPAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFilesavepdfT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('file_name', models.CharField(blank=True, db_column='FILE_NAME', max_length=50, null=True)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.AFilesavepdf')),
            ],
            options={
                'db_table': 'A_FILESAVEPDF_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFilesdownload',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
            ],
            options={
                'db_table': 'A_FILESDOWNLOAD',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFilesdownloadContent',
            fields=[
                ('a_filesdownload_content_id', models.AutoField(db_column='A_FILESDOWNLOAD_CONTENT_ID', primary_key=True, serialize=False)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.AFilesdownload')),
            ],
            options={
                'db_table': 'A_FILESDOWNLOAD_CONTENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFiletransition',
            fields=[
                ('action_id', models.AutoField(db_column='ACTION_ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'A_FILETRANSITION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFiletransitionDate',
            fields=[
                ('a_filetransition_date_id', models.AutoField(db_column='A_FILETRANSITION_DATE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=30)),
            ],
            options={
                'db_table': 'A_FILETRANSITION_DATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('file_id', models.AutoField(db_column='FILE_ID', primary_key=True, serialize=False)),
                ('file_mime_type', models.IntegerField(blank=True, db_column='FILE_MIME_TYPE_ID', db_index=True, null=True)),
                ('name', models.CharField(db_column='NAME', max_length=250)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('creation_date', models.DateTimeField(db_column='CREATION_DATE')),
                ('file_date', models.DateTimeField(blank=True, db_column='FILE_DATE', null=True)),
                ('size', models.IntegerField(blank=True, db_column='SIZE', null=True)),
                ('is_physical_document', models.PositiveSmallIntegerField(db_column='IS_PHYSICAL_DOCUMENT')),
                ('filename', models.CharField(blank=True, db_column='FILENAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'FILE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileComplementReq',
            fields=[
                ('file_complement_req_id', models.AutoField(db_column='FILE_COMPLEMENT_REQ_ID', primary_key=True, serialize=False)),
                ('complement_date', models.DateTimeField(db_column='COMPLEMENT_DATE')),
                ('confirm_date', models.DateTimeField(blank=True, db_column='CONFIRM_DATE', null=True)),
                ('expire_date', models.DateTimeField(blank=True, db_column='EXPIRE_DATE', null=True)),
                ('response_date', models.DateTimeField(blank=True, db_column='RESPONSE_DATE', null=True)),
                ('content', models.TextField(db_column='CONTENT')),
                ('answer_note', models.TextField(blank=True, db_column='ANSWER_NOTE', null=True)),
            ],
            options={
                'db_table': 'FILE_COMPLEMENT_REQ',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileComplementReqLog',
            fields=[
                ('file_complement_req_log_id', models.AutoField(db_column='FILE_COMPLEMENT_REQ_LOG_ID', primary_key=True, serialize=False)),
                ('id', models.IntegerField(db_column='ID')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
            ],
            options={
                'db_table': 'FILE_COMPLEMENT_REQ_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileComplementState',
            fields=[
                ('file_complement_state_id', models.AutoField(db_column='FILE_COMPLEMENT_STATE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'FILE_COMPLEMENT_STATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileComplementStateT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('file_complement_state', models.ForeignKey(db_column='FILE_COMPLEMENT_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileComplementState')),
            ],
            options={
                'db_table': 'FILE_COMPLEMENT_STATE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContent',
            fields=[
                ('file_content_id', models.AutoField(db_column='FILE_CONTENT_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=200, null=True)),
                ('url', models.CharField(blank=True, db_column='URL', max_length=500, null=True)),
                ('sort', models.IntegerField(db_column='SORT')),
                ('is_enabled', models.PositiveSmallIntegerField(db_column='IS_ENABLED')),
                ('tooltip', models.CharField(blank=True, db_column='TOOLTIP', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'FILE_CONTENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentCategory',
            fields=[
                ('file_content_category_id', models.AutoField(db_column='FILE_CONTENT_CATEGORY_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=200, null=True)),
                ('sort', models.IntegerField(db_column='SORT')),
                ('is_enabled', models.PositiveSmallIntegerField(db_column='IS_ENABLED')),
            ],
            options={
                'db_table': 'FILE_CONTENT_CATEGORY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentCategoryT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=200, null=True)),
                ('file_content_category', models.ForeignKey(db_column='FILE_CONTENT_CATEGORY_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContentCategory')),
            ],
            options={
                'db_table': 'FILE_CONTENT_CATEGORY_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.ForeignKey(db_column='FILE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.File')),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileContent')),
            ],
            options={
                'db_table': 'FILE_CONTENT_FILE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentFileLog',
            fields=[
                ('file_content_file_log_id', models.AutoField(db_column='FILE_CONTENT_FILE_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
            ],
            options={
                'db_table': 'FILE_CONTENT_FILE_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent')),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form')),
            ],
            options={
                'db_table': 'FILE_CONTENT_FORM',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentMimeType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent')),
            ],
            options={
                'db_table': 'FILE_CONTENT_MIME_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_complement_req', models.ForeignKey(db_column='FILE_COMPLEMENT_REQ_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileComplementReq')),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileContent')),
            ],
            options={
                'db_table': 'FILE_CONTENT_REQUEST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentRequestLog',
            fields=[
                ('file_content_request_log_id', models.AutoField(db_column='FILE_CONTENT_REQUEST_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
            ],
            options={
                'db_table': 'FILE_CONTENT_REQUEST_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentRequired',
            fields=[
                ('file_content_required_id', models.AutoField(db_column='FILE_CONTENT_REQUIRED_ID', primary_key=True, serialize=False)),
                ('answer', models.CharField(blank=True, db_column='ANSWER', max_length=4000, null=True)),
                ('always_required', models.PositiveSmallIntegerField(db_column='ALWAYS_REQUIRED')),
                ('chapter', models.ForeignKey(blank=True, db_column='CHAPTER_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent')),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form')),
                ('question', models.ForeignKey(blank=True, db_column='QUESTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
            ],
            options={
                'db_table': 'FILE_CONTENT_REQUIRED',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileContentT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=200, null=True)),
                ('url', models.CharField(blank=True, db_column='URL', max_length=500, null=True)),
                ('tooltip', models.CharField(blank=True, db_column='TOOLTIP', max_length=1000, null=True)),
                ('file_content', models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent')),
            ],
            options={
                'db_table': 'FILE_CONTENT_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileFormat',
            fields=[
                ('file_format_id', models.AutoField(db_column='FILE_FORMAT_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
            ],
            options={
                'db_table': 'FILE_FORMAT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileFormatT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
                ('file_format', models.ForeignKey(db_column='FILE_FORMAT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileFormat')),
            ],
            options={
                'db_table': 'FILE_FORMAT_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileLog',
            fields=[
                ('file_log_id', models.AutoField(db_column='FILE_LOG_ID', primary_key=True, serialize=False)),
                ('id', models.IntegerField(db_column='ID')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
            ],
            options={
                'db_table': 'FILE_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileMimeType',
            fields=[
                ('file_mime_type_id', models.AutoField(db_column='FILE_MIME_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('extension', models.CharField(db_column='EXTENSION', max_length=10)),
            ],
            options={
                'db_table': 'FILE_MIME_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileValidationType',
            fields=[
                ('file_validation_type_id', models.AutoField(db_column='FILE_VALIDATION_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'FILE_VALIDATION_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileValidationTypeT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
                ('file_validation_type', models.ForeignKey(db_column='FILE_VALIDATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileValidationType')),
            ],
            options={
                'db_table': 'FILE_VALIDATION_TYPE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileValidTypeFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('validation_date', models.DateTimeField(db_column='VALIDATION_DATE')),
                ('file', models.ForeignKey(db_column='FILE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.File')),
                ('file_validation_type', models.ForeignKey(db_column='FILE_VALIDATION_TYPE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileValidationType')),
            ],
            options={
                'db_table': 'FILE_VALID_TYPE_FILE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FileValidTypeFileLog',
            fields=[
                ('file_valid_type_file_log_id', models.AutoField(db_column='FILE_VALID_TYPE_FILE_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
            ],
            options={
                'db_table': 'FILE_VALID_TYPE_FILE_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFileAccessType',
            fields=[
                ('ir_file_access_type_id', models.AutoField(db_column='IR_FILE_ACCESS_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
            ],
            options={
                'db_table': 'IR_FILE_ACCESS_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFilecomplementanswer',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('enable_unlink', models.PositiveSmallIntegerField(db_column='ENABLE_UNLINK')),
                ('enable_physical_document', models.PositiveSmallIntegerField(db_column='ENABLE_PHYSICAL_DOCUMENT')),
                ('enable_format', models.PositiveSmallIntegerField(db_column='ENABLE_FORMAT')),
                ('accessible_after_expiration', models.PositiveSmallIntegerField(db_column='ACCESSIBLE_AFTER_EXPIRATION')),
                ('ir_file_access_type', models.ForeignKey(db_column='IR_FILE_ACCESS_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileAccessType')),
            ],
            options={
                'db_table': 'IR_FILECOMPLEMENTANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFilecomplementreqCc',
            fields=[
                ('ir_filecomplementreq_cc_id', models.AutoField(db_column='IR_FILECOMPLEMENTREQ_CC_ID', primary_key=True, serialize=False)),
                ('file_content_category', models.ForeignKey(db_column='FILE_CONTENT_CATEGORY_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContentCategory')),
            ],
            options={
                'db_table': 'IR_FILECOMPLEMENTREQ_CC',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFilecomplementrequest',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('enable_expiring_date', models.PositiveSmallIntegerField(db_column='ENABLE_EXPIRING_DATE')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('ir_file_access_type', models.ForeignKey(db_column='IR_FILE_ACCESS_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileAccessType')),
            ],
            options={
                'db_table': 'IR_FILECOMPLEMENTREQUEST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFilelist',
            fields=[
                ('instance_resource_id', models.AutoField(db_column='INSTANCE_RESOURCE_ID', primary_key=True, serialize=False)),
                ('access_foreign_id', models.CharField(blank=True, db_column='ACCESS_FOREIGN_ID', max_length=100, null=True)),
                ('file_validation_type', models.ForeignKey(blank=True, db_column='FILE_VALIDATION_TYPE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileValidationType')),
                ('ir_file_access_type', models.ForeignKey(db_column='IR_FILE_ACCESS_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileAccessType')),
            ],
            options={
                'db_table': 'IR_FILELIST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFileupload',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('enable_unlink', models.PositiveSmallIntegerField(db_column='ENABLE_UNLINK')),
                ('enable_physical_document', models.PositiveSmallIntegerField(db_column='ENABLE_PHYSICAL_DOCUMENT')),
                ('enable_format', models.PositiveSmallIntegerField(db_column='ENABLE_FORMAT')),
                ('enable_unlink_different_state', models.PositiveSmallIntegerField(db_column='ENABLE_UNLINK_DIFFERENT_STATE')),
                ('ir_file_access_type', models.ForeignKey(db_column='IR_FILE_ACCESS_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileAccessType')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_FILEUPLOAD',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFileuploadCc',
            fields=[
                ('ir_fileupload_cc_id', models.AutoField(db_column='IR_FILEUPLOAD_CC_ID', primary_key=True, serialize=False)),
                ('file_content_category', models.ForeignKey(db_column='FILE_CONTENT_CATEGORY_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContentCategory')),
                ('instance_resource', models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileupload')),
            ],
            options={
                'db_table': 'IR_FILEUPLOAD_CC',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFilevalidation',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('ir_file_access_type', models.ForeignKey(db_column='IR_FILE_ACCESS_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFileAccessType')),
                ('read_file_validation_type', models.ForeignKey(db_column='READ_FILE_VALIDATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileValidationType')),
                ('write_file_validation_type', models.ForeignKey(db_column='WRITE_FILE_VALIDATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileValidationType')),
            ],
            options={
                'db_table': 'IR_FILEVALIDATION',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='irfilecomplementreqcc',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.IrFilecomplementrequest'),
        ),
        migrations.AddField(
            model_name='filecontentmimetype',
            name='file_mime_type',
            field=models.ForeignKey(db_column='FILE_MIME_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileMimeType'),
        ),
        migrations.AddField(
            model_name='filecontent',
            name='file_content_category',
            field=models.ForeignKey(db_column='FILE_CONTENT_CATEGORY_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileContentCategory'),
        ),
        migrations.AddField(
            model_name='filecomplementreq',
            name='file_complement_state',
            field=models.ForeignKey(db_column='FILE_COMPLEMENT_STATE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileComplementState'),
        ),
        migrations.AddField(
            model_name='filecomplementreq',
            name='group',
            field=models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group'),
        ),
        migrations.AddField(
            model_name='filecomplementreq',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='filecomplementreq',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='file',
            name='file_complement_req',
            field=models.ForeignKey(blank=True, db_column='FILE_COMPLEMENT_REQ_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileComplementReq'),
        ),
        migrations.AddField(
            model_name='file',
            name='file_format',
            field=models.ForeignKey(blank=True, db_column='FILE_FORMAT_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.FileFormat'),
        ),
        migrations.AddField(
            model_name='file',
            name='group',
            field=models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group'),
        ),
        migrations.AddField(
            model_name='file',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='file',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='file',
            name='last_version_file',
            field=models.ForeignKey(blank=True, db_column='LAST_VERSION_FILE_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='file.File'),
        ),
        migrations.AddField(
            model_name='file',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='afiletransition',
            name='a_filetransition_date',
            field=models.ForeignKey(blank=True, db_column='A_FILETRANSITION_DATE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.AFiletransitionDate'),
        ),
        migrations.AddField(
            model_name='afiletransition',
            name='current_state',
            field=models.ForeignKey(blank=True, db_column='CURRENT_STATE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileComplementState'),
        ),
        migrations.AddField(
            model_name='afiletransition',
            name='next_state',
            field=models.ForeignKey(db_column='NEXT_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileComplementState'),
        ),
        migrations.AddField(
            model_name='afilesdownloadcontent',
            name='file_content',
            field=models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent'),
        ),
        migrations.AddField(
            model_name='afilesavepdfcontentpage',
            name='file_content',
            field=models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent'),
        ),
        migrations.AddField(
            model_name='afilesavepdfcontentpage',
            name='page',
            field=models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page'),
        ),
        migrations.AddField(
            model_name='afilesavepdf',
            name='file_content',
            field=models.ForeignKey(db_column='FILE_CONTENT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContent'),
        ),
        migrations.AddField(
            model_name='afilesavepdf',
            name='file_content_category',
            field=models.ForeignKey(db_column='FILE_CONTENT_CATEGORY_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='file.FileContentCategory'),
        ),
        migrations.AddField(
            model_name='afilesavepdf',
            name='page_form_group',
            field=models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup'),
        ),
        migrations.AlterUniqueTogether(
            name='filevalidtypefile',
            unique_together=set([('file_validation_type', 'file')]),
        ),
        migrations.AlterUniqueTogether(
            name='filevalidationtypet',
            unique_together=set([('file_validation_type', 'language')]),
        ),
        migrations.AlterUniqueTogether(
            name='fileformatt',
            unique_together=set([('file_format', 'language')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentt',
            unique_together=set([('file_content', 'language')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentrequest',
            unique_together=set([('file_content', 'file_complement_req')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentmimetype',
            unique_together=set([('file_content', 'file_mime_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentform',
            unique_together=set([('file_content', 'form')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentfile',
            unique_together=set([('file_content', 'file')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecontentcategoryt',
            unique_together=set([('file_content_category', 'language')]),
        ),
        migrations.AlterUniqueTogether(
            name='filecomplementstatet',
            unique_together=set([('file_complement_state', 'language')]),
        ),
        migrations.AlterUniqueTogether(
            name='afilesavepdft',
            unique_together=set([('action', 'language')]),
        ),
    ]
