# Generated by Django 2.2.17 on 2021-10-21 09:13

import uuid

import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
import simple_history.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('user', '0014_servicegroup_sort'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalDossierImport',
            fields=[
                ('history_user_id', models.CharField(max_length=150, null=True)),
                ('created_at', models.DateTimeField(blank=True, db_index=True, editable=False)),
                ('modified_at', models.DateTimeField(blank=True, db_index=True, editable=False)),
                ('created_by_user', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('created_by_group', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('modified_by_user', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('modified_by_group', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('status', models.CharField(choices=[('done', 'done'), ('new', 'new'), ('in-progres', 'in-progres'), ('verified', 'verified'), ('done', 'done'), ('failed', 'failed')], default='new', max_length=32)),
                ('messages', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('service', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
            ],
            options={
                'verbose_name': 'historical dossier import',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='DossierImport',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('created_by_user', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('created_by_group', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('modified_by_user', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('modified_by_group', models.CharField(blank=True, db_index=True, max_length=150, null=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('status', models.CharField(choices=[('done', 'done'), ('new', 'new'), ('in-progres', 'in-progres'), ('verified', 'verified'), ('done', 'done'), ('failed', 'failed')], default='new', max_length=32)),
                ('messages', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='user.Service')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
