# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-10-22 09:15
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


def ensure_attachment_service(apps, schema_editor):
    """Ensure that attachment which has a group also has a service."""

    Attachment = apps.get_model("document", "Attachment")
    attachments = Attachment.objects.filter(service__isnull=True, group__isnull=False)
    for attachment in attachments:
        attachment.service = attachment.group.service
        attachment.save()


def assign_template_service(apps, schema_editor):
    Template = apps.get_model("document", "Template")
    templates = Template.objects.filter(group__isnull=False)
    for template in templates:
        template.service = template.group.service
        template.save()


class Migration(migrations.Migration):

    dependencies = [("document", "0005_attachment_question")]

    operations = [
        migrations.AddField(
            model_name="template",
            name="service",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="templates",
                to="user.Service",
            ),
        ),
        migrations.AlterField(
            model_name="attachmentsectionserviceacl",
            name="mode",
            field=models.CharField(
                choices=[
                    ("read", "Read permissions"),
                    ("write", "Read and write permissions"),
                    ("admin", "Read, write and delete permissions"),
                ],
                db_column="MODE",
                max_length=20,
            ),
        ),
        migrations.RunPython(ensure_attachment_service),
        migrations.RunPython(assign_template_service),
    ]
