# Generated by Django 4.2.13 on 2024-06-12 12:59

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0108_instanceresource_require_permission'),
    ]

    operations = [
        # https://adamj.eu/tech/2023/02/23/migrate-django-postgresql-ci-fields-case-insensitive-collation/
        #
        # We use a raw SQL statement to create that collation because the
        # CreateCollation operation from the django package does not allow use
        # to add the "IF NOT EXISTS" condition. This is required because we
        # already create that collation in the DB setup as we need it for
        # testing environments that don't run the django migrations.
        #
        # definition of locale: und-u-ks-level2
        #   und: undetermined language, sorts symbols first, then alphabetically per script.
        #   -u-: Unicode "Extension U" keyword
        #   ks-level2: collation strength level 2, doesn’t include case in comparisons, only letters and accents
        migrations.RunSQL(
            "CREATE COLLATION IF NOT EXISTS case_insensitive (provider = icu, locale = 'und-u-ks-level2', deterministic = false)",
            "DROP COLLATION IF EXISTS case_insensitive",
        )
    ]
