# Generated by Django 2.2.17 on 2021-11-04 15:18
from django.db import migrations


def forwards_func(apps, schema_editor):
    BillingEntry = apps.get_model("core", "BillingV2Entry")
    for entry in BillingEntry.objects.all():
        calc = entry.calculation
        if calc == "flat":
            entry.final_rate = entry.total_cost
        elif calc == "percentage":
            entry.final_rate = (entry.total_cost * entry.percentage) / 100
        elif calc == "hourly":
            entry.final_rate = entry.hours * entry.hourly_rate
        else:
            raise Exception(f"Calculation mode {calc} not know to this migration.")

        if entry.tax_mode in ["exclusive", "exclusive-2"]:
            entry.final_rate += (entry.final_rate * entry.tax_rate) / 100

        entry.save()


class Migration(migrations.Migration):

    dependencies = [("core", "0090_auto_20211221_0825")]

    operations = [migrations.RunPython(forwards_func, migrations.RunPython.noop)]
