# Generated by Django 2.2.17 on 2021-09-30 14:30

from django.conf import settings
from django.db import migrations

WORKFLOW_ITEM_PKS = [
    1,
    12,
    16,
    21,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    70,
    71,
    72,
    73,
    74,
    79,
    80,
]


def remove_workflowitems(apps, schema_editor):
    """
    Migration for removing unnecessary workflow-items and workflow-entries for schwyz.
    """
    if settings.APPLICATION_NAME == "kt_schwyz":
        WorkflowEntry = apps.get_model("core", "WorkflowEntry")
        WorkflowEntry.objects.filter(workflow_item__pk__in=WORKFLOW_ITEM_PKS).delete()

        WorkflowItem = apps.get_model("core", "WorkflowItem")
        WorkflowItem.objects.filter(pk__in=WORKFLOW_ITEM_PKS).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0085_publicaton_views"),
    ]

    operations = [
        migrations.RunPython(
            remove_workflowitems, reverse_code=migrations.RunPython.noop
        ),
    ]
