# Generated by Django 2.2.13 on 2020-07-22 11:37

from django.db import migrations, models
from django.db.models import Q
import django.db.models.deletion


def cleanup_invalid_notices(apps, schema_editor):
    """Delete activation callback notices that violate referential integrity."""

    activation_callback_notice = apps.get_model("core", "ActivationCallbackNotice")
    activations = apps.get_model("core", "Activation").objects.all()
    circulations = apps.get_model("core", "Circulation").objects.all()

    activation_callback_notice.objects.filter(
        ~Q(activation_id__in=activations) | ~Q(circulation_id__in=circulations)
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0066_auto_20200624_1324"),
    ]

    operations = [
        migrations.RunPython(
            cleanup_invalid_notices, reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name="activationcallbacknotice",
            name="activation_id",
            field=models.ForeignKey(
                db_column="ACTIVATION_ID",
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Activation",
            ),
        ),
        migrations.AlterField(
            model_name="activationcallbacknotice",
            name="circulation_id",
            field=models.ForeignKey(
                db_column="CIRCULATION_ID",
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Circulation",
            ),
        ),
    ]
