# Generated by Django 2.2.12 on 2020-06-09 12:28

from django.conf import settings
from django.db import migrations


def remove_legacy_caluma_answers(apps, schema_editor):
    """Get rid of historical answers that don't have a matching question anymore.

    Same for historical documents and dynamic options, which also have
    references to config-based models.
    """

    if not settings.APPLICATION.get("FORM_BACKEND") == "caluma":
        return

    HistoricalAnswer = apps.get_model("caluma_form", "HistoricalAnswer")
    HistoricalAnswer.objects.filter(question__type__isnull=True).delete()

    HistoricalDocument = apps.get_model("caluma_form", "HistoricalDocument")
    HistoricalDocument.objects.filter(form__name__isnull=True).delete()

    HistoricalDynamicOption = apps.get_model("caluma_form", "HistoricalDynamicOption")
    HistoricalDynamicOption.objects.filter(question__type__isnull=True).delete()


class Migration(migrations.Migration):

    dependencies = [("core", "0059_dynamic_options_cleanup")]

    operations = [
        migrations.RunPython(
            remove_legacy_caluma_answers, reverse_code=migrations.RunPython.noop
        )
    ]
