# Generated by Django 2.2.10 on 2020-03-23 08:32

from django.db import migrations


def replace_table_question(apps, schema_editor):
    Document = apps.get_model("caluma_form", "Document")

    Document.objects.filter(form_id="verantwortliche-person-sb-tabelle").update(
        form_id="personalien-tabelle"
    )

    Answer = apps.get_model("caluma_form", "Answer")

    answers = Answer.objects.filter(
        question_id__in=[
            "vorname-sb",
            "telefon-oder-mobile-sb",
            "strasse-sb",
            "plz-sb",
            "ort-sb",
            "nummer-sb",
            "name-sb",
            "name-juristische-person-sb",
            "juristische-person-sb",
            "e-mail-sb",
        ]
    )

    for answer in answers:
        answer.question_id = f"{answer.question_id.rsplit('-sb', 1)[0]}-gesuchstellerin"
        if answer.value == "juristische-person-sb-nein":
            answer.value = "juristische-person-gesuchstellerin-nein"
        elif answer.value == "juristische-person-sb-ja":
            answer.value = "juristische-person-gesuchstellerin-ja"

        answer.save()

    Form = apps.get_model("caluma_form", "Form")

    sb_table_form = Form.objects.filter(
        slug="verantwortliche-person-sb-tabelle"
    ).first()

    if sb_table_form:
        sb_table_form.questions.all().delete()

        Question = apps.get_model("caluma_form", "Question")

        Question.objects.filter(row_form_id="verantwortliche-person-sb-tabelle").update(
            row_form_id="personalien-tabelle"
        )

    Form.objects.filter(slug="verantwortliche-person-sb-tabelle").delete()


class Migration(migrations.Migration):

    dependencies = [("core", "0051_publication_anzeiger")]

    operations = [
        migrations.RunPython(
            replace_table_question, reverse_code=migrations.RunPython.noop
        )
    ]
