# Generated by Django 2.2.9 on 2020-02-07 12:19

from django.db import migrations, models
import django.db.models.deletion


def anotification_slug(apps, schema_editor):
    ANotification = apps.get_model("core", "ANotification")

    for anotification in ANotification.objects.all():
        anotification.template_slug = anotification.template
        anotification.save()


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0049_add_missing_dynamic_options"),
        ("notification", "0006_notificationtemplate_slug"),
    ]

    operations = [
        migrations.AddField(
            model_name="anotification",
            name="template_slug",
            field=models.ForeignKey(
                db_column="TEMPLATE_SLUG",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="notification.NotificationTemplate",
                to_field="slug",
                null=True,
            ),
        ),
        migrations.RunPython(anotification_slug, migrations.RunPython.noop),
        migrations.RemoveField(model_name="anotification", name="template",),
        migrations.RenameField(
            model_name="anotification", old_name="template_slug", new_name="template",
        ),
        migrations.AlterField(
            model_name="anotification",
            name="template",
            field=models.ForeignKey(
                db_column="TEMPLATE_ID",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="notification.NotificationTemplate",
                to_field="slug",
            ),
        ),
    ]
