# Generated by Django 2.2.10 on 2020-02-20 13:11

from caluma.caluma_data_source.data_source_handlers import get_data_source_data
from django.db import migrations

DATA_SOURCE_DATA = {}


def get_data(data_source):
    data = DATA_SOURCE_DATA.get(data_source)
    if data is None:
        data = {d.slug: d.label for d in get_data_source_data(True, data_source)}
        DATA_SOURCE_DATA[data_source] = data
    return data


def get_label_from_data_source(question, slug):
    data = get_data(question.data_source)
    return data.get(slug, slug)


def add_missing_dynamic_options(apps, schema_editor):
    Answer = apps.get_model("caluma_form", "Answer")
    DynamicOption = apps.get_model("caluma_form", "DynamicOption")

    answers = Answer.objects.filter(
        question__type__in=["dynamic_choice", "dynamic_multiple_choice"]
    )

    for answer in answers:
        if answer.question.type == "dynamic_choice":
            answer.value = [answer.value]
        for slug in answer.value:
            if (
                slug is None
                or DynamicOption.objects.filter(
                    document=answer.document, question=answer.question, slug=slug
                ).exists()
            ):
                continue

            DynamicOption.objects.create(
                document=answer.document,
                question=answer.question,
                slug=slug,
                label=get_label_from_data_source(answer.question, slug),
                created_by_user=answer.created_by_user,
                created_by_group=answer.created_by_group,
            )


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0048_auto_20200123_1053"),
        ("caluma_form", "0030_auto_20200219_1359"),
    ]

    operations = [
        migrations.RunPython(add_missing_dynamic_options, migrations.RunPython.noop)
    ]
