# -*- coding: utf-8 -*-
# Generated by Django 1.11.22 on 2019-11-04 11:50
from __future__ import unicode_literals

from django.db import migrations


def move_journal_entries(apps, schema_editor):
    Journal = apps.get_model("core", "Journal")
    JournalT = apps.get_model("core", "JournalT")

    for entry in Journal.objects.all():
        JournalT.objects.create(
            journal=entry,
            language="de",
            text=entry.text,
            additional_text=entry.additional_text,
        )
        entry.text = None
        entry.additional_text = None
        entry.save()


class Migration(migrations.Migration):

    dependencies = [("core", "0043_journal_translation")]

    operations = [migrations.RunPython(move_journal_entries)]
