# -*- coding: utf-8 -*-
# Generated by Django 1.11.22 on 2019-10-01 11:38
from __future__ import unicode_literals

from django.db import migrations
from django.db.models import Count
from django.conf import settings


def migrate(apps, schema_editor):
    InstanceService = apps.get_model("core", "InstanceService")
    filters = (
        settings.APPLICATION.get("ACTIVE_SERVICES", {})
        .get("MUNICIPALITY", {})
        .get("FILTERS", {})
    )

    # get instances which have more than one active instance service
    duplicates = (
        InstanceService.objects.filter(active=1, **filters)
        .values("instance")
        .annotate(Count("id"))
        .order_by()
        .filter(id__count__gt=1)
    )

    for duplicate in duplicates:
        # get all active instance services of this instance
        instance_services = InstanceService.objects.filter(
            active=1, **filters, instance__pk=duplicate["instance"]
        )

        # delete all of those instance services except the first one
        instance_services.exclude(
            pk=instance_services.order_by("-pk").first().pk
        ).delete()


class Migration(migrations.Migration):
    dependencies = [("core", "0039_archive")]
    operations = [migrations.RunPython(migrate)]
