# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-11-19 14:58
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('instance', '0007_formt_instancestatet'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('user', '0003_auto_20181119_1558'),
        ('core', '0017_auto_20181026_1014'),
    ]

    operations = [
        migrations.RunSQL("""
DROP VIEW "INTENTIONS";
DROP VIEW "PRESET_INTENTIONS";
"""),
        migrations.CreateModel(
            name='ACirculationEmailT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('title', models.CharField(blank=True, db_column='TITLE', max_length=200, null=True)),
                ('text', models.CharField(blank=True, db_column='TEXT', max_length=2000, null=True)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ACirculationEmail')),
            ],
            options={
                'db_table': 'A_CIRCULATION_EMAIL_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ActionT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('success_message', models.CharField(blank=True, db_column='SUCCESS_MESSAGE', max_length=1000, null=True)),
                ('error_message', models.CharField(blank=True, db_column='ERROR_MESSAGE', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'ACTION_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AEmailT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('title', models.CharField(blank=True, db_column='TITLE', max_length=200, null=True)),
                ('text', models.CharField(blank=True, db_column='TEXT', max_length=2000, null=True)),
            ],
            options={
                'db_table': 'A_EMAIL_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AnswerListT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'ANSWER_LIST_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AProposalT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('reason', models.CharField(blank=True, db_column='REASON', max_length=50, null=True)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AProposal')),
            ],
            options={
                'db_table': 'A_PROPOSAL_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BillingV2Entry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
                ('date_added', models.DateField()),
                ('tax_mode', models.CharField(choices=[('inclusive', 'Incl 7.7%'), ('exclusive', 'Excl 7.7%'), ('exempt', 'Tax exempt')], max_length=20)),
                ('calculation', models.CharField(choices=[('flat', 'Flat rate'), ('percentage', 'Percentage'), ('hourly', 'Hourly')], max_length=20)),
                ('tax_rate', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('hours', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('hourly_rate', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('percentage', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('total_cost', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('final_rate', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'BILLING_V2_ENTRY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ButtonT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'BUTTON_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=500, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'CHAPTER_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationAnswerT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'CIRCULATION_ANSWER_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationAnswerTypeT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'CIRCULATION_ANSWER_TYPE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationReasonT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'CIRCULATION_REASON_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationStateT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=100, null=True)),
            ],
            options={
                'db_table': 'CIRCULATION_STATE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationTypeT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'CIRCULATION_TYPE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocxDecision',
            fields=[
                ('instance', models.AutoField(db_column='INSTANCE_ID', primary_key=True, serialize=False, verbose_name='instance.Instance')),
                ('decision', models.CharField(db_column='DECISION', max_length=30)),
                ('decision_type', models.CharField(blank=True, db_column='DECISION_TYPE', max_length=30, null=True)),
                ('decision_date', models.DateField(db_column='DECISION_DATE')),
            ],
            options={
                'db_table': 'DOCX_DECISION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FormGroupT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=500, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'FORM_GROUP_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='GroupPermission',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('permission_id', models.CharField(db_column='PERMISSION_ID', max_length=100)),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'GROUP_PERMISSION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceFormwizard',
            fields=[
                ('instance', models.OneToOneField(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, related_name='+', serialize=False, to='instance.Instance')),
                ('pages', models.CharField(db_column='PAGES', max_length=500)),
            ],
            options={
                'db_table': 'INSTANCE_FORMWIZARD',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceFormwizardLog',
            fields=[
                ('instance_formwizard_log_id', models.AutoField(db_column='INSTANCE_FORMWIZARD_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id', models.IntegerField(db_column='ID')),
            ],
            options={
                'db_table': 'INSTANCE_FORMWIZARD_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceParent',
            fields=[
                ('instance', models.AutoField(db_column='INSTANCE_ID', primary_key=True, serialize=False, verbose_name='instance.Instance')),
                ('created', models.DateTimeField(db_column='CREATED')),
                ('parent', models.ForeignKey(db_column='PARENT_INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('service', models.ForeignKey(blank=True, db_column='SERVICE_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'INSTANCE_PARENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceResourceT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'INSTANCE_RESOURCE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceService',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.PositiveSmallIntegerField(db_column='ACTIVE', default=0)),
                ('activation_date', models.DateTimeField(blank=True, db_column='ACTIVATION_DATE', null=True)),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'INSTANCE_SERVICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditcirculationT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('default_circulation_name', models.CharField(blank=True, db_column='DEFAULT_CIRCULATION_NAME', max_length=500, null=True)),
                ('instance_resource', models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrEditcirculation')),
            ],
            options={
                'db_table': 'IR_EDITCIRCULATION_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditletterAnswerT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'IR_EDITLETTER_ANSWER_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFormwizardT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('summary', models.CharField(blank=True, db_column='SUMMARY', max_length=4000, null=True)),
            ],
            options={
                'db_table': 'IR_FORMWIZARD_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Journal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.CharField(choices=[('automatic', 'Automatic'), ('user', 'Manual entry by user')], db_column='MODE', max_length=20)),
                ('text', models.TextField(db_column='TEXT')),
                ('created', models.DateTimeField(db_column='CREATED')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('service', models.ForeignKey(blank=True, db_column='SERVICE_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'JOURNAL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='JournalActionConfig',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('text', models.TextField(blank=True, db_column='TEXT', null=True)),
            ],
            options={
                'db_table': 'JOURNAL_ACTION_CONFIG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='JournalActionConfigT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(db_column='TEXT')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('action', models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.JournalActionConfig')),
            ],
            options={
                'db_table': 'JOURNAL_ACTION_CONFIG_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Municipality',
            fields=[
                ('bfs_nr', models.IntegerField(db_column='BFS_NR', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('district_nr', models.PositiveSmallIntegerField(db_column='DISTRICT_NR')),
            ],
            options={
                'db_table': 'MUNICIPALITY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='NoticeTypeT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'NOTICE_TYPE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormGroupT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('page_form_group', models.ForeignKey(db_column='PAGE_FORM_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'PAGE_FORM_GROUP_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=500, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'PAGE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('instance', models.AutoField(db_column='INSTANCE_ID', primary_key=True, serialize=False, verbose_name='instance.Instance')),
                ('start', models.DateField(db_column='START_DATE')),
                ('end', models.DateField(db_column='END_DATE')),
                ('text', models.TextField(db_column='TEXT')),
            ],
            options={
                'db_table': 'PUBLICATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=500, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('default_answer', models.CharField(blank=True, db_column='DEFAULT_ANSWER', max_length=4000, null=True)),
            ],
            options={
                'db_table': 'QUESTION_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ResourceT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'RESOURCE_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RListColumnT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('alias', models.CharField(blank=True, db_column='ALIAS', max_length=30, null=True)),
            ],
            options={
                'db_table': 'R_LIST_COLUMN_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSearchColumnT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('alias', models.CharField(blank=True, db_column='ALIAS', max_length=30, null=True)),
            ],
            options={
                'db_table': 'R_SEARCH_COLUMN_T',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSearchFilterT',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(db_column='LANGUAGE', max_length=2)),
                ('label', models.CharField(blank=True, db_column='LABEL', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'R_SEARCH_FILTER_T',
                'managed': True,
            },
        ),
        migrations.DeleteModel(
            name='GlossaryCategory',
        ),
        migrations.DeleteModel(
            name='GlossarySentence',
        ),
        migrations.AddField(
            model_name='adeletecirculation',
            name='circulation_to_be_interpreted',
            field=models.CharField(blank=True, db_column='CIRCULATION_TO_BE_INTERPRETED', max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='adeletecirculation',
            name='is_single_delete',
            field=models.NullBooleanField(db_column='IS_SINGLE_DELETE'),
        ),
        migrations.AddField(
            model_name='irformwizard',
            name='goto_second_page',
            field=models.PositiveSmallIntegerField(db_column='GOTO_SECOND_PAGE', default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='irformwizard',
            name='hide_summary_page',
            field=models.PositiveSmallIntegerField(db_column='HIDE_SUMMARY_PAGE', default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='irformwizard',
            name='hide_summary_questions',
            field=models.PositiveSmallIntegerField(db_column='HIDE_SUMMARY_QUESTIONS', default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='irformwizard',
            name='php_class',
            field=models.CharField(blank=True, db_column='PHP_CLASS', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='action',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='aemail',
            name='text',
            field=models.CharField(blank=True, db_column='TEXT', max_length=2000, null=True),
        ),
        migrations.AlterField(
            model_name='aemail',
            name='title',
            field=models.CharField(blank=True, db_column='TITLE', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='answerlist',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=1000, null=True),
        ),
        migrations.AlterField(
            model_name='button',
            name='class_field',
            field=models.CharField(blank=True, db_column='CLASS', max_length=250, null=True),
        ),
        migrations.AlterField(
            model_name='button',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='chapter',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='circulationanswer',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='circulationanswertype',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='circulationreason',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='circulationstate',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='circulationtype',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='formgroup',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='instanceresource',
            name='class_field',
            field=models.CharField(blank=True, db_column='CLASS', max_length=250, null=True),
        ),
        migrations.AlterField(
            model_name='instanceresource',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='ireditletteranswer',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='noticetype',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='page',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='pageansweractivation',
            name='form',
            field=models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form'),
        ),
        migrations.AlterField(
            model_name='pageansweractivation',
            name='page',
            field=models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page'),
        ),
        migrations.AlterField(
            model_name='question',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='resource',
            name='name',
            field=models.CharField(blank=True, db_column='NAME', max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name='rlistcolumn',
            name='alias',
            field=models.CharField(blank=True, db_column='ALIAS', max_length=30, null=True),
        ),
        migrations.AlterField(
            model_name='rsearch',
            name='preserve_result',
            field=models.PositiveSmallIntegerField(db_column='PRESERVE_RESULT', default=0),
        ),
        migrations.AlterField(
            model_name='rsearchcolumn',
            name='alias',
            field=models.CharField(blank=True, db_column='ALIAS', max_length=30, null=True),
        ),
        migrations.AlterField(
            model_name='rsearchfilter',
            name='label',
            field=models.CharField(blank=True, db_column='LABEL', max_length=1000, null=True),
        ),
        migrations.AlterField(
            model_name='rsimplelist',
            name='instance_states',
            field=models.CharField(db_column='INSTANCE_STATES', max_length=400),
        ),
        migrations.AddField(
            model_name='rsearchfiltert',
            name='r_search_filter',
            field=models.ForeignKey(db_column='R_SEARCH_FILTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RSearchFilter'),
        ),
        migrations.AddField(
            model_name='rsearchcolumnt',
            name='r_search_column',
            field=models.ForeignKey(db_column='R_SEARCH_COLUMN_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RSearchColumn'),
        ),
        migrations.AddField(
            model_name='rlistcolumnt',
            name='r_list_column',
            field=models.ForeignKey(db_column='R_LIST_COLUMN_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RListColumn'),
        ),
        migrations.AddField(
            model_name='resourcet',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='questiont',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='paget',
            name='page',
            field=models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page'),
        ),
        migrations.AddField(
            model_name='noticetypet',
            name='notice_type',
            field=models.ForeignKey(db_column='NOTICE_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.NoticeType'),
        ),
        migrations.AddField(
            model_name='irformwizardt',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrFormwizard'),
        ),
        migrations.AddField(
            model_name='ireditletteranswert',
            name='ir_editletter_answer',
            field=models.ForeignKey(db_column='IR_EDITLETTER_ANSWER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrEditletterAnswer'),
        ),
        migrations.AddField(
            model_name='instanceresourcet',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='formgroupt',
            name='form_group',
            field=models.ForeignKey(db_column='FORM_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.FormGroup'),
        ),
        migrations.AddField(
            model_name='circulationtypet',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='circulationstatet',
            name='circulation_state_id',
            field=models.ForeignKey(db_column='CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationState'),
        ),
        migrations.AddField(
            model_name='circulationreasont',
            name='circulation_reason',
            field=models.ForeignKey(db_column='CIRCULATION_REASON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationReason'),
        ),
        migrations.AddField(
            model_name='circulationanswertypet',
            name='circulation_answer_type',
            field=models.ForeignKey(db_column='CIRCULATION_ANSWER_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationAnswerType'),
        ),
        migrations.AddField(
            model_name='circulationanswert',
            name='circulation_answer',
            field=models.ForeignKey(db_column='CIRCULATION_ANSWER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationAnswer'),
        ),
        migrations.AddField(
            model_name='chaptert',
            name='chapter',
            field=models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='buttont',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='billingv2entry',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='billingv2entry',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='answerlistt',
            name='answer_list',
            field=models.ForeignKey(db_column='ANSWER_LIST_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AnswerList'),
        ),
        migrations.AddField(
            model_name='aemailt',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AEmail'),
        ),
        migrations.AddField(
            model_name='actiont',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AlterUniqueTogether(
            name='grouppermission',
            unique_together=set([('group', 'permission_id')]),
        ),
        migrations.RunSQL("""
CREATE OR REPLACE VIEW "PRESET_INTENTIONS" ("NAME", "VALUE", "INSTANCE_ID") AS
SELECT
"ANSWER_LIST"."NAME",
"ANSWER_LIST"."VALUE",
"ANSWER"."INSTANCE_ID"
FROM
"ANSWER_LIST"
JOIN
"ANSWER" ON (
    "ANSWER"."QUESTION_ID" = 97
    AND
    "CHAPTER_ID" = 21
    AND
    "ITEM" = 1
)
WHERE
"ANSWER_LIST"."QUESTION_ID" = 97
AND
"ANSWER"."ANSWER"::jsonb ? "ANSWER_LIST"."VALUE";

CREATE OR REPLACE VIEW "INTENTIONS" AS
SELECT
"PRESET_INTENTIONS"."NAME"         "NAME",
"PRESET_INTENTIONS"."INSTANCE_ID"  "INSTANCE_ID"
FROM
"PRESET_INTENTIONS"
UNION
SELECT
"OTHER_INTENTIONS"."ANSWER"       "NAME",
"OTHER_INTENTIONS"."INSTANCE_ID"  "INSTANCE_ID"
FROM
"OTHER_INTENTIONS";
"""),
    ]
