# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-18 11:52
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('user', '0001_initial'),
        ('notification', '0001_initial'),
        ('instance', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('document', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ACopyanswerMapping',
            fields=[
                ('a_copyanswer_mapping_id', models.AutoField(db_column='A_COPYANSWER_MAPPING_ID', primary_key=True, serialize=False)),
                ('get_name', models.PositiveSmallIntegerField(db_column='GET_NAME')),
            ],
            options={
                'db_table': 'A_COPYANSWER_MAPPING',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACopydataMapping',
            fields=[
                ('a_copydata_mapping_id', models.AutoField(db_column='A_COPYDATA_MAPPING_ID', primary_key=True, serialize=False)),
                ('table_name', models.CharField(db_column='TABLE_NAME', max_length=30)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
                ('get_name', models.PositiveSmallIntegerField(db_column='GET_NAME')),
            ],
            options={
                'db_table': 'A_COPYDATA_MAPPING',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Action',
            fields=[
                ('action_id', models.AutoField(db_column='ACTION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('success_message', models.CharField(blank=True, db_column='SUCCESS_MESSAGE', max_length=1000, null=True)),
                ('error_message', models.CharField(blank=True, db_column='ERROR_MESSAGE', max_length=1000, null=True)),
                ('execute_always', models.PositiveSmallIntegerField(db_column='EXECUTE_ALWAYS')),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Activation',
            fields=[
                ('activation_id', models.AutoField(db_column='ACTIVATION_ID', primary_key=True, serialize=False)),
                ('start_date', models.DateTimeField(db_column='START_DATE')),
                ('deadline_date', models.DateTimeField(db_column='DEADLINE_DATE')),
                ('suspension_date', models.DateTimeField(blank=True, db_column='SUSPENSION_DATE', null=True)),
                ('end_date', models.DateTimeField(blank=True, db_column='END_DATE', null=True)),
                ('version', models.IntegerField(db_column='VERSION')),
                ('reason', models.CharField(blank=True, db_column='REASON', max_length=50, null=True)),
                ('email_sent', models.PositiveSmallIntegerField(db_column='EMAIL_SENT', default=1)),
                ('activation_parent', models.ForeignKey(blank=True, db_column='ACTIVATION_PARENT_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Activation')),
            ],
            options={
                'db_table': 'ACTIVATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ActivationAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item', models.IntegerField(db_column='ITEM')),
                ('answer', models.CharField(db_column='ANSWER', max_length=4000)),
                ('activation', models.ForeignKey(db_column='ACTIVATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Activation')),
            ],
            options={
                'db_table': 'ACTIVATION_ANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ActivationAnswerLog',
            fields=[
                ('activation_answer_log_id', models.AutoField(db_column='ACTIVATION_ANSWER_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
                ('id3', models.IntegerField(db_column='ID3')),
                ('field3', models.CharField(db_column='FIELD3', max_length=30)),
                ('id4', models.IntegerField(db_column='ID4')),
                ('field4', models.CharField(db_column='FIELD4', max_length=30)),
            ],
            options={
                'db_table': 'ACTIVATION_ANSWER_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ActivationLog',
            fields=[
                ('activation_log_id', models.AutoField(db_column='ACTIVATION_LOG_ID', primary_key=True, serialize=False)),
                ('id', models.IntegerField(db_column='ID')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
            ],
            options={
                'db_table': 'ACTIVATION_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AirAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('action_name', models.CharField(db_column='ACTION_NAME', max_length=50)),
                ('hidden', models.PositiveSmallIntegerField(db_column='HIDDEN')),
            ],
            options={
                'db_table': 'AIR_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ALocationQc',
            fields=[
                ('a_location_qc_id', models.AutoField(db_column='A_LOCATION_QC_ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'A_LOCATION_QC',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('item', models.IntegerField(db_column='ITEM')),
                ('answer', models.CharField(db_column='ANSWER', max_length=4000)),
            ],
            options={
                'db_table': 'ANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AnswerList',
            fields=[
                ('answer_list_id', models.AutoField(db_column='ANSWER_LIST_ID', primary_key=True, serialize=False)),
                ('value', models.CharField(db_column='VALUE', max_length=20)),
                ('name', models.CharField(db_column='NAME', max_length=300)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'ANSWER_LIST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AnswerLog',
            fields=[
                ('answer_log_id', models.AutoField(db_column='ANSWER_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
                ('id3', models.IntegerField(db_column='ID3')),
                ('field3', models.CharField(db_column='FIELD3', max_length=30)),
                ('id4', models.IntegerField(db_column='ID4')),
                ('field4', models.CharField(db_column='FIELD4', max_length=30)),
            ],
            options={
                'db_table': 'ANSWER_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AnswerQuery',
            fields=[
                ('answer_query_id', models.AutoField(db_column='ANSWER_QUERY_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
            ],
            options={
                'db_table': 'ANSWER_QUERY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AProposalHoliday',
            fields=[
                ('a_proposal_holiday_id', models.AutoField(db_column='A_PROPOSAL_HOLIDAY_ID', primary_key=True, serialize=False)),
                ('holiday_date', models.DateTimeField(db_column='HOLIDAY_DATE')),
            ],
            options={
                'db_table': 'A_PROPOSAL_HOLIDAY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ArAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('action_name', models.CharField(db_column='ACTION_NAME', max_length=50)),
                ('hidden', models.PositiveSmallIntegerField(db_column='HIDDEN')),
            ],
            options={
                'db_table': 'AR_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AttachmentExtension',
            fields=[
                ('attachment_extension_id', models.AutoField(db_column='ATTACHMENT_EXTENSION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=10)),
            ],
            options={
                'db_table': 'ATTACHMENT_EXTENSION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AttachmentExtensionRole',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('mode', models.CharField(blank=True, db_column='MODE', max_length=10, null=True)),
                ('attachment_extension', models.ForeignKey(db_column='ATTACHMENT_EXTENSION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AttachmentExtension')),
                ('role', models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'ATTACHMENT_EXTENSION_ROLE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AttachmentExtensionService',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('mode', models.CharField(blank=True, db_column='MODE', max_length=10, null=True)),
                ('attachment_extension', models.ForeignKey(db_column='ATTACHMENT_EXTENSION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AttachmentExtension')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'ATTACHMENT_EXTENSION_SERVICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Authority',
            fields=[
                ('authority_id', models.AutoField(db_column='AUTHORITY_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=128, null=True)),
            ],
            options={
                'db_table': 'AUTHORITY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AuthorityAuthorityType',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('authority_id', models.FloatField(db_column='AUTHORITY_ID')),
                ('authority_type_id', models.FloatField(db_column='AUTHORITY_TYPE_ID')),
            ],
            options={
                'db_table': 'AUTHORITY_AUTHORITY_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AuthorityLocation',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('authority', models.ForeignKey(db_column='AUTHORITY_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Authority')),
                ('location', models.ForeignKey(db_column='LOCATION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Location')),
            ],
            options={
                'db_table': 'AUTHORITY_LOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AuthorityType',
            fields=[
                ('authority_type_id', models.AutoField(db_column='AUTHORITY_TYPE_ID', primary_key=True, serialize=False)),
                ('tag', models.CharField(db_column='TAG', max_length=8)),
                ('name', models.CharField(db_column='NAME', max_length=128)),
            ],
            options={
                'db_table': 'AUTHORITY_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AvailableAction',
            fields=[
                ('available_action_id', models.CharField(db_column='AVAILABLE_ACTION_ID', max_length=25, primary_key=True, serialize=False)),
                ('module_name', models.CharField(db_column='MODULE_NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'AVAILABLE_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AvailableInstanceResource',
            fields=[
                ('available_instance_resource_id', models.CharField(db_column='AVAILABLE_INSTANCE_RESOURCE_ID', max_length=25, primary_key=True, serialize=False)),
                ('module_name', models.CharField(db_column='MODULE_NAME', max_length=50)),
                ('controller_name', models.CharField(db_column='CONTROLLER_NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'AVAILABLE_INSTANCE_RESOURCE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AvailableResource',
            fields=[
                ('available_resource_id', models.CharField(db_column='AVAILABLE_RESOURCE_ID', max_length=25, primary_key=True, serialize=False)),
                ('module_name', models.CharField(db_column='MODULE_NAME', max_length=50)),
                ('controller_name', models.CharField(db_column='CONTROLLER_NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'AVAILABLE_RESOURCE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BabUsage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('usage_type', models.IntegerField(db_column='USAGE_TYPE')),
                ('usage', models.FloatField(db_column='USAGE')),
            ],
            options={
                'db_table': 'BAB_USAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'B_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BillingAccount',
            fields=[
                ('billing_account_id', models.AutoField(db_column='BILLING_ACCOUNT_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=500)),
                ('account_number', models.CharField(blank=True, db_column='ACCOUNT_NUMBER', max_length=50, null=True)),
                ('department', models.CharField(blank=True, db_column='DEPARTMENT', max_length=255, null=True)),
                ('predefined', models.FloatField(blank=True, db_column='PREDEFINED', null=True)),
                ('service_group', models.ForeignKey(blank=True, db_column='SERVICE_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.ServiceGroup')),
            ],
            options={
                'db_table': 'BILLING_ACCOUNT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BillingAccountState',
            fields=[
                ('billing_account_state_id', models.AutoField(db_column='BILLING_ACCOUNT_STATE_ID', primary_key=True, serialize=False)),
                ('billing_account', models.ForeignKey(db_column='BILLING_ACCOUNT_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.BillingAccount')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
            ],
            options={
                'db_table': 'BILLING_ACCOUNT_STATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BillingConfig',
            fields=[
                ('billing_config_id', models.AutoField(db_column='BILLING_CONFIG_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('value', models.CharField(db_column='VALUE', max_length=300)),
            ],
            options={
                'db_table': 'BILLING_CONFIG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BillingEntry',
            fields=[
                ('billing_entry_id', models.AutoField(db_column='BILLING_ENTRY_ID', primary_key=True, serialize=False)),
                ('amount', models.FloatField(db_column='AMOUNT')),
                ('user_id', models.FloatField(blank=True, db_column='USER_ID', null=True)),
                ('created', models.DateTimeField(blank=True, db_column='CREATED', null=True)),
                ('amount_type', models.PositiveSmallIntegerField(db_column='AMOUNT_TYPE')),
                ('type', models.PositiveSmallIntegerField(db_column='TYPE')),
                ('reason', models.CharField(blank=True, db_column='REASON', max_length=300, null=True)),
                ('invoiced', models.PositiveSmallIntegerField(db_column='INVOICED')),
                ('billing_account', models.ForeignKey(blank=True, db_column='BILLING_ACCOUNT_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.BillingAccount')),
            ],
            options={
                'db_table': 'BILLING_ENTRY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'B_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'B_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityButton',
            fields=[
                ('building_authority_button_id', models.AutoField(db_column='BUILDING_AUTHORITY_BUTTON_ID', primary_key=True, serialize=False)),
                ('label', models.CharField(db_column='LABEL', max_length=512)),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_BUTTON',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityButtonstate',
            fields=[
                ('ba_button_state_id', models.AutoField(db_column='BA_BUTTON_STATE_ID', primary_key=True, serialize=False)),
                ('is_clicked', models.PositiveSmallIntegerField(db_column='IS_CLICKED')),
                ('is_disabled', models.PositiveSmallIntegerField(db_column='IS_DISABLED')),
                ('building_authority_button', models.ForeignKey(db_column='BUILDING_AUTHORITY_BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.BuildingAuthorityButton')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_BUTTONSTATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityComment',
            fields=[
                ('building_authority_comment_id', models.AutoField(db_column='BUILDING_AUTHORITY_COMMENT_ID', primary_key=True, serialize=False)),
                ('text', models.CharField(blank=True, db_column='TEXT', max_length=4000, null=True)),
                ('group', models.FloatField(db_column='GROUP')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_COMMENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityDoc',
            fields=[
                ('building_authority_doc_id', models.AutoField(db_column='BUILDING_AUTHORITY_DOC_ID', primary_key=True, serialize=False)),
                ('building_authority_button', models.ForeignKey(db_column='BUILDING_AUTHORITY_BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.BuildingAuthorityButton')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_DOC',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityEmail',
            fields=[
                ('building_authority_email_id', models.AutoField(db_column='BUILDING_AUTHORITY_EMAIL_ID', primary_key=True, serialize=False)),
                ('email_text', models.CharField(blank=True, db_column='EMAIL_TEXT', max_length=4000, null=True)),
                ('receiver_query', models.CharField(blank=True, db_column='RECEIVER_QUERY', max_length=4000, null=True)),
                ('email_subject', models.CharField(blank=True, db_column='EMAIL_SUBJECT', max_length=400, null=True)),
                ('from_email', models.CharField(blank=True, db_column='FROM_EMAIL', max_length=400, null=True)),
                ('from_name', models.CharField(blank=True, db_column='FROM_NAME', max_length=400, null=True)),
                ('building_authority_button', models.ForeignKey(db_column='BUILDING_AUTHORITY_BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.BuildingAuthorityButton')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_EMAIL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthorityItemDis',
            fields=[
                ('ba_item_dis_id', models.AutoField(db_column='BA_ITEM_DIS_ID', primary_key=True, serialize=False)),
                ('group', models.FloatField(db_column='GROUP')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_ITEM_DIS',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthoritySection',
            fields=[
                ('building_authority_section_id', models.AutoField(db_column='BUILDING_AUTHORITY_SECTION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=128)),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_SECTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BuildingAuthoritySectionDis',
            fields=[
                ('ba_section_dis_id', models.AutoField(db_column='BA_SECTION_DIS_ID', primary_key=True, serialize=False)),
                ('ba_section', models.ForeignKey(db_column='BA_SECTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.BuildingAuthoritySection')),
            ],
            options={
                'db_table': 'BUILDING_AUTHORITY_SECTION_DIS',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='BUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'B_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Button',
            fields=[
                ('button_id', models.AutoField(db_column='BUTTON_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('class_field', models.CharField(blank=True, db_column='CLASS', max_length=25, null=True)),
                ('hidden', models.PositiveSmallIntegerField(db_column='HIDDEN')),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'BUTTON',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Chapter',
            fields=[
                ('chapter_id', models.AutoField(db_column='CHAPTER_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=500)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('javascript', models.CharField(blank=True, db_column='JAVASCRIPT', max_length=4000, null=True)),
            ],
            options={
                'db_table': 'CHAPTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterPage',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('sort', models.IntegerField(db_column='SORT')),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
            ],
            options={
                'db_table': 'CHAPTER_PAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterPageGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
            ],
            options={
                'db_table': 'CHAPTER_PAGE_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterPageRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('role', models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'CHAPTER_PAGE_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterPageServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'CHAPTER_PAGE_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ChapterPageUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ChapterPage')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'CHAPTER_PAGE_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Circulation',
            fields=[
                ('circulation_id', models.AutoField(db_column='CIRCULATION_ID', primary_key=True, serialize=False)),
                ('instance_resource_id', models.IntegerField(db_column='INSTANCE_RESOURCE_ID', db_index=True)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
            ],
            options={
                'db_table': 'CIRCULATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationAnswer',
            fields=[
                ('circulation_answer_id', models.AutoField(db_column='CIRCULATION_ANSWER_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'CIRCULATION_ANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationAnswerType',
            fields=[
                ('circulation_answer_type_id', models.AutoField(db_column='CIRCULATION_ANSWER_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
            ],
            options={
                'db_table': 'CIRCULATION_ANSWER_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationLog',
            fields=[
                ('circulation_log_id', models.AutoField(db_column='CIRCULATION_LOG_ID', primary_key=True, serialize=False)),
                ('id', models.IntegerField(db_column='ID')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
            ],
            options={
                'db_table': 'CIRCULATION_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationReason',
            fields=[
                ('circulation_reason_id', models.AutoField(db_column='CIRCULATION_REASON_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'CIRCULATION_REASON',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationState',
            fields=[
                ('circulation_state_id', models.AutoField(db_column='CIRCULATION_STATE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=100)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'CIRCULATION_STATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CirculationType',
            fields=[
                ('circulation_type_id', models.AutoField(db_column='CIRCULATION_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('parent_specific_activations', models.PositiveSmallIntegerField(db_column='PARENT_SPECIFIC_ACTIVATIONS')),
            ],
            options={
                'db_table': 'CIRCULATION_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='CommissionAssignment',
            fields=[
                ('commission_assignment_id', models.AutoField(db_column='COMMISSION_ASSIGNMENT_ID', primary_key=True, serialize=False)),
                ('adder_id', models.FloatField(db_column='ADDER_ID')),
                ('date', models.DateTimeField(db_column='DATE')),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'COMMISSION_ASSIGNMENT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenActivationAction',
            fields=[
                ('docgen_activation_action_id', models.AutoField(db_column='DOCGEN_ACTIVATION_ACTION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=255)),
            ],
            options={
                'db_table': 'DOCGEN_ACTIVATION_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenActivationactionAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'DOCGEN_ACTIVATIONACTION_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenActivationDocket',
            fields=[
                ('docgen_activation_docket_id', models.AutoField(db_column='DOCGEN_ACTIVATION_DOCKET_ID', primary_key=True, serialize=False)),
                ('text', models.TextField(db_column='TEXT')),
                ('activation', models.ForeignKey(blank=True, db_column='ACTIVATION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Activation')),
            ],
            options={
                'db_table': 'DOCGEN_ACTIVATION_DOCKET',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenDocxAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'DOCGEN_DOCX_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenPdfAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'DOCGEN_PDF_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenTemplate',
            fields=[
                ('docgen_template_id', models.AutoField(db_column='DOCGEN_TEMPLATE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=255)),
                ('path', models.CharField(db_column='PATH', max_length=255)),
                ('type', models.FloatField(db_column='TYPE')),
            ],
            options={
                'db_table': 'DOCGEN_TEMPLATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='DocgenTemplateClass',
            fields=[
                ('docgen_template_class_id', models.AutoField(db_column='DOCGEN_TEMPLATE_CLASS_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=255)),
                ('path', models.CharField(db_column='PATH', max_length=255)),
                ('type', models.FloatField(db_column='TYPE')),
            ],
            options={
                'db_table': 'DOCGEN_TEMPLATE_CLASS',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FormGroup',
            fields=[
                ('form_group_id', models.AutoField(db_column='FORM_GROUP_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=500)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
            ],
            options={
                'db_table': 'FORM_GROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='FormGroupForm',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='form_group', to='instance.Form')),
                ('form_group', models.ForeignKey(db_column='FORM_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='forms', to='core.FormGroup')),
            ],
            options={
                'db_table': 'FORM_GROUP_FORM',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='GlossaryCategory',
            fields=[
                ('glossary_category_id', models.AutoField(db_column='GLOSSARY_CATEGORY_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=80)),
                ('role_id', models.FloatField(blank=True, db_column='ROLE_ID', null=True)),
                ('service_id', models.FloatField(blank=True, db_column='SERVICE_ID', null=True)),
                ('user_id', models.FloatField(blank=True, db_column='USER_ID', null=True)),
            ],
            options={
                'db_table': 'GLOSSARY_CATEGORY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='GlossarySentence',
            fields=[
                ('glossary_sentence_id', models.AutoField(db_column='GLOSSARY_SENTENCE_ID', primary_key=True, serialize=False)),
                ('glossary_category_id', models.FloatField(db_column='GLOSSARY_CATEGORY_ID')),
                ('title', models.CharField(db_column='TITLE', max_length=500)),
                ('sentence', models.CharField(db_column='SENTENCE', max_length=4000)),
                ('role_id', models.FloatField(blank=True, db_column='ROLE_ID', null=True)),
                ('service_id', models.FloatField(blank=True, db_column='SERVICE_ID', null=True)),
                ('user_id', models.FloatField(blank=True, db_column='USER_ID', null=True)),
            ],
            options={
                'db_table': 'GLOSSARY_SENTENCE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceDemo',
            fields=[
                ('instance_demo', models.OneToOneField(db_column='INSTANCE_DEMO_ID', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, related_name='+', serialize=False, to='instance.Instance')),
                ('value', models.CharField(blank=True, db_column='VALUE', max_length=1000, null=True)),
                ('automatic_date', models.DateTimeField(blank=True, db_column='AUTOMATIC_DATE', null=True)),
                ('form_date', models.DateTimeField(blank=True, db_column='FORM_DATE', null=True)),
            ],
            options={
                'db_table': 'INSTANCE_DEMO',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceDemoLog',
            fields=[
                ('instance_demo_log_id', models.AutoField(db_column='INSTANCE_DEMO_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(db_column='DATA')),
                ('id', models.IntegerField(db_column='ID')),
            ],
            options={
                'db_table': 'INSTANCE_DEMO_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceFormPdf',
            fields=[
                ('instance_form_pdf_id', models.AutoField(db_column='INSTANCE_FORM_PDF_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('filename', models.CharField(db_column='FILENAME', max_length=50)),
            ],
            options={
                'db_table': 'INSTANCE_FORM_PDF',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceGuest',
            fields=[
                ('instance', models.OneToOneField(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, related_name='+', serialize=False, to='instance.Instance')),
                ('session_id', models.CharField(db_column='SESSION_ID', max_length=128)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
            ],
            options={
                'db_table': 'INSTANCE_GUEST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceLocation',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('location', models.ForeignKey(db_column='LOCATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Location')),
            ],
            options={
                'db_table': 'INSTANCE_LOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceLocationLog',
            fields=[
                ('instance_location_log_id', models.AutoField(db_column='INSTANCE_LOCATION_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
            ],
            options={
                'db_table': 'INSTANCE_LOCATION_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceLog',
            fields=[
                ('instance_log_id', models.AutoField(db_column='INSTANCE_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('id', models.IntegerField(db_column='ID')),
            ],
            options={
                'db_table': 'INSTANCE_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstancePortal',
            fields=[
                ('instance_id', models.AutoField(db_column='INSTANCE_ID', primary_key=True, serialize=False)),
                ('portal_identifier', models.CharField(db_column='PORTAL_IDENTIFIER', max_length=256)),
            ],
            options={
                'db_table': 'INSTANCE_PORTAL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceResource',
            fields=[
                ('instance_resource_id', models.AutoField(db_column='INSTANCE_RESOURCE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('template', models.CharField(blank=True, db_column='TEMPLATE', max_length=500, null=True)),
                ('class_field', models.CharField(blank=True, db_column='CLASS', max_length=25, null=True)),
                ('hidden', models.PositiveSmallIntegerField(db_column='HIDDEN')),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'INSTANCE_RESOURCE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='InstanceResourceAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('available_action', models.ForeignKey(db_column='AVAILABLE_ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableAction')),
                ('available_instance_resource', models.ForeignKey(db_column='AVAILABLE_INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableInstanceResource')),
            ],
            options={
                'db_table': 'INSTANCE_RESOURCE_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditcirculationSg',
            fields=[
                ('ir_editcirculation_sg_id', models.AutoField(db_column='IR_EDITCIRCULATION_SG_ID', primary_key=True, serialize=False)),
                ('localized', models.PositiveSmallIntegerField(db_column='LOCALIZED')),
                ('service_group', models.ForeignKey(db_column='SERVICE_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.ServiceGroup')),
            ],
            options={
                'db_table': 'IR_EDITCIRCULATION_SG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditletterAnswer',
            fields=[
                ('ir_editletter_answer_id', models.AutoField(db_column='IR_EDITLETTER_ANSWER_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
            ],
            options={
                'db_table': 'IR_EDITLETTER_ANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'IR_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'IR_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'IR_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'IR_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Letter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(db_column='DATE')),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('content', models.TextField(db_column='CONTENT')),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('ir_editletter_answer', models.ForeignKey(blank=True, db_column='IR_EDITLETTER_ANSWER_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.IrEditletterAnswer')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'LETTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='LetterImage',
            fields=[
                ('letter_image_id', models.AutoField(db_column='LETTER_IMAGE_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('filename', models.CharField(db_column='FILENAME', max_length=50)),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
            ],
            options={
                'db_table': 'LETTER_IMAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='LoginAttempt',
            fields=[
                ('login_attempt_id', models.AutoField(db_column='LOGIN_ATTEMPT_ID', primary_key=True, serialize=False)),
                ('ip', models.CharField(db_column='IP', max_length=45)),
                ('attempt_date', models.DateTimeField(db_column='ATTEMPT_DATE')),
                ('username', models.CharField(blank=True, db_column='USERNAME', max_length=250, null=True)),
            ],
            options={
                'db_table': 'LOGIN_ATTEMPT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Mapping',
            fields=[
                ('mapping_id', models.AutoField(db_column='MAPPING_ID', primary_key=True, serialize=False)),
                ('table_name', models.CharField(db_column='TABLE_NAME', max_length=30)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
            ],
            options={
                'db_table': 'MAPPING',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Notice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(blank=True, db_column='CONTENT', null=True)),
                ('activation', models.ForeignKey(db_column='ACTIVATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Activation')),
            ],
            options={
                'db_table': 'NOTICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='NoticeImage',
            fields=[
                ('notice_image_id', models.AutoField(db_column='NOTICE_IMAGE_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('filename', models.CharField(db_column='FILENAME', max_length=50)),
                ('activation', models.ForeignKey(db_column='ACTIVATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Activation')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'NOTICE_IMAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='NoticeLog',
            fields=[
                ('notice_log_id', models.AutoField(db_column='NOTICE_LOG_ID', primary_key=True, serialize=False)),
                ('modification_date', models.DateTimeField(db_column='MODIFICATION_DATE')),
                ('user_id', models.IntegerField(db_column='USER_ID')),
                ('action', models.CharField(db_column='ACTION', max_length=500)),
                ('data', models.TextField(blank=True, db_column='DATA', null=True)),
                ('id1', models.IntegerField(db_column='ID1')),
                ('field1', models.CharField(db_column='FIELD1', max_length=30)),
                ('id2', models.IntegerField(db_column='ID2')),
                ('field2', models.CharField(db_column='FIELD2', max_length=30)),
            ],
            options={
                'db_table': 'NOTICE_LOG',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='NoticeType',
            fields=[
                ('notice_type_id', models.AutoField(db_column='NOTICE_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('circulation_type', models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType')),
            ],
            options={
                'db_table': 'NOTICE_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('page_id', models.AutoField(db_column='PAGE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=500)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('javascript', models.CharField(blank=True, db_column='JAVASCRIPT', max_length=4000, null=True)),
            ],
            options={
                'db_table': 'PAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageAnswerActivation',
            fields=[
                ('page_answer_activation_id', models.AutoField(db_column='PAGE_ANSWER_ACTIVATION_ID', primary_key=True, serialize=False)),
                ('answer', models.CharField(db_column='ANSWER', max_length=4000)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
            ],
            options={
                'db_table': 'PAGE_ANSWER_ACTIVATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageForm',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('sort', models.IntegerField(db_column='SORT')),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page')),
            ],
            options={
                'db_table': 'PAGE_FORM',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormGroup',
            fields=[
                ('page_form_group_id', models.AutoField(db_column='PAGE_FORM_GROUP_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, db_column='NAME', max_length=50, null=True)),
            ],
            options={
                'db_table': 'PAGE_FORM_GROUP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
            ],
            options={
                'db_table': 'PAGE_FORM_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormMode',
            fields=[
                ('page_form_mode_id', models.AutoField(db_column='PAGE_FORM_MODE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
            ],
            options={
                'db_table': 'PAGE_FORM_MODE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('role', models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'PAGE_FORM_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'PAGE_FORM_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PageFormUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'PAGE_FORM_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PortalSession',
            fields=[
                ('portal_session_id', models.CharField(db_column='PORTAL_SESSION_ID', max_length=256, primary_key=True, serialize=False)),
                ('portal_identifier', models.CharField(db_column='PORTAL_IDENTIFIER', max_length=256)),
                ('last_active', models.DateTimeField(db_column='LAST_ACTIVE')),
            ],
            options={
                'db_table': 'PORTAL_SESSION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ProposalActivation',
            fields=[
                ('proposal_activation_id', models.AutoField(db_column='PROPOSAL_ACTIVATION_ID', primary_key=True, serialize=False)),
                ('deadline_date', models.DateTimeField(db_column='DEADLINE_DATE')),
                ('reason', models.CharField(blank=True, db_column='REASON', max_length=50, null=True)),
                ('circulation_state', models.ForeignKey(db_column='CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.CirculationState')),
                ('circulation_type', models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.CirculationType')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'PROPOSAL_ACTIVATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PublicationEntry',
            fields=[
                ('publication_entry_id', models.AutoField(db_column='PUBLICATION_ENTRY_ID', primary_key=True, serialize=False)),
                ('note', models.FloatField(db_column='NOTE')),
                ('publication_date', models.DateTimeField(db_column='PUBLICATION_DATE')),
                ('is_published', models.PositiveSmallIntegerField(db_column='IS_PUBLISHED')),
                ('text', models.TextField(blank=True, db_column='TEXT', null=True)),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
            ],
            options={
                'db_table': 'PUBLICATION_ENTRY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='PublicationSetting',
            fields=[
                ('publication_setting_id', models.AutoField(db_column='PUBLICATION_SETTING_ID', primary_key=True, serialize=False)),
                ('key', models.CharField(db_column='KEY', max_length=64)),
                ('value', models.CharField(blank=True, db_column='VALUE', max_length=4000, null=True)),
            ],
            options={
                'db_table': 'PUBLICATION_SETTING',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('question_id', models.AutoField(db_column='QUESTION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=500)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('javascript', models.CharField(blank=True, db_column='JAVASCRIPT', max_length=4000, null=True)),
                ('regex', models.CharField(blank=True, db_column='REGEX', max_length=1000, null=True)),
                ('default_answer', models.CharField(blank=True, db_column='DEFAULT_ANSWER', max_length=4000, null=True)),
                ('class_field', models.CharField(blank=True, db_column='CLASS', max_length=25, null=True)),
                ('validation', models.CharField(blank=True, db_column='VALIDATION', max_length=50, null=True)),
                ('answer_query', models.ForeignKey(blank=True, db_column='ANSWER_QUERY_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AnswerQuery')),
                ('mapping', models.ForeignKey(blank=True, db_column='MAPPING_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Mapping')),
            ],
            options={
                'db_table': 'QUESTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionChapter',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('required', models.PositiveSmallIntegerField(db_column='REQUIRED')),
                ('item', models.IntegerField(db_column='ITEM')),
                ('sort', models.IntegerField(db_column='SORT')),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
            ],
            options={
                'db_table': 'QUESTION_CHAPTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionChapterGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
            ],
            options={
                'db_table': 'QUESTION_CHAPTER_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionChapterRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
                ('role', models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
            ],
            options={
                'db_table': 'QUESTION_CHAPTER_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionChapterServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'QUESTION_CHAPTER_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionChapterUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'QUESTION_CHAPTER_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='QuestionType',
            fields=[
                ('question_type_id', models.AutoField(db_column='QUESTION_TYPE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=20)),
                ('sort', models.IntegerField(blank=True, db_column='SORT', null=True)),
            ],
            options={
                'db_table': 'QUESTION_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RApiListCirculationState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('circulation_state', models.ForeignKey(db_column='CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationState')),
            ],
            options={
                'db_table': 'R_API_LIST_CIRCULATION_STATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RApiListCirculationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('circulation_type', models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType')),
            ],
            options={
                'db_table': 'R_API_LIST_CIRCULATION_TYPE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RApiListInstanceState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
            ],
            options={
                'db_table': 'R_API_LIST_INSTANCE_STATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('resource_id', models.AutoField(db_column='RESOURCE_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=50)),
                ('description', models.CharField(blank=True, db_column='DESCRIPTION', max_length=1000, null=True)),
                ('template', models.CharField(blank=True, db_column='TEMPLATE', max_length=500, null=True)),
                ('class_field', models.CharField(blank=True, db_column='CLASS', max_length=25, null=True)),
                ('hidden', models.PositiveSmallIntegerField(db_column='HIDDEN')),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'RESOURCE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RGroupAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('group', models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group')),
            ],
            options={
                'db_table': 'R_GROUP_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RListColumn',
            fields=[
                ('r_list_column_id', models.AutoField(db_column='R_LIST_COLUMN_ID', primary_key=True, serialize=False)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
                ('alias', models.CharField(db_column='ALIAS', max_length=30)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'R_LIST_COLUMN',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RRoleAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'R_ROLE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSearchColumn',
            fields=[
                ('r_search_column_id', models.AutoField(db_column='R_SEARCH_COLUMN_ID', primary_key=True, serialize=False)),
                ('column_name', models.CharField(db_column='COLUMN_NAME', max_length=30)),
                ('alias', models.CharField(db_column='ALIAS', max_length=30)),
                ('sort', models.IntegerField(db_column='SORT')),
            ],
            options={
                'db_table': 'R_SEARCH_COLUMN',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSearchFilter',
            fields=[
                ('r_search_filter_id', models.AutoField(db_column='R_SEARCH_FILTER_ID', primary_key=True, serialize=False)),
                ('field_name', models.CharField(db_column='FIELD_NAME', max_length=50)),
                ('label', models.CharField(db_column='LABEL', max_length=1000)),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
                ('wildcard', models.PositiveSmallIntegerField(db_column='WILDCARD')),
                ('class_field', models.CharField(blank=True, db_column='CLASS', max_length=25, null=True)),
                ('question', models.ForeignKey(blank=True, db_column='QUESTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question')),
            ],
            options={
                'db_table': 'R_SEARCH_FILTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RServiceAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'R_SERVICE_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSimpleList',
            fields=[
                ('resource_id', models.AutoField(db_column='RESOURCE_ID', primary_key=True, serialize=False)),
                ('instance_states', models.CharField(db_column='INSTANCE_STATES', max_length=100)),
            ],
            options={
                'db_table': 'R_SIMPLE_LIST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RUserAcl',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'R_USER_ACL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Sanction',
            fields=[
                ('sanction_id', models.AutoField(db_column='SANCTION_ID', primary_key=True, serialize=False)),
                ('text', models.CharField(db_column='TEXT', max_length=4000)),
                ('start_date', models.DateTimeField(db_column='START_DATE')),
                ('deadline_date', models.DateTimeField(blank=True, db_column='DEADLINE_DATE', null=True)),
                ('end_date', models.DateTimeField(blank=True, db_column='END_DATE', null=True)),
                ('notice', models.CharField(blank=True, db_column='NOTICE', max_length=500, null=True)),
                ('is_finished', models.PositiveSmallIntegerField(db_column='IS_FINISHED')),
                ('finished_by_user', models.ForeignKey(blank=True, db_column='FINISHED_BY_USER_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
                ('user', models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'SANCTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ServiceAnswerActivation',
            fields=[
                ('service_answer_activation_id', models.AutoField(db_column='SERVICE_ANSWER_ACTIVATION_ID', primary_key=True, serialize=False)),
                ('answer', models.CharField(db_column='ANSWER', max_length=4000)),
                ('chapter', models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Chapter')),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Form')),
                ('question', models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Question')),
                ('service', models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service')),
            ],
            options={
                'db_table': 'SERVICE_ANSWER_ACTIVATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='TemplateGenerateAction',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('as_pdf', models.PositiveSmallIntegerField(db_column='AS_PDF', default=0)),
            ],
            options={
                'db_table': 'TEMPLATE_GENERATE_ACTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='WorkflowEntry',
            fields=[
                ('workflow_entry_id', models.AutoField(db_column='WORKFLOW_ENTRY_ID', primary_key=True, serialize=False)),
                ('workflow_date', models.DateTimeField(db_column='WORKFLOW_DATE')),
                ('group', models.IntegerField(db_column='GROUP')),
                ('instance', models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, to='instance.Instance')),
            ],
            options={
                'db_table': 'WORKFLOW_ENTRY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='WorkflowItem',
            fields=[
                ('workflow_item_id', models.AutoField(db_column='WORKFLOW_ITEM_ID', primary_key=True, serialize=False)),
                ('position', models.IntegerField(db_column='POSITION')),
                ('name', models.CharField(db_column='NAME', max_length=255)),
                ('automatical', models.PositiveSmallIntegerField(db_column='AUTOMATICAL')),
                ('different_color', models.PositiveSmallIntegerField(db_column='DIFFERENT_COLOR')),
                ('is_workflow', models.PositiveSmallIntegerField(db_column='IS_WORKFLOW')),
                ('is_building_authority', models.PositiveSmallIntegerField(db_column='IS_BUILDING_AUTHORITY')),
            ],
            options={
                'db_table': 'WORKFLOW_ITEM',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='WorkflowRole',
            fields=[
                ('id', models.AutoField(db_column='ID', primary_key=True, serialize=False)),
                ('role', models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role')),
                ('workflow_item', models.ForeignKey(db_column='WORKFLOW_ITEM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.WorkflowItem')),
            ],
            options={
                'db_table': 'WORKFLOW_ROLE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='WorkflowSection',
            fields=[
                ('workflow_section_id', models.AutoField(db_column='WORKFLOW_SECTION_ID', primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='NAME', max_length=60)),
                ('sort', models.IntegerField(blank=True, db_column='SORT', null=True)),
            ],
            options={
                'db_table': 'WORKFLOW_SECTION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACheckquery',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
            ],
            options={
                'db_table': 'A_CHECKQUERY',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACirculationEmail',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('sender_name', models.CharField(db_column='SENDER_NAME', max_length=50)),
                ('sender_email', models.CharField(db_column='SENDER_EMAIL', max_length=50)),
                ('title', models.CharField(db_column='TITLE', max_length=200)),
                ('text', models.CharField(db_column='TEXT', max_length=2000)),
            ],
            options={
                'db_table': 'A_CIRCULATION_EMAIL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACirculationtransition',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('current_circulation_state', models.ForeignKey(blank=True, db_column='CURRENT_CIRCULATION_STATE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationState')),
                ('next_circulation_state', models.ForeignKey(db_column='NEXT_CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationState')),
            ],
            options={
                'db_table': 'A_CIRCULATIONTRANSITION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACopyanswer',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
            ],
            options={
                'db_table': 'A_COPYANSWER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ACopydata',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
            ],
            options={
                'db_table': 'A_COPYDATA',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ADeleteCirculation',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('delete_level', models.IntegerField(db_column='DELETE_LEVEL')),
            ],
            options={
                'db_table': 'A_DELETE_CIRCULATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AEmail',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('sender_name', models.CharField(db_column='SENDER_NAME', max_length=50)),
                ('sender_email', models.CharField(db_column='SENDER_EMAIL', max_length=50)),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
                ('title', models.CharField(db_column='TITLE', max_length=200)),
                ('text', models.CharField(db_column='TEXT', max_length=2000)),
            ],
            options={
                'db_table': 'A_EMAIL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AFormtransition',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('current_instance_state', models.ForeignKey(blank=True, db_column='CURRENT_INSTANCE_STATE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('next_instance_state', models.ForeignKey(blank=True, db_column='NEXT_INSTANCE_STATE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
            ],
            options={
                'db_table': 'A_FORMTRANSITION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ALocation',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
            ],
            options={
                'db_table': 'A_LOCATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ANotice',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
                ('notice_type', models.ForeignKey(db_column='NOTICE_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.NoticeType')),
            ],
            options={
                'db_table': 'A_NOTICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ANotification',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('recipient_type', models.CharField(db_column='RECIPIENT_TYPE', max_length=160)),
                ('processor', models.CharField(db_column='PROCESSOR', max_length=160)),
                ('template', models.ForeignKey(db_column='TEMPLATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='notification.NotificationTemplate')),
            ],
            options={
                'db_table': 'ACTION_NOTIFICATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='APageredirect',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('air_action_name', models.CharField(blank=True, db_column='AIR_ACTION_NAME', max_length=25, null=True)),
            ],
            options={
                'db_table': 'A_PAGEREDIRECT',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='APhp',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('php_class', models.CharField(db_column='PHP_CLASS', max_length=500)),
            ],
            options={
                'db_table': 'A_PHP',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AProposal',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('deadline_days', models.IntegerField(db_column='DEADLINE_DAYS')),
                ('reason', models.CharField(blank=True, db_column='REASON', max_length=50, null=True)),
                ('is_working_days', models.PositiveSmallIntegerField(db_column='IS_WORKING_DAYS')),
                ('circulation_state', models.ForeignKey(db_column='CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationState')),
            ],
            options={
                'db_table': 'A_PROPOSAL',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ASavepdf',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('show_all_page_form_mode', models.PositiveSmallIntegerField(db_column='SHOW_ALL_PAGE_FORM_MODE')),
                ('template', models.CharField(db_column='TEMPLATE', max_length=500)),
                ('pdf_class', models.CharField(db_column='PDF_CLASS', max_length=500)),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'A_SAVEPDF',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='AValidate',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'A_VALIDATE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrAllformpages',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('show_all_page_form_mode', models.PositiveSmallIntegerField(db_column='SHOW_ALL_PAGE_FORM_MODE')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_ALLFORMPAGES',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrCirculation',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('show_notice', models.PositiveSmallIntegerField(db_column='SHOW_NOTICE')),
                ('show_history', models.PositiveSmallIntegerField(db_column='SHOW_HISTORY')),
                ('show_all_children', models.PositiveSmallIntegerField(db_column='SHOW_ALL_CHILDREN')),
                ('read_notice_template', models.CharField(blank=True, db_column='READ_NOTICE_TEMPLATE', max_length=500, null=True)),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('service_to_be_interpreted', models.CharField(blank=True, db_column='SERVICE_TO_BE_INTERPRETED', max_length=50, null=True)),
            ],
            options={
                'db_table': 'IR_CIRCULATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditcirculation',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('show_notice', models.PositiveSmallIntegerField(db_column='SHOW_NOTICE')),
                ('add_template', models.CharField(blank=True, db_column='ADD_TEMPLATE', max_length=500, null=True)),
                ('add_activation_template', models.CharField(blank=True, db_column='ADD_ACTIVATION_TEMPLATE', max_length=500, null=True)),
                ('read_notice_template', models.CharField(blank=True, db_column='READ_NOTICE_TEMPLATE', max_length=500, null=True)),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('default_circulation_name', models.CharField(blank=True, db_column='DEFAULT_CIRCULATION_NAME', max_length=500, null=True)),
                ('single_circulation', models.PositiveSmallIntegerField(db_column='SINGLE_CIRCULATION')),
                ('inherit_notices', models.PositiveSmallIntegerField(db_column='INHERIT_NOTICES')),
                ('display_first_circulation', models.PositiveSmallIntegerField(db_column='DISPLAY_FIRST_CIRCULATION')),
            ],
            options={
                'db_table': 'IR_EDITCIRCULATION',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditformpage',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page')),
            ],
            options={
                'db_table': 'IR_EDITFORMPAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditformpages',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_EDITFORMPAGES',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditletter',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
            ],
            options={
                'db_table': 'IR_EDITLETTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrEditnotice',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('editable_after_deadline', models.PositiveSmallIntegerField(db_column='EDITABLE_AFTER_DEADLINE')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('edit_notice_template', models.CharField(blank=True, db_column='EDIT_NOTICE_TEMPLATE', max_length=500, null=True)),
                ('hide_answered_notices', models.PositiveSmallIntegerField(db_column='HIDE_ANSWERED_NOTICES')),
                ('is_always_editable', models.PositiveSmallIntegerField(db_column='IS_ALWAYS_EDITABLE')),
            ],
            options={
                'db_table': 'IR_EDITNOTICE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFormerror',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('ir_editformpages', models.ForeignKey(db_column='IR_EDITFORMPAGES_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrEditformpages')),
            ],
            options={
                'db_table': 'IR_FORMERROR',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFormpage',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('page', models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page')),
            ],
            options={
                'db_table': 'IR_FORMPAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFormpages',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_FORMPAGES',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrFormwizard',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('show_captcha', models.PositiveSmallIntegerField(db_column='SHOW_CAPTCHA')),
                ('summary', models.CharField(blank=True, db_column='SUMMARY', max_length=4000, null=True)),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page_form_group', models.ForeignKey(db_column='PAGE_FORM_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_FORMWIZARD',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrLetter',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('ir_editletter_id', models.IntegerField(blank=True, db_column='IR_EDITLETTER_ID', null=True)),
            ],
            options={
                'db_table': 'IR_LETTER',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrNewform',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('instance_state', models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState')),
                ('page_form_group', models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup')),
            ],
            options={
                'db_table': 'IR_NEWFORM',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='IrPage',
            fields=[
                ('instance_resource', models.OneToOneField(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.InstanceResource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
            ],
            options={
                'db_table': 'IR_PAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RFormlist',
            fields=[
                ('resource', models.OneToOneField(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Resource')),
                ('form', models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Form')),
            ],
            options={
                'db_table': 'R_FORMLIST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RList',
            fields=[
                ('resource', models.OneToOneField(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Resource')),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
            ],
            options={
                'db_table': 'R_LIST',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RPage',
            fields=[
                ('resource', models.OneToOneField(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Resource')),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
            ],
            options={
                'db_table': 'R_PAGE',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='RSearch',
            fields=[
                ('resource', models.OneToOneField(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Resource')),
                ('result_template', models.CharField(blank=True, db_column='RESULT_TEMPLATE', max_length=500, null=True)),
                ('query', models.CharField(db_column='QUERY', max_length=4000)),
                ('pdf_class', models.CharField(blank=True, db_column='PDF_CLASS', max_length=500, null=True)),
                ('preserve_result', models.PositiveSmallIntegerField(db_column='PRESERVE_RESULT')),
            ],
            options={
                'db_table': 'R_SEARCH',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='WorkflowAction',
            fields=[
                ('action', models.OneToOneField(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='+', serialize=False, to='core.Action')),
                ('multi_value', models.PositiveSmallIntegerField(db_column='MULTI_VALUE')),
            ],
            options={
                'db_table': 'WORKFLOW_ACTION',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='workflowitem',
            name='workflow_section',
            field=models.ForeignKey(blank=True, db_column='WORKFLOW_SECTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.WorkflowSection'),
        ),
        migrations.AddField(
            model_name='workflowentry',
            name='workflow_item',
            field=models.ForeignKey(db_column='WORKFLOW_ITEM_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.WorkflowItem'),
        ),
        migrations.AddField(
            model_name='templategenerateaction',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='templategenerateaction',
            name='template',
            field=models.ForeignKey(db_column='TEMPLATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='document.Template'),
        ),
        migrations.AddField(
            model_name='ruseracl',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='ruseracl',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='rserviceacl',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='rserviceacl',
            name='service',
            field=models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='rroleacl',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='rroleacl',
            name='role',
            field=models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role'),
        ),
        migrations.AddField(
            model_name='rgroupacl',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='resource',
            name='available_resource',
            field=models.ForeignKey(db_column='AVAILABLE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableResource'),
        ),
        migrations.AddField(
            model_name='rapilistinstancestate',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='rapilistcirculationtype',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='rapilistcirculationstate',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='question',
            name='question_type',
            field=models.ForeignKey(db_column='QUESTION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.QuestionType'),
        ),
        migrations.AddField(
            model_name='pageform',
            name='page_form_group',
            field=models.ForeignKey(blank=True, db_column='PAGE_FORM_GROUP_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormGroup'),
        ),
        migrations.AddField(
            model_name='pageform',
            name='page_form_mode',
            field=models.ForeignKey(db_column='PAGE_FORM_MODE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageFormMode'),
        ),
        migrations.AddField(
            model_name='pageansweractivation',
            name='form',
            field=models.ForeignKey(db_column='FORM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm'),
        ),
        migrations.AddField(
            model_name='pageansweractivation',
            name='page',
            field=models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.PageForm'),
        ),
        migrations.AddField(
            model_name='pageansweractivation',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='notice',
            name='notice_type',
            field=models.ForeignKey(db_column='NOTICE_TYPE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.NoticeType'),
        ),
        migrations.AddField(
            model_name='letterimage',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='letterimage',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='iruseracl',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='iruseracl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='iruseracl',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='irserviceacl',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='irserviceacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='irserviceacl',
            name='service',
            field=models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='irroleacl',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='irroleacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='irroleacl',
            name='role',
            field=models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role'),
        ),
        migrations.AddField(
            model_name='irgroupacl',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='irgroupacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='instanceresource',
            name='available_instance_resource',
            field=models.ForeignKey(db_column='AVAILABLE_INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableInstanceResource'),
        ),
        migrations.AddField(
            model_name='instanceresource',
            name='form_group',
            field=models.ForeignKey(db_column='FORM_GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.FormGroup'),
        ),
        migrations.AddField(
            model_name='instanceresource',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AddField(
            model_name='instanceformpdf',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='instanceformpdf',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='instanceformpdf',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='docgenpdfaction',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='docgenpdfaction',
            name='docgen_template',
            field=models.ForeignKey(db_column='DOCGEN_TEMPLATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplate'),
        ),
        migrations.AddField(
            model_name='docgenpdfaction',
            name='docgen_template_class',
            field=models.ForeignKey(db_column='DOCGEN_TEMPLATE_CLASS_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplateClass'),
        ),
        migrations.AddField(
            model_name='docgendocxaction',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='docgendocxaction',
            name='docgen_template',
            field=models.ForeignKey(db_column='DOCGEN_TEMPLATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplate'),
        ),
        migrations.AddField(
            model_name='docgendocxaction',
            name='docgen_template_class',
            field=models.ForeignKey(db_column='DOCGEN_TEMPLATE_CLASS_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplateClass'),
        ),
        migrations.AddField(
            model_name='docgenactivationdocket',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='docgenactivationactionaction',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='docgenactivationactionaction',
            name='docgen_activation_action',
            field=models.ForeignKey(db_column='DOCGEN_ACTIVATION_ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenActivationAction'),
        ),
        migrations.AddField(
            model_name='commissionassignment',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='circulationtype',
            name='page',
            field=models.ForeignKey(blank=True, db_column='PAGE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page'),
        ),
        migrations.AddField(
            model_name='circulationreason',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='circulationanswer',
            name='circulation_answer_type',
            field=models.ForeignKey(db_column='CIRCULATION_ANSWER_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationAnswerType'),
        ),
        migrations.AddField(
            model_name='circulationanswer',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='circulation',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='circulations', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='chapterpage',
            name='page',
            field=models.ForeignKey(db_column='PAGE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Page'),
        ),
        migrations.AddField(
            model_name='button',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='buseracl',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='buseracl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='buseracl',
            name='user',
            field=models.ForeignKey(db_column='USER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='buildingauthoritysectiondis',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='buildingauthorityitemdis',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='buildingauthorityitemdis',
            name='workflow_item',
            field=models.ForeignKey(db_column='WORKFLOW_ITEM_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.WorkflowItem'),
        ),
        migrations.AddField(
            model_name='buildingauthoritydoc',
            name='template',
            field=models.ForeignKey(db_column='TEMPLATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplate'),
        ),
        migrations.AddField(
            model_name='buildingauthoritydoc',
            name='template_class',
            field=models.ForeignKey(db_column='TEMPLATE_CLASS_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.DocgenTemplateClass'),
        ),
        migrations.AddField(
            model_name='buildingauthoritycomment',
            name='building_authority_section',
            field=models.ForeignKey(db_column='BUILDING_AUTHORITY_SECTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.BuildingAuthoritySection'),
        ),
        migrations.AddField(
            model_name='buildingauthoritycomment',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='buildingauthoritybuttonstate',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='bserviceacl',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='bserviceacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='bserviceacl',
            name='service',
            field=models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='broleacl',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='broleacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='broleacl',
            name='role',
            field=models.ForeignKey(db_column='ROLE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Role'),
        ),
        migrations.AddField(
            model_name='billingentry',
            name='instance',
            field=models.ForeignKey(blank=True, db_column='INSTANCE_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='billingentry',
            name='service',
            field=models.ForeignKey(blank=True, db_column='SERVICE_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='bgroupacl',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='bgroupacl',
            name='group',
            field=models.ForeignKey(db_column='GROUP_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Group'),
        ),
        migrations.AddField(
            model_name='bgroupacl',
            name='instance_state',
            field=models.ForeignKey(db_column='INSTANCE_STATE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='instance.InstanceState'),
        ),
        migrations.AddField(
            model_name='babusage',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AlterUniqueTogether(
            name='authorityauthoritytype',
            unique_together=set([('authority_id', 'authority_type_id')]),
        ),
        migrations.AddField(
            model_name='araction',
            name='available_resource',
            field=models.ForeignKey(db_column='AVAILABLE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableResource'),
        ),
        migrations.AddField(
            model_name='answerlist',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='answer',
            name='chapter',
            field=models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='answer',
            name='instance',
            field=models.ForeignKey(db_column='INSTANCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='instance.Instance'),
        ),
        migrations.AddField(
            model_name='answer',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='alocationqc',
            name='chapter',
            field=models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='alocationqc',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='airaction',
            name='available_instance_resource',
            field=models.ForeignKey(db_column='AVAILABLE_INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableInstanceResource'),
        ),
        migrations.AddField(
            model_name='activationanswer',
            name='chapter',
            field=models.ForeignKey(db_column='CHAPTER_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='activationanswer',
            name='question',
            field=models.ForeignKey(db_column='QUESTION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='activation',
            name='circulation',
            field=models.ForeignKey(db_column='CIRCULATION_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='activations', to='core.Circulation'),
        ),
        migrations.AddField(
            model_name='activation',
            name='circulation_answer',
            field=models.ForeignKey(blank=True, db_column='CIRCULATION_ANSWER_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.CirculationAnswer'),
        ),
        migrations.AddField(
            model_name='activation',
            name='circulation_state',
            field=models.ForeignKey(db_column='CIRCULATION_STATE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.CirculationState'),
        ),
        migrations.AddField(
            model_name='activation',
            name='service',
            field=models.ForeignKey(db_column='SERVICE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='activation',
            name='service_parent',
            field=models.ForeignKey(db_column='SERVICE_PARENT_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='user.Service'),
        ),
        migrations.AddField(
            model_name='activation',
            name='user',
            field=models.ForeignKey(blank=True, db_column='USER_ID', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='action',
            name='available_action',
            field=models.ForeignKey(db_column='AVAILABLE_ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.AvailableAction'),
        ),
        migrations.AddField(
            model_name='action',
            name='button',
            field=models.ForeignKey(db_column='BUTTON_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Button'),
        ),
        migrations.AddField(
            model_name='acopydatamapping',
            name='chapter',
            field=models.ForeignKey(blank=True, db_column='CHAPTER_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='acopydatamapping',
            name='question',
            field=models.ForeignKey(blank=True, db_column='QUESTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='acopyanswermapping',
            name='destination_chapter',
            field=models.ForeignKey(db_column='DESTINATION_CHAPTER_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='acopyanswermapping',
            name='destination_question',
            field=models.ForeignKey(db_column='DESTINATION_QUESTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AddField(
            model_name='acopyanswermapping',
            name='source_chapter',
            field=models.ForeignKey(blank=True, db_column='SOURCE_CHAPTER_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Chapter'),
        ),
        migrations.AddField(
            model_name='acopyanswermapping',
            name='source_question',
            field=models.ForeignKey(blank=True, db_column='SOURCE_QUESTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Question'),
        ),
        migrations.AlterUniqueTogether(
            name='workflowrole',
            unique_together=set([('role', 'workflow_item')]),
        ),
        migrations.AlterUniqueTogether(
            name='workflowentry',
            unique_together=set([('instance', 'workflow_item', 'group')]),
        ),
        migrations.AddField(
            model_name='workflowaction',
            name='workflow_item',
            field=models.ForeignKey(db_column='WORKFLOW_ITEM_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.WorkflowItem'),
        ),
        migrations.AlterUniqueTogether(
            name='templategenerateaction',
            unique_together=set([('as_pdf', 'template', 'action')]),
        ),
        migrations.AlterUniqueTogether(
            name='ruseracl',
            unique_together=set([('resource', 'user')]),
        ),
        migrations.AlterUniqueTogether(
            name='rserviceacl',
            unique_together=set([('resource', 'service')]),
        ),
        migrations.AddField(
            model_name='rsearchfilter',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RSearch'),
        ),
        migrations.AddField(
            model_name='rsearchcolumn',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RSearch'),
        ),
        migrations.AlterUniqueTogether(
            name='rroleacl',
            unique_together=set([('resource', 'role')]),
        ),
        migrations.AddField(
            model_name='rlistcolumn',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.RList'),
        ),
        migrations.AlterUniqueTogether(
            name='rgroupacl',
            unique_together=set([('resource', 'group')]),
        ),
        migrations.AlterUniqueTogether(
            name='rapilistinstancestate',
            unique_together=set([('resource', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='rapilistcirculationtype',
            unique_together=set([('resource', 'circulation_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='rapilistcirculationstate',
            unique_together=set([('resource', 'circulation_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='questionchapteruseracl',
            unique_together=set([('question', 'chapter', 'user', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='questionchapterserviceacl',
            unique_together=set([('question', 'chapter', 'service', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='questionchapterroleacl',
            unique_together=set([('question', 'chapter', 'role', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='questionchaptergroupacl',
            unique_together=set([('question', 'chapter', 'group', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='questionchapter',
            unique_together=set([('question', 'chapter')]),
        ),
        migrations.AlterUniqueTogether(
            name='pageformuseracl',
            unique_together=set([('page', 'form', 'user', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='pageformserviceacl',
            unique_together=set([('page', 'form', 'service', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='pageformroleacl',
            unique_together=set([('page', 'form', 'role', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='pageformgroupacl',
            unique_together=set([('page', 'form', 'group', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='pageform',
            unique_together=set([('page', 'form')]),
        ),
        migrations.AddField(
            model_name='noticeimage',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.IrEditnotice'),
        ),
        migrations.AlterUniqueTogether(
            name='notice',
            unique_together=set([('notice_type', 'activation')]),
        ),
        migrations.AddField(
            model_name='letter',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='core.IrEditletter'),
        ),
        migrations.AlterUniqueTogether(
            name='iruseracl',
            unique_together=set([('instance_resource', 'user', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='irserviceacl',
            unique_together=set([('instance_resource', 'service', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='irroleacl',
            unique_together=set([('instance_resource', 'role', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='irgroupacl',
            unique_together=set([('instance_resource', 'group', 'instance_state')]),
        ),
        migrations.AddField(
            model_name='ireditnotice',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='ireditletteranswer',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrEditletter'),
        ),
        migrations.AddField(
            model_name='ireditcirculationsg',
            name='instance_resource',
            field=models.ForeignKey(db_column='INSTANCE_RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.IrEditcirculation'),
        ),
        migrations.AddField(
            model_name='ireditcirculation',
            name='circulation_email_action_id',
            field=models.ForeignKey(blank=True, db_column='CIRCULATION_EMAIL_ACTION_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Action'),
        ),
        migrations.AddField(
            model_name='ireditcirculation',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='ireditcirculation',
            name='draft_circulation_answer',
            field=models.ForeignKey(blank=True, db_column='DRAFT_CIRCULATION_ANSWER_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationAnswer'),
        ),
        migrations.AddField(
            model_name='ircirculation',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='ircirculation',
            name='draft_circulation_answer',
            field=models.ForeignKey(blank=True, db_column='DRAFT_CIRCULATION_ANSWER_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationAnswer'),
        ),
        migrations.AddField(
            model_name='ircirculation',
            name='service',
            field=models.ForeignKey(blank=True, db_column='SERVICE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='user.Service'),
        ),
        migrations.AlterUniqueTogether(
            name='instanceresourceaction',
            unique_together=set([('available_instance_resource', 'available_action')]),
        ),
        migrations.AlterUniqueTogether(
            name='instancelocation',
            unique_together=set([('location', 'instance')]),
        ),
        migrations.AlterUniqueTogether(
            name='formgroupform',
            unique_together=set([('form_group', 'form')]),
        ),
        migrations.AlterUniqueTogether(
            name='docgenpdfaction',
            unique_together=set([('docgen_template', 'docgen_template_class', 'action')]),
        ),
        migrations.AlterUniqueTogether(
            name='docgendocxaction',
            unique_together=set([('docgen_template', 'docgen_template_class', 'action')]),
        ),
        migrations.AlterUniqueTogether(
            name='docgenactivationactionaction',
            unique_together=set([('docgen_activation_action', 'action')]),
        ),
        migrations.AlterUniqueTogether(
            name='commissionassignment',
            unique_together=set([('group', 'instance')]),
        ),
        migrations.AlterUniqueTogether(
            name='chapterpageuseracl',
            unique_together=set([('chapter', 'page', 'user', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='chapterpageserviceacl',
            unique_together=set([('chapter', 'page', 'service', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='chapterpageroleacl',
            unique_together=set([('chapter', 'page', 'role', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='chapterpagegroupacl',
            unique_together=set([('chapter', 'page', 'group', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='chapterpage',
            unique_together=set([('chapter', 'page')]),
        ),
        migrations.AlterUniqueTogether(
            name='buseracl',
            unique_together=set([('button', 'user', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='buildingauthoritycomment',
            unique_together=set([('building_authority_section', 'group', 'instance')]),
        ),
        migrations.AlterUniqueTogether(
            name='bserviceacl',
            unique_together=set([('button', 'service', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='broleacl',
            unique_together=set([('button', 'role', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='bgroupacl',
            unique_together=set([('button', 'group', 'instance_state')]),
        ),
        migrations.AlterUniqueTogether(
            name='babusage',
            unique_together=set([('instance', 'usage_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='authoritylocation',
            unique_together=set([('authority', 'location')]),
        ),
        migrations.AlterUniqueTogether(
            name='attachmentextensionservice',
            unique_together=set([('attachment_extension', 'service')]),
        ),
        migrations.AlterUniqueTogether(
            name='attachmentextensionrole',
            unique_together=set([('attachment_extension', 'role')]),
        ),
        migrations.AlterUniqueTogether(
            name='araction',
            unique_together=set([('available_resource', 'action_name')]),
        ),
        migrations.AddField(
            model_name='aproposal',
            name='circulation_type',
            field=models.ForeignKey(db_column='CIRCULATION_TYPE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.CirculationType'),
        ),
        migrations.AddField(
            model_name='apageredirect',
            name='instance_resource',
            field=models.ForeignKey(blank=True, db_column='INSTANCE_RESOURCE_ID', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.InstanceResource'),
        ),
        migrations.AddField(
            model_name='apageredirect',
            name='resource',
            field=models.ForeignKey(db_column='RESOURCE_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.Resource'),
        ),
        migrations.AlterUniqueTogether(
            name='answer',
            unique_together=set([('instance', 'question', 'chapter', 'item')]),
        ),
        migrations.AddField(
            model_name='alocationqc',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ALocation'),
        ),
        migrations.AlterUniqueTogether(
            name='airaction',
            unique_together=set([('available_instance_resource', 'action_name')]),
        ),
        migrations.AlterUniqueTogether(
            name='activationanswer',
            unique_together=set([('activation', 'question', 'chapter', 'item')]),
        ),
        migrations.AddField(
            model_name='acopydatamapping',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ACopydata'),
        ),
        migrations.AddField(
            model_name='acopyanswermapping',
            name='action',
            field=models.ForeignKey(db_column='ACTION_ID', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.ACopyanswer'),
        ),
        migrations.AlterUniqueTogether(
            name='letter',
            unique_together=set([('instance', 'instance_resource')]),
        ),
    ]
