# Generated by Django 4.2.14 on 2024-07-25 07:16

from django.db import migrations
from django.db.models import Exists, OuterRef


def do_cleanup_communications_marker(model):
    duplicate_markers = model.objects.all().filter(
        Exists(
            model.objects.filter(
                message_id=OuterRef("message_id"),
                entity=OuterRef("entity"),
                read_at__gt=OuterRef("read_at"),
            ).exclude(
                pk=OuterRef("pk")
            )
        )
    )
    duplicate_markers.delete()

def cleanup_communications_markers(apps, schema_editor):
    model = apps.get_model("communications.CommunicationsReadMarker")
    do_cleanup_communications_marker(model)

    # Test: Three markers


class Migration(migrations.Migration):
    dependencies = [
        ("communications", "0002_alexandria"),
    ]

    operations = [
        migrations.RunPython(cleanup_communications_markers),
        migrations.AlterUniqueTogether(
            name="communicationsreadmarker",
            unique_together={("message", "entity")},
        ),
    ]
