# Generated by Django 3.2.15 on 2023-03-13 16:21

import camac.communications.models
from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('document', '0029_alter_attachment_context'),
        ('instance', '0036_alter_instance_case'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CommunicationsMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('body', models.TextField()),
                ('created_by', models.CharField(max_length=50)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('sent_at', models.DateTimeField(blank=True, default=None, null=True)),
                ('created_by_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CommunicationsTopic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('allow_replies', models.BooleanField(default=True)),
                ('involved_entities', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=50), blank=True, size=None)),
                ('initiated_by_entity', models.CharField(max_length=50)),
                ('initiated_by', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('instance', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='instance.instance')),
            ],
        ),
        migrations.CreateModel(
            name='CommunicationsReadMarker',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('read_at', models.DateTimeField(auto_now_add=True)),
                ('entity', models.CharField(max_length=50)),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='read_by', to='communications.communicationsmessage')),
            ],
        ),
        migrations.AddField(
            model_name='communicationsmessage',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='communications.communicationstopic'),
        ),
        migrations.CreateModel(
            name='CommunicationsAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_attachment', models.FileField(blank=True, default=None, null=True, upload_to=camac.communications.models.attachment_path_directory_path)),
                ('file_type', models.CharField(blank=True, default=None, max_length=250, null=True)),
                ('document_attachment', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='document.attachment')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='communications.communicationsmessage')),
            ],
        ),
    ]
