# -*- coding: utf-8 -*-
# Generated by Django 1.11.22 on 2019-09-23 08:06
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def assign_email(apps, schema_editor):
    Applicant = apps.get_model("applicants", "Applicant")

    for applicant in Applicant.objects.all():
        applicant.email = applicant.invitee.email
        applicant.save()


class Migration(migrations.Migration):

    dependencies = [("applicants", "0004_create_default_applicants")]

    operations = [
        migrations.AddField(
            model_name="applicant",
            name="email",
            field=models.EmailField(blank=True, max_length=254, null=True),
        ),
        migrations.AlterField(
            model_name="applicant",
            name="invitee",
            field=models.ForeignKey(
                blank=True,
                db_column="APPLICANT_USER_ID",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.RunPython(assign_email),
        migrations.AlterField(
            model_name="applicant",
            name="email",
            field=models.EmailField(max_length=254),
        ),
    ]
