/*
 * Decompiled with CFR 0.152.
 */
package dasniko.keycloak.requiredaction;

import dasniko.keycloak.authenticator.SmsAuthenticator;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;

public class MobileNumberRequiredAction
implements RequiredActionProvider {
    private static final Logger log = Logger.getLogger(MobileNumberRequiredAction.class.getName());
    public static final String PROVIDER_ID = "mobile-number-ra";
    private static final String MOBILE_NUMBER_FIELD = "mobile_number";

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
        String verifiedMobileNr = context.getUser().getFirstAttribute("verifiedMobileNr");
        if (context.getUser().getFirstAttribute(MOBILE_NUMBER_FIELD) == null || verifiedMobileNr == null || !verifiedMobileNr.equals("true")) {
            context.getUser().addRequiredAction(PROVIDER_ID);
            context.getAuthenticationSession().addRequiredAction(PROVIDER_ID);
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        context.challenge(this.createForm(context, null));
    }

    public void processAction(RequiredActionContext context) {
        UserModel user = context.getUser();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String mobileNumber = (String)formData.getFirst((Object)MOBILE_NUMBER_FIELD);
        String code = (String)formData.getFirst((Object)"code");
        if (Validation.isBlank((String)mobileNumber) || mobileNumber.length() < 5) {
            context.challenge(this.createForm(context, form -> form.addError(new FormMessage(MOBILE_NUMBER_FIELD, "setupInvalidMobileNr"))));
            return;
        }
        if (user.getFirstAttribute("code") == null || Validation.isBlank((String)code)) {
            RealmModel realm = context.getRealm();
            Map config = realm.getAuthenticatorConfigByAlias("SMS auth").getConfig();
            try {
                String generatedCode = SmsAuthenticator.codeChallenge(config, context.getSession(), context.getSession().getContext().resolveLocale(user), mobileNumber);
                user.setSingleAttribute(MOBILE_NUMBER_FIELD, mobileNumber);
                user.setSingleAttribute("code", generatedCode);
                context.challenge(this.createForm(context, form -> {
                    form.addSuccess(new FormMessage("code", "smsAuthCodeSent"));
                    form.setAttribute("codeSent", (Object)true);
                    form.setAttribute(MOBILE_NUMBER_FIELD, (Object)(mobileNumber == null ? "" : mobileNumber));
                }));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error sending code", e);
                context.challenge(this.createForm(context, form -> {
                    form.addError(new FormMessage("code", "setupAuthCodeNotSent"));
                    form.setAttribute(MOBILE_NUMBER_FIELD, (Object)(mobileNumber == null ? "" : mobileNumber));
                }));
            }
            return;
        }
        if (!code.equals(user.getFirstAttribute("code"))) {
            context.challenge(this.createForm(context, form -> {
                form.addError(new FormMessage("code", "smsAuthCodeInvalid"));
                form.setAttribute("codeSent", (Object)true);
                form.setAttribute(MOBILE_NUMBER_FIELD, (Object)(mobileNumber == null ? "" : mobileNumber));
            }));
            return;
        }
        user.setSingleAttribute("verifiedMobileNr", "true");
        user.removeAttribute("code");
        user.removeRequiredAction(PROVIDER_ID);
        context.getAuthenticationSession().removeRequiredAction(PROVIDER_ID);
        context.success();
    }

    public void close() {
    }

    private Response createForm(RequiredActionContext context, Consumer<LoginFormsProvider> formConsumer) {
        LoginFormsProvider form = context.form();
        form.setAttribute("username", (Object)context.getUser().getUsername());
        String mobileNumber = context.getUser().getFirstAttribute(MOBILE_NUMBER_FIELD);
        form.setAttribute(MOBILE_NUMBER_FIELD, (Object)(mobileNumber == null ? "" : mobileNumber));
        if (formConsumer != null) {
            formConsumer.accept(form);
        }
        return form.createForm("update-mobile-number.ftl");
    }
}

