/*
 * Decompiled with CFR 0.152.
 */
package dasniko.keycloak.authenticator.gateway;

import dasniko.keycloak.authenticator.SmsConstants;
import dasniko.keycloak.authenticator.gateway.EcallSmsService;
import dasniko.keycloak.authenticator.gateway.SmsService;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceFactory.class);

    public static SmsService get(Map<String, String> config, KeycloakSession session) {
        if (Boolean.parseBoolean(config.getOrDefault(SmsConstants.SIMULATION_MODE, "false"))) {
            return (phoneNumber, message) -> log.warn(String.format("***** SIMULATION MODE ***** Would send SMS to %s with text: %s", phoneNumber, message));
        }
        return new EcallSmsService(config, session);
    }
}

