/*
 * Decompiled with CFR 0.152.
 */
package dasniko.keycloak.authenticator.gateway;

import dasniko.keycloak.authenticator.gateway.SmsService;
import java.io.IOException;
import java.util.Map;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcallSmsService
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(EcallSmsService.class);
    private final String senderNr;
    private final String username;
    private final String password;
    private final KeycloakSession session;

    EcallSmsService(Map<String, String> config, KeycloakSession session) {
        this.senderNr = config.get("senderNr");
        this.username = config.get("username");
        this.password = config.get("password");
        this.session = session;
    }

    @Override
    public void send(String phoneNumber, String message) throws IOException {
        EcallRequestContent content = new EcallRequestContent();
        content.text = message;
        EcallRequestBody body = new EcallRequestBody();
        body.from = this.senderNr;
        body.to = phoneNumber;
        body.content = content;
        SimpleHttp.Response response = SimpleHttp.doPost((String)"https://rest.ecall.ch/api/message", (KeycloakSession)this.session).json((Object)body).authBasic(this.username, this.password).acceptJson().asResponse();
        if (response.getStatus() != 200) {
            throw new IOException("Ecall API call failed with status " + response.getStatus() + ": " + response.asString());
        }
    }

    private static class EcallRequestContent {
        public String type = "Text";
        public String text;

        private EcallRequestContent() {
        }
    }

    private static class EcallRequestBody {
        public String channel = "sms";
        public String from;
        public String to;
        public EcallRequestContent content;

        private EcallRequestBody() {
        }
    }
}

