/*
 * Decompiled with CFR 0.152.
 */
package dasniko.keycloak.authenticator;

import com.google.auto.service.AutoService;
import dasniko.keycloak.authenticator.SmsAuthenticator;
import dasniko.keycloak.authenticator.SmsConstants;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class SmsAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "sms-authenticator";
    private static final SmsAuthenticator SINGLETON = new SmsAuthenticator();

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "SMS Authentication";
    }

    public String getHelpText() {
        return "Validates an OTP sent via SMS to the users mobile phone.";
    }

    public String getReferenceCategory() {
        return "otp";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of(new ProviderConfigProperty(SmsConstants.CODE_LENGTH, "Code length", "The number of digits of the generated code.", "String", (Object)6), new ProviderConfigProperty(SmsConstants.CODE_TTL, "Time-to-live", "The time to live in seconds for the code to be valid.", "String", (Object)"300"), new ProviderConfigProperty(SmsConstants.SENDER_NR, "SenderNr", "The number that is displayed as the message sender on the receiving device.", "String", (Object)"004199999999"), new ProviderConfigProperty(SmsConstants.USERNAME, "Username", "Ecall API username.", "String", (Object)"user"), new ProviderConfigProperty(SmsConstants.PASSWORD, "Password", "Ecall API password.", "Password", (Object)"", true), new ProviderConfigProperty(SmsConstants.SIMULATION_MODE, "Simulation mode", "In simulation mode, the SMS won't be sent, but printed to the server logs", "boolean", (Object)true));
    }

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

