//    This file is part of QTTabBar, a shell extension for Microsoft
//    Windows Explorer.
//    Copyright (C) 2007-2021  Quizo, Paul Accisano
//
//    QTTabBar is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    QTTabBar is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with QTTabBar.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace QTPlugin.Interop {
    [StructLayout(LayoutKind.Sequential)]
    public struct RECT {
        public int left;
        public int top;
        public int right;
        public int bottom;
        public RECT(Rectangle rectangle) {
            left = rectangle.X;
            top = rectangle.Y;
            right = rectangle.Right;
            bottom = rectangle.Bottom;
        }

        public int Width {
            get {
                return Math.Abs((right - left));
            }
        }
        public int Height {
            get {
                return (bottom - top);
            }
        }
        public Rectangle ToRectangle() {
            return new Rectangle(left, top, Width, Height);
        }
    }
}
