module Data.ServerConfig exposing (ServerConfig, decoder, encode)

import Json.Decode as D
import Json.Decode.Pipeline as P
import Json.Encode as E



-- Generated by https://github.com/jhillyerd/go-to-elm-json


type alias ServerConfig =
    { version : String
    , buildDate : String
    , pop3Listener : String
    , webListener : String
    , smtpConfig : SmtpConfig
    , storageConfig : StorageConfig
    }


type alias SmtpConfig =
    { addr : String
    , defaultAccept : Bool
    , acceptDomains : Maybe (List String)
    , rejectDomains : Maybe (List String)
    , defaultStore : Bool
    , storeDomains : Maybe (List String)
    , discardDomains : Maybe (List String)
    , rejectOriginDomains : Maybe (List String)
    }


type alias StorageConfig =
    { mailboxMsgCap : Int
    , storeType : String
    , retentionPeriod : String
    }


decoder : D.Decoder ServerConfig
decoder =
    D.succeed ServerConfig
        |> P.required "version" D.string
        |> P.required "build-date" D.string
        |> P.required "pop3-listener" D.string
        |> P.required "web-listener" D.string
        |> P.required "smtp-config" smtpConfigDecoder
        |> P.required "storage-config" storageConfigDecoder


encode : ServerConfig -> E.Value
encode r =
    E.object
        [ ( "version", E.string r.version )
        , ( "build-date", E.string r.buildDate )
        , ( "pop3-listener", E.string r.pop3Listener )
        , ( "web-listener", E.string r.webListener )
        , ( "smtp-config", encodeSmtpConfig r.smtpConfig )
        , ( "storage-config", encodeStorageConfig r.storageConfig )
        ]


smtpConfigDecoder : D.Decoder SmtpConfig
smtpConfigDecoder =
    D.succeed SmtpConfig
        |> P.required "addr" D.string
        |> P.required "default-accept" D.bool
        |> P.required "accept-domains" (D.nullable (D.list D.string))
        |> P.required "reject-domains" (D.nullable (D.list D.string))
        |> P.required "default-store" D.bool
        |> P.required "store-domains" (D.nullable (D.list D.string))
        |> P.required "discard-domains" (D.nullable (D.list D.string))
        |> P.required "reject-origin-domains" (D.nullable (D.list D.string))


encodeSmtpConfig : SmtpConfig -> E.Value
encodeSmtpConfig r =
    E.object
        [ ( "addr", E.string r.addr )
        , ( "default-accept", E.bool r.defaultAccept )
        , ( "accept-domains", maybe (E.list E.string) r.acceptDomains )
        , ( "reject-domains", maybe (E.list E.string) r.rejectDomains )
        , ( "default-store", E.bool r.defaultStore )
        , ( "store-domains", maybe (E.list E.string) r.storeDomains )
        , ( "discard-domains", maybe (E.list E.string) r.discardDomains )
        , ( "reject-origin-domains", maybe (E.list E.string) r.rejectOriginDomains )
        ]


storageConfigDecoder : D.Decoder StorageConfig
storageConfigDecoder =
    D.succeed StorageConfig
        |> P.required "mailbox-msg-cap" D.int
        |> P.required "store-type" D.string
        |> P.required "retention-period" D.string


encodeStorageConfig : StorageConfig -> E.Value
encodeStorageConfig r =
    E.object
        [ ( "mailbox-msg-cap", E.int r.mailboxMsgCap )
        , ( "store-type", E.string r.storeType )
        , ( "retention-period", E.string r.retentionPeriod )
        ]


maybe : (a -> E.Value) -> Maybe a -> E.Value
maybe encoder =
    Maybe.map encoder >> Maybe.withDefault E.null
