#ifndef UNICORN_M68K_H
#define UNICORN_M68K_H

/* Unicorn Emulator Engine */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2014-2015 */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(disable:4201)
#endif

//> M68K registers
typedef enum uc_m68k_reg {
    UC_M68K_REG_INVALID = 0,

    UC_M68K_REG_A0,
    UC_M68K_REG_A1,
    UC_M68K_REG_A2,
    UC_M68K_REG_A3,
    UC_M68K_REG_A4,
    UC_M68K_REG_A5,
    UC_M68K_REG_A6,
    UC_M68K_REG_A7,

    UC_M68K_REG_D0,
    UC_M68K_REG_D1,
    UC_M68K_REG_D2,
    UC_M68K_REG_D3,
    UC_M68K_REG_D4,
    UC_M68K_REG_D5,
    UC_M68K_REG_D6,
    UC_M68K_REG_D7,

    UC_M68K_REG_SR,
    UC_M68K_REG_PC,

    UC_M68K_REG_ENDING,   // <-- mark the end of the list of registers
} uc_m68k_reg;

#ifdef __cplusplus
}
#endif

#endif
