<samp>

# Learning

## how to measure react code performance

- [ ] Record performance profiling and analyze Long-Tasks
  - Performance tab
  - Long-Tasks
  - Source maps
- [ ] Profiling / Benchmarking
  - Use and test [Tachometer](https://github.com/Polymer/tachometer)

## Skills

- [ ] Optimizing JavaScript for the main thread
  - Working with Web Workers / Service Workers
- [ ] Architecture
  - [ ] Server Side Rendering
  - [ ] Client Side Rendering
  - [ ] Partial / Progressive Hydration

# Skills

Skills from job listings:

- You know the weirdest parts of JavaScript and love working with it anyway.
- You have extensive experience working with the performance profiling and optimizing of JavaScript and CSS, using debugging tools in your web browser of choice.
- You have experience detecting and fixing JavaScript memory leaks.You love keeping up to date with the evolving capabilities of JavaScript, but know when to temper that excitement with caution.
- You’ve worked with React (or at least understand why it’s important). Familiarity with Redux will also come in handy.
- You’ve been working with front end frameworks and libraries professionally for 5+ years (and having contributed to some is a big plus.)
- Diving into a new system to understand mysterious behavior excites you, and the phrase “things are slow, but only sometimes” sounds like the start of a great adventure
- You write understandable, testable code with an eye towards maintainability and scalability.
- You are comfortable with SQL and making sense of data.
- You are a strong communicator and are equally comfortable talking with your immediate team, other frontend engineers, or even backend infrastructure engineers.
- You are ready to learn, but just as excited to teach.
- You understand that the perfect solution is informed by the people who will be building on your work, rather than being purely dependent on technical merits. Empathy is a feature.
- You have a bachelor's degree in Computer Science, Engineering or a related field, or equivalent training, fellowship, or work experience.
- You've worked with React (or at least understand why its important). Familiarity with Redux will also come in handy.
- You've been working with front end frameworks and libraries professionally for 5+ years (and having contributed to some is a big plus.)
- Build and maintain a highly performant application
- Propose new, efficient approaches to performance in line with our product vision
- At least 5+ years of experience working as a software engineer with a focus on performance optimization
- Deeply understanding of the JavaScript ecosystem
- Experience with optimizing browser rendering performance
- Experience developing and implementing performance tests and experiments
- Enable and support our international and multidisciplinary clients and project teams to create great user experiences
- Carry out technical web performance audits
- Improve web performance audit workflows
- Present technical audit results to clients
- Predict the optimization outcome with Cloudflare Workers
- Integrate web performance tools in project setups
- Develop web performance tools
- Support Frontend Engineers and Architects in project teams
- Create and give technical web performance training
- Define best practices and standards
- Be curious and stay up to date with web performance topics
- Be an active member of the web performance community inside and outside of the company
- Benchmarking, measurement, statistical analysis, reporting

</samp>
