<samp>

# Web Performance Research

This repository is a compilation of resources I consumed over time to gain knowledge and do my own research on web performance.

## Table of Contents

- [Web Performance Research](#web-performance-research)
  - [Table of Contents](#table-of-contents)
  - [Architecture](#architecture)
  - [Backend](#backend)
  - [Browser](#browser)
    - [Service Workers / Workers](#service-workers--workers)
    - [Rendering Engines](#rendering-engines)
  - [Build tools](#build-tools)
  - [Cache \& Memoization](#cache--memoization)
  - [Career](#career)
  - [Case Studies](#case-studies)
  - [Community](#community)
    - [Books](#books)
    - [Blogs](#blogs)
    - [Conferences \& Meetups](#conferences--meetups)
    - [Courses](#courses)
    - [Podcasts](#podcasts)
  - [Core Web Vitals](#core-web-vitals)
    - [Cumulative Layout Shift (CLS)](#cumulative-layout-shift-cls)
    - [Largest Contentful Paint (LCP)](#largest-contentful-paint-lcp)
    - [First Input Delay (FID)](#first-input-delay-fid)
    - [Interaction to Next Paint (INP)](#interaction-to-next-paint-inp)
    - [Total Blocking Time](#total-blocking-time)
  - [CSS](#css)
  - [Fonts](#fonts)
    - [Fonts Tools](#fonts-tools)
  - [General](#general)
    - [Why it matters](#why-it-matters)
  - [Images](#images)
    - [Images Tools](#images-tools)
  - [Infrastructure](#infrastructure)
  - [JavaScript](#javascript)
  - [Measuring Performance](#measuring-performance)
    - [Runtime Performance](#runtime-performance)
    - [DevTools](#devtools)
    - [How to metric](#how-to-metric)
    - [Benchmark](#benchmark)
    - [Measure Tools](#measure-tools)
    - [Memory Management](#memory-management)
  - [Performance Budget](#performance-budget)
    - [Performance Budget Tools](#performance-budget-tools)
  - [Prefetching](#prefetching)
    - [Prefetching Tools](#prefetching-tools)
  - [Web Frameworks](#web-frameworks)
    - [React](#react)
    - [React Rendering](#react-rendering)
    - [Measuring React](#measuring-react)
  - [Sustainability](#sustainability)
  - [Tweets](#tweets)
  - [UX](#ux)
  - [Web APIs](#web-apis)
  - [License](#license)

## Architecture

- [🎥 Advanced Rendering Patterns](https://www.youtube.com/watch?v=PN1HgvAOmi8&ab_channel=RealWorldReact)
- [🎥 Rendering on the Web: Performance Implications of Application Architecture](https://www.youtube.com/watch?v=k-A2VfuUROg)
- [🎥 Stream Away the Wait](https://www.youtube.com/watch?v=gb2DGJB1ZsM&ab_channel=ReactNext)
- [🎥 Streaming in Next.js](https://www.youtube.com/watch?v=Nl4OwNhh2QI)
- [🎥 What happens before hydration](https://www.youtube.com/watch?v=PGLwRv64RzM)
- [📝 2023 Web Framework Performance Report](https://astro.build/blog/2023-web-framework-performance-report)
- [📝 A Modern Take on Cutting the Mustard](https://snugug.com/musings/modern-cutting-the-mustard)
- [📝 Apply instant loading with the PRPL pattern](https://web.dev/apply-instant-loading-with-prpl)
- [📝 Comparing SPAs to SSG and SSR](https://fauna.com/blog/comparing-spas-to-ssg-and-ssr)
- [📝 Concurrent mode and partial hydration in React](https://twitter.com/dan_abramov/status/1200111677833973760)
- [📝 Conquering JavaScript Hydration](https://dev.to/ryansolid/conquering-javascript-hydration-a9f)
- [📝 Conquering JavaScript Hydration](https://dev.to/this-is-learning/conquering-javascript-hydration-a9f)
- [📝 Crafting a high-performance TV user interface using React](https://netflixtechblog.com/crafting-a-high-performance-tv-user-interface-using-react-3350e5a6ad3b)
- [📝 Flexible Architectures for Web Performance](https://www.youtube.com/watch?v=aIfB12cQW9A)
- [📝 From Static to Interactive: Why Resumability is the Best Alternative to Hydration](https://www.builder.io/blog/from-static-to-interactive-why-resumability-is-the-best-alternative-to-hydration)
- [📝 How to do partial hydration in React](https://twitter.com/iamakulov/status/1437415799514271746)
- [📝 Instant Loading Web Apps with an Application Shell Architecture](https://developers.google.com/web/updates/2015/11/app-shell)
- [📝 Islands Architecture](https://jasonformat.com/islands-architecture)
- [📝 Next.js: The Ultimate Cheat Sheet To Page Rendering](https://guydumais.digital/blog/next-js-the-ultimate-cheat-sheet-to-page-rendering)
- [📝 Rendering Fundamentals](https://beta.nextjs.org/docs/rendering/fundamentals)
- [📝 Rendering on the Web](https://developers.google.com/web/updates/2019/02/rendering-on-the-web)
- [📝 Rendering Options on the Web: Server, Client, Static](https://thetombomb.com/posts/rendering-options-on-the-web)
- [📝 Rendering Patterns](https://www.patterns.dev/posts/rendering-patterns)
- [📝 Server-Side Rendering: How Resumable Beats Hydration](https://betterprogramming.pub/how-resumable-beats-hydration-f845bfebc31e)
- [📝 Signals: the nitty-gritty](https://calendar.perfplanet.com/2022/signals-the-nitty-gritty)
- [📝 SPAs: theory versus practice](https://nolanlawson.com/2022/06/27/spas-theory-versus-practice)
- [📝 Suspense hydration in React](https://twitter.com/iamakulov/status/1537085468327587840)
- [📝 The Benefits of Server Side Rendering Over Client Side Rendering](https://medium.com/walmartglobaltech/the-benefits-of-server-side-rendering-over-client-side-rendering-5d07ff2cefe8)
- [📝 The case of partial hydration (with Next and Preact)](https://medium.com/@luke_schmuke/how-we-achieved-the-best-web-performance-with-partial-hydration-20fab9c808d5)
- [📝 The Future (and the Past) of the Web is Server Side Rendering](https://deno.com/blog/the-future-and-past-is-server-side-rendering)
- [📝 Understanding Progressive Enhancement](https://alistapart.com/article/understandingprogressiveenhancement)
- [📝 Understanding Rendering in the Jamstack](https://bejamas.io/blog/understanding-rendering-in-the-jamstack)
- [📝 Web Rendering Patterns](https://www.youtube.com/watch?v=5xeuv9c1Fkw)
- [📝 What is partial hydration and why is everyone talking about it?](https://ajcwebdev.com/what-is-partial-hydration-and-why-is-everyone-talking-about-it)
- [📝 Why Efficient Hydration in JavaScript Frameworks is so Challenging](https://dev.to/this-is-learning/why-efficient-hydration-in-javascript-frameworks-is-so-challenging-1ca3)

## Backend

- [📝 Everything You Know About Latency Is Wrong](https://bravenewgeek.com/everything-you-know-about-latency-is-wrong)

## Browser

- [🎥 An Introduction to Browser Rendering](https://www.youtube.com/watch?v=n1cKlKM3jYI&ab_channel=UmarHansa)
- [🎥 Cache Control](https://www.youtube.com/watch?v=fccw0kmsG6g&ab_channel=ReactNext)
- [🎥 Cache your fonts, images & pages - Unpacking the Workbox](https://www.youtube.com/watch?v=utxTqssjp-o&ab_channel=GoogleChromeDevelopers)
- [🎥 Critical rendering path - Crash course on web performance](https://www.youtube.com/watch?v=PkOBnYxqj3k&ab_channel=IlyaGrigorik)
- [🎥 Delivering 60 FPS in the browser](https://www.youtube.com/watch?v=rpNXWxMyzHQ&ab_channel=IlyaGrigorik)
- [🎥 Delivering 60 FPS in the browser](https://www.youtube.com/watch?v=rpNXWxMyzHQ&t=1s&ab_channel=IlyaGrigorik)
- [🎥 Get Your "head" Straight](https://www.youtube.com/watch?v=MHyAOZ45vnU)
- [🎥 Getting Out Of Users' Way: Less Jank With Web Workers](https://www.youtube.com/watch?v=4CWzB5Mi3Ik)
- [🎥 How We Used WebAssembly To Speed Up Our Web App By 20X (Case Study)](https://www.smashingmagazine.com/2019/04/webassembly-speed-web-app)
- [🎥 In The Loop - setTimeout, micro tasks, requestAnimationFrame, requestIdleCallback](https://www.youtube.com/watch?v=cCOL7MC4Pl0&ab_channel=JSConf)
- [🎥 Optimizing the Critical Rendering Path for Instant Mobile Websites](https://www.youtube.com/watch?v=YV1nKLWoARQ&ab_channel=IlyaGrigorik)
- [🎥 Scheduling On and Off the Main Thread](https://www.youtube.com/watch?v=mDdgfyRB5kg)
- [🎥 The main thread is overworked & underpaid](https://www.youtube.com/watch?v=7Rrv9qFMWNM)
- [🎥 There is a client-side proxy (ServiceWorker) in your browser](https://www.youtube.com/watch?v=etACK2qbHfc&ab_channel=IlyaGrigorik)
- [🎥 WebAssembly as cross-platform architecture](https://www.youtube.com/watch?v=l2DHjRmgAF8&ab_channel=Nordic.js)
- [📝 60 fps on the mobile web](https://engineering.flipboard.com/2015/02/mobile-web)
- [📝 Accelerated Rendering in Chrome](http://www.html5rocks.com/en/tutorials/speed/layers)
- [📝 Accelerating JavaScript (in the browser)](https://jonathandinu.com/blog/accelerating-js)
- [📝 Adaptive Serving using JavaScript and the Network Information API](https://dev.to/addyosmani/adaptive-serving-using-javascript-and-the-network-information-api-331p)
- [📝 Add the Priority Hints changes to the html spec](https://github.com/whatwg/html/pull/8470)
- [📝 Avoiding layout thrashing — Web Fundamentals](https://developers.google.com/web/fundamentals/performance/rendering/avoid-large-complex-layouts-and-layout-thrashing)
- [📝 Browser Performance](https://www.kuniga.me/blog/2020/03/28/browser-performance.html)
- [📝 Conclusions from Off Main Thread & Worker Exploration](https://docs.google.com/document/d/1nu0EcVNC3jtmUVWL8Gs5eCj2p_984kamNhG2nS9gOC0/edit#)
- [📝 Don't Block the Event Loop (or the Worker Pool)](https://nodejs.org/en/learn/asynchronous-work/dont-block-the-event-loop)
- [📝 Don't fight the browser preload scanner](https://web.dev/preload-scanner)
- [📝 Dynamic page content with Cloudflare Workers](https://fershad.com/writing/dynamic-page-content-with-cloudflare-workers)
- [📝 Fast is good, instant is better!](https://calendar.perfplanet.com/2022/fast-is-good-instant-is-better)
- [📝 Fixing Layout thrashing in the real world | Matt Andrews](https://mattandre.ws/2014/05/really-fixing-layout-thrashing)
- [📝 Frontend Web Performance: The Essentials 0](https://medium.com/@matthew.costello/frontend-web-performance-the-essentials-0-61fea500b180)
- [📝 Frontend Web Performance: The Essentials 1](https://medium.com/@matthew.costello/frontend-web-performance-the-essentials-1-cb6513e1c3a1)
- [📝 Get to know your browser's performance profiler](https://blog.atomrc.dev/p/js-performance-profiling)
- [📝 How JavaScript works: A comparison with WebAssembly + why in certain cases it’s better to use it over JavaScript](https://blog.sessionstack.com/how-javascript-works-a-comparison-with-webassembly-why-in-certain-cases-its-better-to-use-it-d80945172d79)
- [📝 How JavaScript works: Deep dive into WebSockets and HTTP/2 with SSE + how to pick the right path](https://blog.sessionstack.com/how-javascript-works-deep-dive-into-websockets-and-http-2-with-sse-how-to-pick-the-right-path-584e6b8e3bf7?source=collection_home---4------0----------------)
- [📝 How JavaScript works: The building blocks of Web Workers + 5 cases when you should use them](https://blog.sessionstack.com/how-javascript-works-the-building-blocks-of-web-workers-5-cases-when-you-should-use-them-a547c0757f6a)
- [📝 How the browser renders a web page? — DOM, CSSOM, and Rendering](https://medium.com/jspoint/how-the-browser-renders-a-web-page-dom-cssom-and-rendering-df10531c9969)
- [📝 How to eliminate render blocking resources](https://www.debugbear.com/blog/render-blocking-resources)
- [📝 How we cut 99% of our JavaScript with Qwik + Partytown](https://www.builder.io/blog/how-we-cut-99-percent-js-with-qwik-and-partytown)
- [📝 Improving Paint Metrics by Removing Unused Preloads](https://blog.webpagetest.org/posts/removing-unused-preloads-on-festival-foods)
- [📝 Introducing Partytown 🎉: Run Third-Party Scripts From a Web Worker](https://dev.to/adamdbradley/introducing-partytown-run-third-party-scripts-from-a-web-worker-2cnp)
- [📝 JavaScript DOM Manipulation Performance](https://www.diva-portal.org/smash/get/diva2:1436661/FULLTEXT01.pdf)
- [📝 JavaScript performance beyond bundle size](https://nolanlawson.com/2021/02/23/javascript-performance-beyond-bundle-size)
- [📝 Minimizing browser reflow | PageSpeed Insights | Google Developers](https://developers.google.com/speed/articles/reflow?hl=en)
- [📝 Modern Multi-Process Browser Architecture](https://helgeklein.com/blog/modern-multi-process-browser-architecture)
- [📝 Notes on how browsers work](https://www.kuniga.me/blog/2015/10/09/notes-on-how-browsers-work.html)
- [📝 Notes on JavaScript Interpreters](https://www.kuniga.me/blog/2017/06/01/notes-on-javascript-interpreters.html)
- [📝 Notes on Javascript Memory Profiling in Google Chrome](https://www.kuniga.me/blog/2015/06/07/notes-on-javascript-memory-profiling-in-google-chrome.html)
- [📝 Now THAT’S What I Call Service Worker!](https://alistapart.com/article/now-thats-what-i-call-service-worker)
- [📝 Optimizing Web Content in UIWebViews and Websites on iOS](https://developer.apple.com/videos/wwdc/2012/?id=601)
- [📝 Prerender pages in Chrome for instant page navigations](https://developer.chrome.com/blog/prerender-pages)
- [📝 Preventing &apos;layout thrashing&apos; | Wilson Page](http://wilsonpage.co.uk/preventing-layout-thrashing)
- [📝 Profiling & Optimizing the runtime performance with the DevTools Performance tab](https://www.iamtk.co/profiling-and-optimizing-the-runtime-performance-with-the-devtools-performance-tab)
- [📝 Proxying Cloudinary image requests with Cloudflare Workers](https://fershad.com/writing/proxy-cloudinary-with-cloudflare-workers)
- [📝 reflows & repaints: css performance making your javascript slow?](http://www.stubbornella.org/content/2009/03/27/reflows-repaints-css-performance-making-your-javascript-slow)
- [📝 Rendering: repaint, reflow/relayout, restyle / Stoyan](http://www.phpied.com/rendering-repaint-reflowrelayout-restyle)
- [📝 Rendering: repaint, reflow/relayout, restyle](https://www.phpied.com/rendering-repaint-reflowrelayout-restyle)
- [📝 Scrolling performance](https://web.dev/speed-scrolling)
- [📝 Setting up Cloudflare Workers for web performance optimisation and testing](https://nooshu.com/blog/2021/03/14/setting-up-cloudflare-workers-for-web-performance-optimisation-and-testing)
- [📝 Smaller HTML Payloads with Service Workers](https://philipwalton.com/articles/smaller-html-payloads-with-service-workers)
- [📝 So you heard of Client-Hints and you think you got time, right? Wrong](https://calendar.perfplanet.com/2022/so-you-heard-of-client-hints-and-you-think-you-got-time-right-wrong)
- [📝 Understanding Reflow and Repaint in the browser](https://dev.to/gopal1996/understanding-reflow-and-repaint-in-the-browser-1jbg)
- [📝 Use web workers to run JavaScript off the browser's main thread](https://web.dev/off-main-thread)
- [📝 Using Cloudflare Workers to inline external CSS](https://fershad.com/writing/cloudflare-workers-inline-external-css)
- [📝 We spent a week making Trello boards load extremely fast. Here’s how we did it. - Fog Creek Blog](http://blog.fogcreek.com/we-spent-a-week-making-trello-boards-load-extremely-fast-heres-how-we-did-it)
- [📝 Web Browser Engineering](https://browser.engineering)
- [📝 Web Workers](https://www.kuniga.me/blog/2016/08/04/web-workers.html)
- [📝 WebKit Architecture](http://webkithacks.github.io/webkit_presentations/architecture)
- [📝 What forces layout / reflow](https://gist.github.com/paulirish/5d52fb081b3570c81e3a)
- [📝 What makes the web slow? browser's bottleneck](https://medhatdawoud.net/blog/what-makes-the-web-slow)
- [📝 When should you be using Web Workers?](https://surma.dev/things/when-workers)
- [📝 wilsonpage/fastdom](https://github.com/wilsonpage/fastdom)

### Service Workers / Workers

- [🎥 Boost Your Site Performance with Partytown](https://www.youtube.com/watch?v=AsZXN8SYoa4&ab_channel=Builder)
- [🎥 Speed Up Your Site with Workers](https://www.youtube.com/watch?v=yEtT0C4vsRM&ab_channel=Builder)
- [📝 Cloudflare Worker recipes for frontend performance testing](https://nooshu.com/blog/2021/03/02/cloudflare-worker-recipes-for-frontend-performance-testing)
- [📝 Get off the main thread with an inline web worker: an example](https://calendar.perfplanet.com/2022/get-off-the-main-thread-with-an-inline-web-worker-an-example)
- [📝 How Partytown Eliminates Website Bloat From Third-Party Scripts](https://www.smashingmagazine.com/2022/04/partytown-eliminates-website-bloat-third-party-apps)
- [📝 Introduction to Workbox and service workers](https://developer.chrome.com/docs/workbox/service-worker-overview)
- [📝 Making the Web Faster with Service Workers and Performance Research](https://calendar.perfplanet.com/2022/making-the-web-faster-with-service-workers-and-performance-research)
- [📝 Service worker caching and HTTP caching](https://web.dev/service-worker-caching-and-http-caching)
- [📝 Setting up Cloudflare Workers for web performance optimisation and testing](https://nooshu.com/blog/2021/03/14/setting-up-cloudflare-workers-for-web-performance-optimisation-and-testing)
- [📝 Workbox: JavaScript libraries for Progressive Web Apps](https://github.com/GoogleChrome/workbox)
- [🛠 Partytown](https://partytown.builder.io)

### Rendering Engines

- [🎥 JavaScript Engines: The Good Parts](https://www.youtube.com/watch?v=5nmpokoRaZI&ab_channel=JSConf)
- [🎥 Life of a Pixel](https://www.youtube.com/watch?v=K2QHdgAKP-s)
- [🎥 Rendering performance inside out](https://www.youtube.com/watch?v=BfMWAIc0xSU&ab_channel=Front-Trends)
- [📝 RenderingNG: the new rendering engine of chrome](https://developer.chrome.com/articles/renderingng)
- [📝 The whole web at maximum FPS: How WebRender gets rid of jank](https://hacks.mozilla.org/2017/10/the-whole-web-at-maximum-fps-how-webrender-gets-rid-of-jank)
- [📝 Why Web Developers Need to Care about Interactivity](https://philipwalton.com/articles/why-web-developers-need-to-care-about-interactivity)

## Build tools

- [📝 Webpack Tree Shaking](https://webpack.js.org/guides/tree-shaking/#clarifying-tree-shaking-and-sideeffects)
- [📝 Using Native JavaScript Modules in Production Today](https://philipwalton.com/articles/using-native-javascript-modules-in-production-today)
- [📝 speed-measure-webpack-plugin](https://www.npmjs.com/package/speed-measure-webpack-plugin)
- [📝 Doing Differential Serving in 2019](https://calendar.perfplanet.com/2018/doing-differential-serving-in-2019)
- [📝 Publish, ship, and install modern JavaScript for faster applications](https://web.dev/publish-modern-javascript)
- [📝 Awesome Webpack Perf](https://github.com/iamakulov/awesome-webpack-perf)
- [📝 Faster JavaScript Builds with Metro](https://medium.com/airbnb-engineering/faster-javascript-builds-with-metro-cfc46d617a1f)
- [📝 13 Webpack Optimization Tips You Should Know](https://medium.com/frontend-canteen/13-webpack-optimization-tips-you-should-know-668666f8c020)
- [📝 Finding and fixing duplicates in webpack with Inspectpack](https://formidable.com/blog/2018/finding-webpack-duplicates-with-inspectpack-plugin)
- [📝 How to Improve Webpack Performance](https://medium.com/javascript-in-plain-english/how-to-improve-webpack-performance-7637db26fa5f)
- [📝 Webperformance and Compression](https://calendar.perfplanet.com/2022/webperformance-and-compression)
- [📝 Keep webpack Fast: A Field Guide for Better Build Performance](https://slack.engineering/keep-webpack-fast-a-field-guide-for-better-build-performance)
- [:octocat: Webpack Libs Optimizations](https://github.com/GoogleChromeLabs/webpack-libs-optimizations)
- [:octocat: Awesome Webpack Perf](https://github.com/iamakulov/awesome-webpack-perf)

## Cache & Memoization

- [🎥 Love your cache: Optimize for the second load](https://www.youtube.com/watch?v=tprJYFkv4LU&ab_channel=GoogleChromeDevelopers)

## Career

- [perfwork: the job board for web performance enthusiasts](https://perfwork.com)
- [Full Stack Software Engineer at Mozilla Corp](jobs/mozilla-full-stack-software-engineer.pdf)
- [Senior Performance Software Engineer at Mozilla Corp](jobs/mozilla-senior-performance-software-engineer.pdf)
- [Web Performance Engineer (w/m/d) - Remote or Hamburg at Bagend](<jobs/baqend-web-performance-engineer-(w_m_d)-Remote-or-Hamburg.pdf>)
- [Software Engineer (L4) - UI Rendering & Performance at Netflix](<jobs/netflix-software-engineer-(L4)-UI-Rendering-&-Performance.pdf>)

## Case Studies

- [🎥 Building Performance for the Long Term](https://vimeo.com/showcase/4970467/video/254947097)
- [🎥 Core Web Vitals: Theory and practice](https://www.youtube.com/watch?v=8xpjecvxnRM)
- [🎥 Lessons learned from performance monitoring in Chrome](https://www.youtube.com/watch?v=ctavZT87syI)
- [🎥 Optimizing Preview Popups](https://www.youtube.com/watch?v=sKvK3x9zdt0&ab_channel=YoavWeiss)
- [🎥 Performance Signup in React & Transactional Apps with Redux](https://www.youtube.com/watch?v=V8oTJ8OZ5S0&ab_channel=NetflixUIEngineering)
- [🎥 Several Components are Rendering: Client Performance at Slack-Scale](https://www.infoq.com/presentations/slack-front-performance)
- [📝 300ms Faster: Reducing Wikipedia's Total Blocking Time](https://www.nray.dev/blog/300ms-faster-reducing-wikipedias-total-blocking-time)
- [📝 A Netflix Web Performance Case Study](https://medium.com/dev-channel/a-netflix-web-performance-case-study-c0bcde26a9d9)
- [📝 A Pinterest Progressive Web App Performance Case Study](https://medium.com/dev-channel/a-pinterest-progressive-web-app-performance-case-study-3bd6ed2e6154?source=search_post---------6)
- [📝 A Tinder PWA Performance Case Study](https://medium.com/@addyosmani/a-tinder-progressive-web-app-performance-case-study-78919d98ece0)
- [📝 Agrofy: A 70% improvement in LCP correlated to a 76% reduction in load abandonment](https://web.dev/agrofy)
- [📝 Analyzing Wikipedia Users' Perceived Quality of Experience](resources/analyzing-wikipedia-users-perceived-quality-of-experience-a-large-scale-study.pdf)
- [📝 Building a Better Web - Part 1: A faster YouTube on web](https://web.dev/better-youtube-web-part1)
- [📝 Case Study Renault Group](https://web.dev/renault)
- [📝 Case study: Analyzing Notion app performance](https://3perf.com/blog/notion)
- [📝 Case study: analyzing the Walmart site performance](https://iamakulov.com/notes/walmart)
- [📝 Crafting a high-performance TV user interface using React](https://netflixtechblog.com/crafting-a-high-performance-tv-user-interface-using-react-3350e5a6ad3b)
- [📝 Economic Times quest for fixing INP](https://web.dev/case-studies/economic-times-inp)
- [📝 Enhancing The New York Times Web Performance with React 18](https://open.nytimes.com/enhancing-the-new-york-times-web-performance-with-react-18-d6f91a7c5af8)
- [📝 From Development to Real Users: How to Create a Web Performance Story](https://engineering.atspotify.com/2022/09/from-development-to-real-users-how-to-create-a-web-performance-story)
- [📝 Gantry: Slack’s Fast-booting Frontend Framework](https://slack.engineering/gantry-slacks-fast-booting-frontend-framework-fb70c8eed2fd)
- [📝 How Carpe achieved record-breaking sales by focusing on performance optimization](https://performance.shopify.com/blogs/blog/how-carpe-achieved-record-breaking-sales-by-focusing-on-performance-optimization)
- [📝 How CLS optimizations increased Yahoo! JAPAN News's page views per session by 15%](https://web.dev/yahoo-japan-news)
- [📝 How Mercado Libre optimized for Web Vitals (TBT/FID)](https://web.dev/how-mercadolibre-optimized-web-vitals)
- [📝 How PubTech's Consent Management Platform reduced INP on their customers' websites by up to 64%, while also improving ad viewability by up to 1.5%](https://web.dev/case-studies/pubconsent-inp)
- [📝 How QuintoAndar increased conversion rates and pages per session by improving page performance](https://web.dev/quintoandar)
- [📝 How Rakuten 24's investment in Core Web Vitals increased revenue per visitor by 53.37% and conversion rate by 33.13%](https://web.dev/rakuten)
- [📝 How redBus improved their website's Interaction to Next Paint (INP) and increased sales by 7%](https://web.dev/case-studies/redbus-inp)
- [📝 How Sunday Citizen improved conversions by focusing on performance](https://performance.shopify.com/blogs/blog/how-sunday-citizen-improved-conversions-by-focusing-on-performance)
- [📝 How to convince your client to focus on Web Performance: a case study](https://medium.com/@armelpingault/how-to-convince-your-client-to-focus-on-web-performance-a-case-study-35f12385689)
- [📝 How Trendyol reduced INP by 50%, resulting in a 1% uplift on click-through rate](https://web.dev/case-studies/trendyol-inp)
- [📝 How We Improved React Loading Times by 70% with Next.js](https://www.causal.app/blog/next-js)
- [📝 How we reduced Next.js page size by 3.5x and achieved a 98 Lighthouse score](https://papyrus.dev/@PapyrusBlog/how-we-reduced-next.js-page-size-by-3.5x-and-achieved-a-98-lighthouse-score?)
- [📝 How Wix improved TTFB with 103 Early Hints](https://web.archive.org/web/20230313110110/https://twitter.com/alonkochba/status/1584418867295965184)
- [📝 HughesNet vs Tesla: A Case Study in Field Data vs Lab Data](https://tannerhodges.com/blog/hughesnet-vs-tesla-a-case-study-in-field-data-vs-lab-data)
- [📝 Improve user experience! How we manage the Core Web Vitals on our Yahoo! JAPAN News website](https://techblog.yahoo.co.jp/entry/2021022230076263)
- [📝 Improving JavaScript Bundle Performance With Code-Splitting](https://www.smashingmagazine.com/2022/02/javascript-bundle-performance-code-splitting)
- [📝 Improving Smashing Magazine’s Web Performance: A Case Study](https://www.smashingmagazine.com/2014/09/improving-smashing-magazine-performance-case-study)
- [📝 Journey of Improving React App Performance by 10x](https://medium.com/technogise/journey-of-improving-react-app-performance-by-10x-9195d4b483d4)
- [📝 Making GitHub’s new homepage fast and performant](https://github.blog/2021-01-29-making-githubs-new-homepage-fast-and-performant)
- [📝 Making instagram.com faster: Code size and execution optimizations (Part 4)](https://instagram-engineering.com/making-instagram-com-faster-code-size-and-execution-optimizations-part-4-57668be796a8)
- [📝 Making Instagram.com faster: Part 1](https://instagram-engineering.com/making-instagram-com-faster-part-1-62cc0c327538)
- [📝 Making Instagram.com faster: Part 2](https://instagram-engineering.com/making-instagram-com-faster-part-2-f350c8fba0d4)
- [📝 Making Instagram.com faster: Part 3 — cache first](https://instagram-engineering.com/making-instagram-com-faster-part-3-cache-first-6f3f130b9669)
- [📝 NDTV achieved a 55% improvement in LCP by optimizing for Core Web Vitals](https://web.dev/ndtv)
- [📝 Nikkei achieves a new level of quality and performance with their multi-page PWA](https://developers.google.com/web/showcase/2018/nikkei)
- [📝 Notion's page load and navigation times just got faster](https://www.notion.so/blog/faster-page-load-navigation)
- [📝 Optimizing Core Web Vitals on a Next.js app](https://www.patterns.dev/posts/nextjs-casestudy)
- [📝 Optimizing INP for a React App & Performance Learnings](https://www.iamtk.co/optimizing-inp-for-a-react-app-and-performance-learnings)
- [📝 Optimizing the Performance of a React Progressive Web App](https://www.iamtk.co/optimizing-the-performance-of-a-react-progressive-web-app)
- [📝 Performance audit of an Italian news website](https://www.giacomodebidda.com/posts/performance-audit-of-an-italian-news-website)
- [📝 Quick Performance Audit - Taiwan COVID Vaccination Website](https://fershad.com/writing/quick-performance-audit-taiwan-covid-vaccination-website)
- [📝 React Performance Fixes on Airbnb Listing Pages](https://medium.com/airbnb-engineering/recent-web-performance-fixes-on-airbnb-listing-pages-6cd8d93df6f4)
- [📝 REI: FCP and LCP improvements](https://engineering.rei.com/web-performance/catch-the-wheel.html)
- [📝 Speed Matters, But It Isn’t Everything](https://engineering.indeedblog.com/blog/2022/01/speed-matters)
- [📝 Spotify Performance Profiling](https://twitter.com/iamakulov/status/1522008502398554113)
- [📝 The Impact of Web Performance](https://simplified.dev/performance/impact-of-web-performance)
- [📝 The Road to Great Product Performance: The First Steps](https://lucianohgo.com/posts/the-road-to-great-product-performance-first-steps)
- [📝 Treebo: A React PWA Performance Case Study](https://medium.com/dev-channel/treebo-a-react-and-preact-progressive-web-app-performance-case-study-5e4f450d5299)
- [📝 Twitter Lite and High Performance React Progressive Web Apps at Scale](https://medium.com/@paularmstrong/twitter-lite-and-high-performance-react-progressive-web-apps-at-scale-d28a00e780a3)
- [📝 Web dev: Case Study](https://web.dev/tags/case-study)
- [📝 Web performance case study: Wikipedia page previews](https://techblog.wikimedia.org/2020/11/23/web-performance-case-study-wikipedia-page-previews)
- [📝 Web Performance Regression Detection (Part 1 of 3)](https://medium.com/pinterest-engineering/web-performance-regression-detection-part-1-of-3-86dcc6d5fce9)
- [📝 Web Performance Regression Detection (Part 2 of 3)](https://medium.com/pinterest-engineering/web-performance-regression-detection-part-2-of-3-9e0b9d35a11f)
- [📝 Web Performance Regression Detection (Part 3 of 3)](https://medium.com/pinterest-engineering/web-performance-regression-detection-part-3-of-3-4251b0fffc3d)
- [📝 Zillow: Bigger, Faster, and More Engaging while on a Budget](https://www.zillow.com/tech/bigger-faster-more-engaging-budget)

## Community

- [Planet Perfromance Community](https://community.perfplanet.com)
- [Web Performance Slack](https://webperformance.slack.com)
- [Web Performance Working Group](https://www.w3.org/webperf)

### Books

- [📚 Hands-On JavaScript High Performance](https://www.amazon.com.br/Hands-JavaScript-High-Performance-WebAssembly-ebook/dp/B082T14XFZ)
- [📚 High Performance Browser Networking](https://hpbn.co)
- [📚 High Performance Images](https://www.oreilly.com/library/view/high-performance-images/9781491925799)
- [📚 High Performance Mobile Web](https://www.oreilly.com/library/view/high-performance-mobile/9781491912546)
- [📚 High Performance Responsive Design](https://www.oreilly.com/library/view/high-performance-responsive/9781491949979)
- [📚 HTTP/2 in Action](https://www.manning.com/books/http2-in-action)
- [📚 Image Optimization](https://www.smashingmagazine.com/printed-books/image-optimization)
- [📚 JPEG Series](https://www.amazon.com.br/JPEG-K-R-Rao/dp/8770225931)
- [📚 Modern Web Performance Optimization](https://www.amazon.com/Modern-Web-Performance-Optimization-Platforms/dp/1484265270)
- [📚 Performance Optimized React Applications](https://leanpub.com/performance-optimized-react-applications)
- [📚 Responsible JavaScript](https://abookapart.com/products/responsible-javascript)
- [📚 Time Is Money: The Business Value of Web Performance](https://www.amazon.com/Time-Money-Business-Value-Performance/dp/1491928743)
- [📚 Using WebPageTest](https://www.oreilly.com/library/view/using-webpagetest/9781491902783)
- [📚 Web Browser Engineering](https://browser.engineering)
- [📚 Web Performance in Action](https://www.manning.com/books/web-performance-in-action)

### Blogs

- [TK](https://www.iamtk.co)
- [Harry Roberts](https://csswizardry.com)
- [Alex Russell](https://infrequently.org)
- [Smashing Magazine - Performance](https://www.smashingmagazine.com/category/performance)
- [Fershad Irani](https://fershad.com/writing/all)
- [Modern DevTools](https://moderndevtools.com)
- [Eugenia Zigisova](https://imeugenia.medium.com)
- [Ivan Akulov](https://iamakulov.com)
- [Perf perf perf](https://3perf.com)
- [Barry Pollard](https://www.tunetheweb.com/blog)
- [Simon Hearne](https://simonhearne.com)
- [Medhat Dawoud](https://medhatdawoud.net)

### Conferences & Meetups

- [Conffab - Performance](https://conffab.com/topic/performance)
- [New York Web Performance Group](https://www.meetup.com/Web-Performance-NY)
- [Perf Now Conf](https://perfnow.nl)

### Courses

- [🇧🇷 Performance Web I: otimizando o front-end](https://www.alura.com.br/curso-online-otimizacao-performance-web)
- [🇧🇷 Performance Web II: Critical Path, HTTP/2 e Resource Hints](https://www.alura.com.br/curso-online-performance-http2-critical-path)
- [🇧🇷 React: otimizando a performance](https://www.alura.com.br/curso-online-react-otimizando-performance)
- [Browser Rendering Optimization](https://classroom.udacity.com/courses/ud860)
- [JavaScript and the DOM](https://classroom.udacity.com/courses/ud117)
- [Modern DevTools](https://moderndevtools.com)
- [Setting up DevTools for Performance Testing](https://csswizardry.gumroad.com/l/perfect-devtools)
- [The React Performance Masterclass](https://smashingconf.com/online-workshops/workshops/react-performance-ivan-akulov)
- [Web Performance Masterclass](https://smashingconf.com/online-workshops/workshops/web-performance-harry-roberts)
- [Website Performance Optimization](https://classroom.udacity.com/courses/ud884)
- [Website Performance Optimization](https://www.udacity.com/course/website-performance-optimization--ud884)

### Podcasts

- [Catching Up With Web Performance](https://catchingup.dev)
- [Chasing Waterfalls](https://chasing-waterfalls.simplecast.com)
- [Planet Performance Podcast](https://podcast.perfplanet.com)
- [PurePerformance](https://www.spreaker.com/show/pureperformance)
- [Smashing Podcast](https://podcast.smashingmagazine.com)

## Core Web Vitals

- [🎥 Ask Me Anything - Core Web Vitals](https://www.youtube.com/watch?v=HWm6WNkHs90&t=615s)
- [🎥 Deciphering INP and Core Web Vitals](https://www.youtube.com/watch?v=QdcKuo-N3kU&ab_channel=GoogleSearchCentral)
- [🎥 Exploring the future of Core Web Vitals](https://www.youtube.com/watch?v=iNfz9tg-wyg)
- [🎥 Insight into Core Web Vitals from the Chrome Platform Team](https://www.youtube.com/watch?v=CcHCbFhx2UM)
- [🎥 Lessons learned from performance monitoring in Chrome](https://www.youtube.com/watch?v=ctavZT87syI) ([Slides](https://www.slideshare.net/AnnieSullivan9/mnitoring-and-metrics-in-chrome-196438420))
- [🎥 Measuring Core Web Vitals](https://www.youtube.com/watch?v=9RpREJjoeRI)
- [🎥 Optimize for Core Web Vitals](https://www.youtube.com/watch?v=AQqFZ5t8uNc)
- [🎥 Optimize for Core Web Vitals](https://www.youtube.com/watch?v=AQqFZ5t8uNc&ab_channel=GoogleChromeDevelopers)
- [🎥 The business impact of Core Web Vitals](http://youtube.com/watch?v=nPmAE0YjGK0)
- [🎥 Website Performance and Core Web Vitals](https://www.youtube.com/watch?v=tDc77Y9HFoA&ab_channel=CreatorbyZmags)
- [🎥 What's new in Web Vitals](https://www.youtube.com/watch?v=XxvHY4wC8Co)
- [📝 A performance-focused workflow based on Google tools](https://web.dev/vitals-tools-workflow)
- [📝 An In-Depth Guide To Measuring Core Web Vitals](https://www.smashingmagazine.com/2021/04/complete-guide-measure-core-web-vitals)
- [📝 Analyzing Web Vitals with WebPageTest](https://calendar.perfplanet.com/2020/analyzing-web-vitals-with-webpagetest)
- [📝 Best practices for measuring Web Vitals in the field](https://web.dev/vitals-field-measurement-best-practices)
- [📝 Business impact of Core Web Vital optimizations](https://wpostats.com/tags/core%20web%20vitals)
- [📝 Cookie Banners and Web Vitals](https://blr.design/blog/cookie-banner-web-vitals)
- [📝 Core Web Vitals – The Final Countdown](https://www.netcentric.biz/insights/2021/05/core-web-vitals.html)
- [📝 Core Web Vitals Changelog](https://chromium.googlesource.com/chromium/src/+/refs/heads/main/docs/speed/metrics_changelog/README.md)
- [📝 Core Web Vitals is a Measurable Ranking Factor](https://www.sistrix.com/blog/core-web-vitals-is-a-measurable-ranking-factor)
- [📝 Core Web Vitals Optimizer (proven process & open-source tool)](https://github.com/fabkrum/core-web-vitals-optimizer/blob/main/README.md)
- [📝 Core Web Vitals Tracking via GA4, BigQuery and Google Data Studio](https://bigcommerce.websiteadvantage.com.au/core-web-vitals-ga4-bigquery-data-studio)
- [📝 CSS for Web Vitals](https://web.dev/css-web-vitals)
- [📝 CWV will become a desktop ranking factor in February 2022](https://developers.google.com/search/blog/2021/11/bringing-page-experience-to-desktop)
- [📝 Debug Web Vitals in the field](https://web.dev/debug-web-vitals-in-the-field)
- [📝 Defining the Core Web Vitals metrics thresholds](https://web.dev/defining-core-web-vitals-thresholds)
- [📝 Element Timing: One true metric to rule them all?](https://www.speedcurve.com/blog/element-timing-one-true-metric)
- [📝 Evaluating page experience for a better web](https://developers.google.com/search/blog/2020/05/evaluating-page-experience)
- [📝 Everything we know about Core Web Vitals and SEO](https://simonhearne.com/2021/core-web-vitals-seo)
- [📝 Everything we know about Core Web Vitals and SEO](https://simonhearne.com/2021/core-web-vitals-seo)
- [📝 Faster page loads using server think-time with Early Hints](https://developer.chrome.com/blog/early-hints)
- [📝 Feedback wanted: An experimental responsiveness metric](https://web.dev/responsiveness)
- [📝 Hands On with the new Responsiveness Metrics](https://calendar.perfplanet.com/2021/hands-on-with-the-new-responsiveness-metrics)
- [📝 Have Core Web Vitals made the web faster?](https://calendar.perfplanet.com/2021/have-core-web-vitals-made-the-web-faster)
- [📝 How SPA architectures affect Core Web Vitals](https://web.dev/vitals-spa-faq)
- [📝 How to create a competitive analysis dashboard for Core Web Vitals using Google Data Studio](https://www.deepcrawl.com/blog/best-practice/cmpetitive-analysis-core-web-vitals-google-data-studio)
- [📝 How to get your page Core Web Vitals from the CrUX API](https://github.com/fabkrum/web-performance-resources/blob/master/crux-page-data.md)
- [📝 How to Improve Core Web Vitals](https://simonhearne.com/2020/core-web-vitals)
- [📝 How to Improve Core Web Vitals](https://simonhearne.com/2020/core-web-vitals)
- [📝 How to measure CWVs on SPAs](https://estelafranco.com/blog/spa-cwv)
- [📝 HTTP Archive: CrUX Report](https://httparchive.org/reports/chrome-ux-report)
- [📝 Improving Core Web Vitals, A Smashing Magazine Case Study](https://www.smashingmagazine.com/2021/12/core-web-vitals-case-study-smashing-magazine)
- [📝 Lighthouse scores as predictors of page-level CrUX data](https://discuss.httparchive.org/t/lighthouse-scores-as-predictors-of-page-level-crux-data/2232)
- [📝 More time, tools, and details on the page experience update](https://developers.google.com/search/blog/2021/04/more-details-page-experience)
- [📝 More time, tools, and details on the page experience update](https://developers.google.com/search/blog/2021/04/more-details-page-experience)
- [📝 Optimising Core Web Vitals on SPAs](https://simonhearne.com/2022/core-web-vitals-on-spas)
- [📝 Optimizing Web Vitals using Lighthouse](https://web.dev/optimize-vitals-lighthouse)
- [📝 Our top Core Web Vitals recommendations for 2023](https://web.dev/top-cwv-2023)
- [📝 Send feedback to the Google Core Web Vitals Team](https://groups.google.com/g/web-vitals-feedback)
- [📝 Simulating real users in the lab to debug CLS issues](https://dev.to/rick_viscomi/simulating-real-users-in-the-lab-to-debug-cls-issues-3hnp)
- [📝 The do’s and don’ts of Core Web Vitals](https://contentsquare.com/blog/the-dos-and-donts-of-core-web-vitals-with-iprospect)
- [📝 The Science Behind Web Vitals](https://blog.chromium.org/2020/05/the-science-behind-web-vitals.html)
- [📝 Towards a better responsiveness metric](https://web.dev/better-responsiveness-metric)
- [📝 Towards an animation smoothness metric](https://web.dev/smoothness)
- [📝 Web Vitals - Essential metrics for a healthy site](https://web.dev/vitals)
- [📝 Web Vitals patterns](https://web.dev/patterns/web-vitals-patterns)
- [📝 Web Vitals patterns](https://web.dev/patterns/web-vitals-patterns)
- [📝 What goes into making a new Web Vital metric](https://calendar.perfplanet.com/2022/making-a-new-web-vital-metric)
- [📝 Why lab and field data can be different (and what to do about it)](https://web.dev/lab-and-field-data-differences)

### Cumulative Layout Shift (CLS)

- [🎥 Understanding Cumulative Layout Shift](https://www.youtube.com/watch?v=zIJuY-JCjqw)
- [📝 CLS at BuzzFeed — Part 1: Raising The Floor](https://tech.buzzfeed.com/improving-cumulative-layout-shift-at-buzzfeed-part-1-8b7ead2381dd)
- [📝 CLS at BuzzFeed — Part 2: Getting Help From Real Users](https://tech.buzzfeed.com/improving-cumulative-layout-shift-at-buzzfeed-part-2-2a846adeb097)
- [📝 CLS at BuzzFeed — Part 3: Dealing with the unpredictable](https://tech.buzzfeed.com/improving-cumulative-layout-shift-at-buzzfeed-part-2-2a846adeb097)
- [📝 Cumulative Layout Shift in Practice](https://nicj.net/cumulative-layout-shift-in-practice)
- [📝 Cumulative Layout Shift in Practice](https://nicj.net/cumulative-layout-shift-in-practice)
- [📝 Cumulative Layout Shift in the Real World](https://nicj.net/cumulative-layout-shift-in-the-real-world)
- [📝 Cumulative Layout Shift in the Real World](https://nicj.net/cumulative-layout-shift-in-the-real-world)
- [📝 Cumulative Layout Shift Study of Over 1 Million Websites](https://www.seoclarity.net/blog/core-web-vitals-study)
- [📝 Cumulative Layout Shift: Measure and Avoid Visual Instability](https://calibreapp.com/blog/cumulative-layout-shift)
- [📝 Debug layout shifts](https://web.dev/debug-layout-shifts)
- [📝 Debugging CLS](https://docs.google.com/document/d/1H-LiSW_oUzugtu_YLXAzxgJkiEcr4bU3qpw84zFUsCQ/edit?resourcekey=0-pKSNORFdLG9lgpOKwSwXFA#heading=h.b9ipz2aa3niy)
- [📝 Diving Into the New Cumulative Layout Shift](https://blog.webpagetest.org/posts/understanding-the-new-cumulative-layout-shift)
- [📝 Evolving the CLS metric](https://web.dev/evolving-cls)
- [📝 How I removed website layout shift using a predeploy script](https://levelup.gitconnected.com/improving-cumulative-layout-shift-on-pre-deploy-stage-1636fb1386cc)
- [📝 How To Fix Cumulative Layout Shift (CLS) Issues](https://www.smashingmagazine.com/2021/06/how-to-fix-cumulative-layout-shift-issues)
- [📝 How To Fix Cumulative Layout Shift (CLS) Issues](https://www.smashingmagazine.com/2021/06/how-to-fix-cumulative-layout-shift-issues)
- [📝 Improving Cumulative Layout Shift at Telegraph Media Group](https://web.dev/telegraph)
- [📝 Measuring Cumulative Layout Shift](https://requestmetrics.com/web-performance/cumulative-layout-shift)
- [📝 Prevent unwanted Layout Shifts caused by Scrollbars with the scrollbar-gutter CSS property](https://www.bram.us/2021/07/23/pevent-unwanted-layout-shifts-caused-by-scrollbars-with-the-scrollbar-gutter-css-property)
- [📝 The Almost-Complete Guide to Cumulative Layout Shift](https://jessbpeck.com/posts/completecls)

### Largest Contentful Paint (LCP)

- [🎥 How to Fix Largest Contentful Paint](https://www.youtube.com/watch?v=3LVI8-4FrTg&ab_channel=NitroPack)
- [🎥 How to improve Largest Contentful Paint for a better page experience](https://www.youtube.com/watch?v=480m72yjZv8)
- [🎥 Investigating LCP: Largest Contentful Paint](https://www.youtube.com/watch?v=diAc65p15ag)
- [🎥 This Is Your LCP On Images](https://www.youtube.com/watch?v=YMqnPeZHcuc)
- [📝 Case Study Vodafone: A 31% improvement in LCP increased sales by 8%](https://web.dev/vodafone)
- [📝 Dynamic LCP Priority: Learning from Past Visits](https://philipwalton.com/articles/dynamic-lcp-priority)
- [📝 How to optimize largest contentful paint (LCP) on client side](https://evanxmerz.com/post/how-to-optimize-largest-contentful-paint-lcp-on-client-side)
- [📝 Improve Largest Contentful Paint (LCP) by removing image transitions](https://performance.shopify.com/blogs/blog/improve-largest-contentful-paint-lcp-by-removing-image-transitions)
- [📝 LCP(FE)](https://calendar.perfplanet.com/2022/lcpfe)
- [📝 Measuring Largest Contentful Paint](https://requestmetrics.com/web-performance/largest-contentful-paint)
- [📝 Optimising Largest Contentful Paint](https://csswizardry.com/2022/03/optimising-largest-contentful-paint)
- [📝 Optimize Largest Contentful Paint](https://web.dev/optimize-lcp)
- [📝 Optimizing resource loading with the Fetch Priority API](https://web.dev/fetch-priority)
- [📝 Priority Hints and optimizing LCP](https://imkev.dev/fetchpriority-opportunity)
- [📝 Tip - Use fetchpriority=high to load your LCP hero image sooner](https://addyosmani.com/blog/fetch-priority)
- [📝 Understanding How Browsers Identify the LCP Element](https://murshidmuzamil.com/blog/understanding-lcp-browsers)
- [📝 What can the HTTP Archive tell us about Largest Contentful Paint?](https://paulcalvano.com/2021-06-07-lcp-httparchive)

### First Input Delay (FID)

- [📝 First Input Delay (FID)](https://web.dev/fid)
- [📝 Idle Until Urgent](https://philipwalton.com/articles/idle-until-urgent)
- [📝 Improving responsiveness in text inputs](https://nolanlawson.com/2021/08/08/improving-responsiveness-in-text-inputs)

### Interaction to Next Paint (INP)

- [🎥 Breaking Down Long Tasks](https://www.youtube.com/watch?v=2djPW7us9VI&ab_channel=WebConferencesAmsterdam)
- [🎥 Debugging INP](https://www.youtube.com/watch?v=nQByr5Yyclw&ab_channel=HHWebPerformanceMeetup)
- [🎥 Digging into Interaction to Next Paint](https://www.youtube.com/watch?v=bDJB-AQDciE)
- [🎥 Digging into Interaction to Next Paint](https://www.youtube.com/watch?v=bDJB-AQDciE&ab_channel=NYWebPerformanceMeetup)
- [🎥 How to Improve Interaction to Next Paint (INP)](https://www.youtube.com/watch?v=XpSUlncKExc&ab_channel=NitroPack)
- [🎥 How to optimize web responsiveness with Interaction to Next Paint](https://www.youtube.com/watch?v=KZ1kxzsJZ5g&ab_channel=GoogleChromeDevelopers)
- [🎥 Interaction to Next Paint and other Web Vitals [BlinkOn 16]](https://www.youtube.com/watch?v=zQBt64Q-Ijs&ab_channel=BlinkOn)
- [🎥 Interaction to Next Paint Revealed: 5 Truths That Will Speed Up Your Site](https://www.youtube.com/watch?v=VpjnUJ9A0HU)
- [🎥 Interaction to Next Paint](https://www.youtube.com/watch?v=JXaIFLhRV8Q&ab_channel=CodeSpaceITeducation)
- [🎥 New field insights for debugging INP](https://www.youtube.com/watch?v=xfjumh8ySRY&ab_channel=ChromeforDevelopers)
- [🎥 Optimizing INP: A deep dive](https://www.youtube.com/watch?v=cmtfM4emG5k&ab_channel=ChromeforDevelopers)
- [🎥 The state of responsiveness on the web](https://www.youtube.com/watch?v=Mizzbsvv8Os&ab_channel=GoogleChromeDevelopers)
- [🎥 Understanding and Optimizing Interaction to Next Paint (INP)](https://www.youtube.com/watch?v=BoaORHnJYAE)
- [📝 7 Ways to Minimize Main Thread Work](https://nitropack.io/blog/post/minimize-main-thread-work)
- [📝 Analysis of INP performance using real-world RUMvision data](https://calendar.perfplanet.com/2023/inp-performance-analysis-rumvision-data)
- [📝 Avoid large, complex layouts and layout thrashing](https://web.dev/articles/avoid-large-complex-layouts-and-layout-thrashing)
- [📝 Breaking up long tasks](https://calendar.perfplanet.com/2022/breaking-up-long-tasks)
- [📝 Client-side rendering of HTML and interactivity](https://web.dev/articles/client-side-rendering-of-html-and-interactivity)
- [📝 Debugging Interaction to Next Paint (INP)](https://www.speedcurve.com/blog/debugging-interaction-to-next-paint-inp)
- [📝 Demystifying INP: New tools and actionable insights](https://vercel.com/blog/demystifying-inp-new-tools-and-actionable-insights)
- [📝 Find slow interactions in the field](https://web.dev/articles/find-slow-interactions-in-the-field)
- [📝 Google Chrome web-vitals.js v4 to support LoAF + INP breakdown](https://www.rumvision.com/blog/google-web-vitals-v4-supports-loaf-inp-breakdown)
- [📝 How do modern frameworks perform on the new INP metric](https://developer.chrome.com/articles/inp-in-frameworks)
- [📝 How large DOM sizes affect interactivity, and what you can do about it](https://web.dev/articles/dom-size-and-interactivity)
- [📝 How To Improve INP: Yield Patterns](https://kurtextrem.de/posts/improve-inp)
- [📝 How to Improve Interaction to Next Paint (INP)](https://nitropack.io/blog/post/improve-interaction-to-next-paint-inp)
- [📝 How to solve Interaction to Next Paint (INP) issues](https://www.iron-out.io/blog/how-to-solve-interaction-to-next-paint-issues)
- [📝 Improving INP with React 18 and Suspense](https://vercel.com/blog/improving-interaction-to-next-paint-with-react-18-and-suspense)
- [📝 Interaction to Next Paint (INP)](https://web.dev/articles/inp)
- [📝 Interaction to Next Paint by kev](https://imkev.dev/inp)
- [📝 Manually diagnose slow interactions in the lab](https://web.dev/articles/manually-diagnose-slow-interactions-in-the-lab)
- [📝 Measure And Optimize Interaction to Next Paint (INP)](https://www.debugbear.com/docs/metrics/interaction-to-next-paint)
- [📝 Mobile INP performance: The elephant in the room](https://www.speedcurve.com/blog/core-web-vitals-inp-mobile)
- [📝 Optimize Interaction to Next Paint](https://web.dev/optimize-inp)
- [📝 Optimize long tasks](https://web.dev/articles/optimize-long-tasks)
- [📝 Preparing For Interaction To Next Paint, A New Web Core Vital](https://www.smashingmagazine.com/2023/12/preparing-interaction-next-paint-web-core-vital)
- [📝 Reduce the scope and complexity of style calculations ](https://web.dev/articles/reduce-the-scope-and-complexity-of-style-calculations)
- [📝 Reduce the scope and complexity of style calculations](https://web.dev/articles/reduce-the-scope-and-complexity-of-style-calculations)
- [📝 Script evaluation and long tasks](https://web.dev/articles/script-evaluation-and-long-tasks)
- [📝 Sluggish CATs: Category Pages Have the Worst Responsiveness (INP) on e-Commerce Sites](https://calendar.perfplanet.com/2023/sluggish-category-pages-worst-inp-ecommerce)
- [📝 Style Recalculation Secrets They Don't Want You To Know](https://www.youtube.com/watch?v=WRiOWJZoKlw)
- [📝 The Fight For The Main Thread](https://www.smashingmagazine.com/2023/10/speedcurve-fight-main-thread)
- [📝 Use web workers to run JavaScript off the browser's main thread](https://web.dev/articles/off-main-thread)
- [📝 Web Performance Experts Guide to Mastering Interaction to Next Paint](https://www.rumvision.com/blog/experts-guide-to-mastering-interaction-to-next-paint)

### Total Blocking Time

- [📝 Total Blocking Time: A Short and Sweet Guide for Happier Users](https://calibreapp.com/blog/total-blocking-time)

## CSS

- [📝 Airbnb’s Trip to Linaria](https://medium.com/airbnb-engineering/airbnbs-trip-to-linaria-dc169230bd12)
- [📝 Benchmarking the performance of CSS @property](https://web.dev/blog/at-property-performance)
- [📝 CSS-in-JS to Tailwind: 36% better web vitals](https://sophiabits.com/blog/css-in-js-to-tailwind-better-web-vitals)
- [📝 Future of runtime CSS-in-JS](https://github.com/emotion-js/emotion/discussions/2827)
- [📝 Inlining critical CSS](https://imkev.dev/inlining-critical-css)
- [📝 Loading CSS - Performance Cheatsheet](https://imkev.dev/loading-css)
- [📝 Performance comparison of css-in-js libraries](https://github.com/geeky-biz/css-in-js-benchmark)
- [📝 PurgeCSS](https://purgecss.com)
- [📝 Real-world CSS vs. CSS-in-JS performance comparison](https://pustelto.com/blog/css-vs-css-in-js-perf)
- [📝 Reduce bundle size via one-letter css classname hash strategy](https://dev.to/denisx/reduce-bundle-size-via-one-letter-css-classname-hash-strategy-10g6)
- [📝 Style performance and concurrent rendering](https://nolanlawson.com/2022/10/22/style-performance-and-concurrent-rendering)
- [📝 The truth about CSS selector performance](https://blogs.windows.com/msedgedev/2023/01/17/the-truth-about-css-selector-performance)
- [📝 Why We're Breaking Up with CSS-in-JS](https://dev.to/srmagura/why-were-breaking-up-wiht-css-in-js-4g9b)

## Fonts

- [Can I use woff2](https://caniuse.com/woff2)

### Fonts Tools

- [🛠 Font Squirrel](https://www.fontsquirrel.com/tools/webfont-generator)
- [🛠 glyphhanger](https://github.com/zachleat/glyphhanger)
- [🛠 Google Fonts](https://fonts.google.com)
- [🛠 Variable Fonts](https://v-fonts.com)

## General

- [🎥 Common Mistakes That Degrade Frontend Performance](https://www.youtube.com/watch?v=uVrp_A7rj_I)
- [🎥 Deep dive into third-party performance](https://www.youtube.com/watch?v=uXv9JFvrnwo)
- [🎥 Demystifying Speed Tooling](https://www.youtube.com/watch?v=mLjxXPHuIJo)
- [🎥 Fantastic Frontend Performance Tricks & Why We Do Them](https://www.youtube.com/watch?v=pSCHN4oU2JQ&ab_channel=estellevw)
- [🎥 From fast loading to instant loading](https://www.youtube.com/watch?v=bSua9vMdrNM&ab_channel=ChromeforDevelopers)
- [🎥 Improving Page Performance in Modern Web Apps](https://vimeo.com/254858694)
- [🎥 Improving Page Performance in Modern Web Apps](https://www.youtube.com/watch?v=p_8oR9GFRvQ)
- [🎥 Inclusive Design is Fast by Default](https://www.youtube.com/watch?v=MiXy2x6flww)
- [🎥 Next-Level Web Performance](https://www.youtube.com/watch?v=61qRReXTqO8&ab_channel=TopEndDevs)
- [🎥 Speed Essentials: Key Techniques for Fast Websites](https://www.youtube.com/watch?v=reztLS3vomE)
- [🎥 State of Web Performance August 2022](https://www.youtube.com/watch?v=DlG41ik4jKU&ab_channel=ThisDotMedia)
- [🎥 The Bright Future of Web Performance](https://www.youtube.com/watch?v=Jz3Fu1o356g&ab_channel=WebConferencesAmsterdam)
- [🎥 The Path to Performance](https://www.youtube.com/watch?v=23Fp9V7w_8U&ab_channel=KatieKovalcin)
- [🎥 The Psychology of Speed](https://www.youtube.com/watch?v=7i_yQyHdxUo)
- [🎥 The Unbearable Weight of Massive JavaScript](https://www.youtube.com/watch?v=f5felHJiACE&ab_channel=WebConferencesAmsterdam)
- [🎥 Top 10 performance pitfalls](https://www.youtube.com/watch?v=Lh9q3h2khlc)
- [🎥 Web performance optimisations for the harsh conditions](https://www.youtube.com/watch?v=4LN78IeB-bY&ab_channel=WeyWeyWeb)
- [🎥 WebBundles – JS Delivery Without the Tradeoffs](https://www.youtube.com/watch?v=ziL_E7WcKLE&ab_channel=LondonWebPerformanceGroup)
- [🎥 When JavaScript Bytes](https://www.youtube.com/watch?v=GvUGN0AIfDE)
- [🎥 When JavaScript Bytes](https://www.youtube.com/watch?v=JvJ0v5OohNg)
- [🎥 Why performance is hard at scale](https://www.youtube.com/watch?v=_r62DZGyzU4&ab_channel=Builder)
- [📝 3Perf Guides](https://3perf.com/content)
- [📝 5 Common Mistakes Teams Make When Tracking Performance](https://calibreapp.com/blog/common-mistakes-in-tracking-speed)
- [📝 A Management Maturity Model for Performance](https://infrequently.org/2022/05/performance-management-maturity)
- [📝 A Performance Maturity Matrix](https://calendar.perfplanet.com/2022/a-performance-maturity-matrix)
- [📝 A Unified Theory of Web Performance](https://calendar.perfplanet.com/2021/a-unified-theory-of-web-performance)
- [📝 An HTML-first Mental Model](https://calendar.perfplanet.com/2022/an-html-first-mental-model)
- [📝 Are your JavaScript long tasks frustrating users?](https://www.speedcurve.com/blog/javascript-long-tasks)
- [📝 Best practices for tags and tag managers](https://web.dev/tag-best-practices)
- [📝 Building the DOM faster: speculative parsing, async, defer and preload](https://hacks.mozilla.org/2017/09/building-the-dom-faster-speculative-parsing-async-defer-and-preload)
- [📝 Building the DOM faster](https://hacks.mozilla.org/2017/09/building-the-dom-faster-speculative-parsing-async-defer-and-preload)
- [📝 Chrome’s Paint Flashing Tool](https://engineering.entelo.com/chromes-paint-flashing-tool-b5c880849635)
- [📝 Definitions of web terminology](https://kaleidawave.github.io/posts/web-terminology)
- [📝 experiences. Web. frameworks. future. me.](https://igor.dev/posts/experiences-web-frameworks-future-me)
- [📝 Fast load times](https://web.dev/fast)
- [📝 Fast load times](https://web.dev/fast)
- [📝 Fixing Performance Regressions Before they Happen](https://netflixtechblog.com/fixing-performance-regressions-before-they-happen-eab2602b86fe)
- [📝 Flame Graphs](https://www.brendangregg.com/flamegraphs.html)
- [📝 From Development to Real Users: How to Create a Web Performance Story](https://engineering.atspotify.com/2022/09/from-development-to-real-users-how-to-create-a-web-performance-story)
- [📝 Front-End Performance Checklist 2021](https://www.smashingmagazine.com/2021/01/front-end-performance-2021-free-pdf-checklist)
- [📝 Gantry: Slack’s Fast-booting Frontend Framework](https://slack.engineering/gantry-slacks-fast-booting-frontend-framework)
- [📝 Getting Started with Web Performance](https://calibreapp.com/blog/get-started-with-performance)
- [📝 How to Eliminate Render-Blocking Resources: a Deep Dive](https://sia.codes/posts/render-blocking-resources)
- [📝 Improving React Runtime Performance](https://medium.com/quintoandar-tech-blog/improving-react-runtime-performance-dec0a5a4ffda)
- [📝 Javascript Performance in Extreme Environments](https://www.youtube.com/watch?v=Mk-t189JSe0)
- [📝 Learn Performance](https://web.dev/learn/performance)
- [📝 Learning Web Performance](https://tannerhodges.com/blog/learning-web-performance)
- [📝 Loading Performance Overview](https://developers.google.com/web/fundamentals/performance/get-started)
- [📝 Low-Hanging Web Performance Fruits: A Cheat Sheet](https://betterprogramming.pub/low-hanging-web-performance-fruits-a-cheat-sheet-3aa1d338b6c1)
- [📝 Maybe you don't need Rust and WASM to speed up your JS](https://mrale.ph/blog/2018/02/03/maybe-you-dont-need-rust-to-speed-up-your-js.html)
- [📝 Monitoring Your Core Web Vital (Performance) Metrics](https://requestmetrics.com/web-performance/monitoring-core-web-vital)
- [📝 My Challenge to the Web Performance Community](https://philipwalton.com/articles/my-challenge-to-the-web-performance-community)
- [📝 Optimize SPA bundle size to speed up application loading](https://medium.com/miro-engineering/optimize-spa-bundle-size-to-speed-up-application-loading-c988cef57257)
- [📝 Optimizing third-party script loading in Next.js](https://web.dev/script-component)
- [📝 Performance and the Big Picture](https://tannerhodges.com/blog/performance-and-the-big-picture)
- [📝 Performant front-end architecture](https://www.debugbear.com/blog/performant-front-end-architecture)
- [📝 Small Bundles, Fast Pages: What To Do With Too Much JavaScript](https://calibreapp.com/blog/bundle-size-optimization)
- [📝 Task Attribution Semantics](https://blog.yoav.ws/posts/task_attribution_semantics)
- [📝 Techniques for Optimizing Web Performance](https://performance.shopify.com/pages/techniques-for-optimizing-web-performance)
- [📝 The Impact of Web Performance](https://simplified.dev/performance/impact-of-web-performance)
- [📝 The ultimate guide to modern web application performance](https://levelup.gitconnected.com/the-ultimate-guide-to-modern-web-application-performance-ec4eec9939)
- [📝 The Ultimate Guide to Optimizing JavaScript for Quick Page Loads](https://www.builder.io/blog/the-ultimate-guide-to-optimizing-javascript-for-quick-page-loads)
- [📝 The why of website optimisation: Better search ranking](https://fershad.com/writing/website-optimisation-improve-search-ranking)
- [📝 The why of website optimisation: Better user experience](https://fershad.com/writing/website-optimisation-better-user-experience)
- [📝 The why of website optimisation: Help the planet](https://fershad.com/writing/website-optimisation-reduce-environmental-impact)
- [📝 The why of website optimisation: Increase site conversions](https://fershad.com/writing/website-optimisation-increase-conversions-engagement)
- [📝 The why of website optimisation: Reduce operational costs](https://fershad.com/writing/website-optimisation-reduce-operational-costs)
- [📝 Top 5 Performance Recommendations](https://www.tunetheweb.com/performance)
- [📝 Web Perf 101](https://3perf.com/talks/web-perf-101)
- [📝 Web Performance: Trends and Insights from 4 Top Performance Experts](https://cloudinary.com/products/media_optimizer/web-performance-guide)
- [📝 Why Performance Matters?](https://medhatdawoud.net/blog/why-performance-matters)
- [📝 Why Your Cached JavaScript Is Still Slow and Incurs Performance Overhead](https://www.webperf.tips/tip/cached-js-misconceptions)

### Why it matters

- [📝 How to measure the energy consumption of your frontend application](https://greensoftware.foundation/articles/how-to-measure-the-energy-consumption-of-your-frontend-application)
- [📝 Relating site speed and business metrics](https://web.dev/site-speed-and-business-metrics)
- [📝 What Is Site-Speed and Why Should I Care?](https://csswizardry.com/downloads/csswizardry.com-site-speed.pdf)
- [📝 Why Web Performance](https://iamtk.co/why-web-performance)

## Images

- [:octocat: Repository to collect best practices for web images](https://github.com/nucliweb/image-element)
- [🎥 A WebP Update](https://www.youtube.com/watch?v=f_Qkd1LC0do)
- [🎥 Faster loading times with AVIF images | Workshop](https://www.youtube.com/watch?v=9E3Vp-LXfag)
- [🎥 Image compression deep-dive](https://www.youtube.com/watch?v=F1kYBnY6mwg)
- [🎥 Image Optimization | performance.now() 2018](https://www.youtube.com/watch?v=jTXhYj2aCDU)
- [🎥 Images blast off at the speed of Jamstack](https://www.youtube.com/watch?v=pGZoFwmLBVc&ab_channel=WeyWeyWeb)
- [🎥 JPEG 'files' & Colour (JPEG Pt1)](https://www.youtube.com/watch?v=n_uNPbdenRs)
- [🎥 JPEG DCT, Discrete Cosine Transform (JPEG Pt2)](https://www.youtube.com/watch?v=Q2aEzeMDHMA)
- [🎥 JPEG XL: An Update](https://www.youtube.com/watch?v=YsbsKimR-Fw)
- [🎥 Picture Perfect](https://www.youtube.com/watch?v=w6TiSuQkqvY)
- [🎥 Responsive Images for the Web](https://www.youtube.com/watch?v=XecoxR1ckbc&ab_channel=estellevw)
- [🎥 The AVIF Image Format](https://www.youtube.com/watch?v=VHm5Ql33JYw)
- [🎥 WebP, AVIF & More: Image Adoption Stats](https://www.youtube.com/watch?v=tz5bpAQY43k)
- [📝 Can I use AVIF](https://caniuse.com/avif)
- [📝 Can I use JPEG-XL](https://caniuse.com/jpegxl)
- [📝 Can I use WebP](https://caniuse.com/webp)
- [📝 Picture perfect images with the modern `<img>` element](https://stackoverflow.blog/2022/03/28/picture-perfect-images-with-the-modern-element)
- [📝 Reduce Image Sizes by Removing Metadata](https://calendar.perfplanet.com/2022/reduce-image-sizes-by-removing-metadata)
- [📝 Responsive Images Done Right: A Guide To <picture> And srcset](https://www.smashingmagazine.com/2014/05/responsive-images-done-right-guide-picture-srcset)
- [📝 The Ultimate Guide to Image Optimisation](https://calibreapp.com/blog/image-optimisation-guide)
- [📝 What does the image decoding attribute actually do?](https://www.tunetheweb.com/blog/what-does-the-image-decoding-attribute-actually-do)

### Images Tools

- [🛠 Cloudinary](https://cloudinary.com)
- [🛠 Compress-Or-Die](https://compress-or-die.com)
- [🛠 ImageOptim](https://imageoptim.com)
- [🛠 Optimage](https://optimage.app)
- [🛠 squoosh](https://squoosh.app)
- [🛠 WebPonize](https://webponize.org)

## Infrastructure

- [🎥 Mobile Performance from the Radio Up: 4G Architecture and its Implications](https://www.youtube.com/watch?v=a4SbDZ9Y-I4&ab_channel=IlyaGrigorik)
- [📝 Cloud Computing without Containers](https://blog.cloudflare.com/cloud-computing-without-containers)
- [📝 Content delivery networks (CDNs)](https://web.dev/content-delivery-networks)

## JavaScript

- [🎥 Multicore JavaScript: Past, Present and Future](https://www.youtube.com/watch?v=FNGFlnUteBU&ab_channel=CITYJSCONFERENCE)
- [📝 13 Tips to Write Faster, Better-Optimized JavaScript](https://medium.com/@bretcameron/13-tips-to-write-faster-better-optimized-javascript-dc1f9ab063d8)
- [📝 17 Javascript optimization tips to know in 2021](https://dev.to/blessingartcreator/17-javascript-optimization-tips-3gil)
- [📝 How JavaScript works: an overview of the engine, the runtime, and the call stack](https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf)
- [📝 How JavaScript works: Event loop and the rise of Async programming + 5 ways to better coding with async/await](https://blog.sessionstack.com/how-javascript-works-event-loop-and-the-rise-of-async-programming-5-ways-to-better-coding-with-2f077c4438b5)
- [📝 How JavaScript works: inside the V8 engine + 5 tips on how to write optimized code](https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e)
- [📝 How JavaScript works: memory management + how to handle 4 common memory leaks](https://blog.sessionstack.com/how-javascript-works-memory-management-how-to-handle-4-common-memory-leaks-3f28b94cfbec)
- [📝 JavaScript Compiler Optimization Techniques— only for Experts](https://codeburst.io/javascript-compiler-optimization-techniques-only-for-experts-58d6f5f958ca)

## Measuring Performance

- [🎥 Analyze and Improve web performance using devtools & webpagetest](https://www.youtube.com/watch?v=QLenZnWMjLw&ab_channel=NYWebPerformanceMeetup)
- [🎥 Crafting Performance Alerting Tools](https://www.youtube.com/watch?v=7CaEESxbu2s&ab_channel=EtsyEng)
- [🎥 From Milliseconds to Millions: The Numbers Driving Web Perf](https://www.youtube.com/watch?v=cXLOIIJ1UaE)
- [🎥 How to make sense of real user performance metrics (RUM)](https://www.youtube.com/watch?v=95fTqkcna4g)
- [🎥 How’s the UX on the Web, Really?](https://vimeo.com/254834890)
- [🎥 Let’s Turn Real User Data Analysis into a Science](https://www.youtube.com/watch?v=3xWAqTIhDQ0&ab_channel=NYWebPerformanceMeetup)
- [🎥 Measuring Performance with SpeedCurve & WPT](https://www.youtube.com/watch?v=hr9E1D7gRHs&ab_channel=KevinFarrugia)
- [🎥 Measuring Real User Performance in the Browser](https://www.youtube.com/watch?v=yrWLi524YLM)
- [🎥 Observability for Web Perf](https://www.youtube.com/watch?v=DMM4kTA5nAc)
- [🎥 One Number, Multiple Metrics](https://www.youtube.com/watch?v=e215_uiU3LQ)
- [🎥 Profiling performance with Harry Roberts](https://www.youtube.com/watch?v=dfCdKJC9RLQ)
- [🎥 Web Performance Auditing](https://www.youtube.com/watch?v=Nl2Q9JAdha8)
- [📝 A step by step guide to monitoring the competition with the Chrome UX Report](https://dev.to/chromiumdev/a-step-by-step-guide-to-monitoring-the-competition-with-the-chrome-ux-report-4k1o)
- [📝 An Introduction to the RUM Archive](https://calendar.perfplanet.com/2022/an-introduction-to-the-rum-archive)
- [📝 Analyze runtime performance](https://developer.chrome.com/docs/devtools/evaluate-performance)
- [📝 Benchmarking, Profiling, and Optimizing JavaScript libraries](https://calendar.perfplanet.com/2023/benchmarking-profiling-and-optimizing-javascript-libraries)
- [📝 Complete guide to understand and measure the performance of your website](https://bejamas.io/blog/guide-to-web-performance)
- [📝 Core Web Vitals Dashboard On Google Analytics](https://calendar.perfplanet.com/2021/core-web-vitals-dashboard-on-google-analytics)
- [📝 Creating Airbnb’s Page Performance Score](https://medium.com/airbnb-engineering/creating-airbnbs-page-performance-score-5f664be0936)
- [📝 Get Fast, Stay Fast: How To Monitor React Render Performance](https://3perf.com/blog/react-monitoring)
- [📝 How Fast Should Your Site Load?](https://medium.com/firebase-developers/how-fast-should-your-site-load-cfb14be48e8b)
- [📝 How to read a WebPageTest Connection View chart](https://nooshu.com/blog/2019/12/30/how-to-read-a-wpt-connection-view-chart)
- [📝 How to read a WebPageTest Waterfall View chart](https://nooshu.com/blog/2019/10/02/how-to-read-a-wpt-waterfall-chart)
- [📝 How To Use Google CrUX To Analyze And Compare The Performance Of JS Frameworks](https://www.smashingmagazine.com/2022/05/google-crux-analysis-comparison-performance-javascript-frameworks)
- [📝 Identifying, Auditing, and Discussing Third Parties](https://csswizardry.com/2018/05/identifying-auditing-discussing-third-parties)
- [📝 Introducing RAIL: A User-Centric Model For Performance](https://www.smashingmagazine.com/2015/10/rail-user-centric-model-performance)
- [📝 Make sense of flame charts in Performance Tab by example](https://calendar.perfplanet.com/2022/make-sense-of-flame-charts-in-performance-tab-by-example)
- [📝 Measure What You Impact, Not What You Influence](https://csswizardry.com/2022/08/measure-what-you-impact-not-what-you-influence)
- [📝 Measuring the performance of Wikipedia visitors’ devices](https://techblog.wikimedia.org/2020/05/07/measuring-the-performance-of-wikipedia-visitors-devices)
- [📝 Measuring web performance, How fast is fast?](https://medhatdawoud.net/blog/measuring-web-performance)
- [📝 My Performance Audit Workflow](https://aerotwist.com/blog/my-performance-audit-workflow)
- [📝 Noise Canceling RUM](https://calendar.perfplanet.com/2022/noise-canceling-rum)
- [📝 React Performance Profiling Optimization](https://calibreapp.com/blog/react-performance-profiling-optimization)
- [📝 Response Times: The 3 Important Limits](https://www.nngroup.com/articles/response-times-3-important-limits)
- [📝 Show me the money: Justifying performance improvements using Google Analytics](https://dev.to/thegreengreek/show-me-the-money-justifying-performance-improvements-using-google-analytics-3231)
- [📝 Start performance tests your browser's address bar](https://fershad.com/writing/start-performance-tests-your-browsers-address-bar)
- [📝 Stress testing site performance](https://fershad.com/writing/stress-testing-site-performance)
- [📝 Testing a web page with PageSpeed Insights](https://fershad.com/writing/testing-a-web-page-with-pagespeed-insights)
- [📝 Testing Slow Third-Parties with Puppeteer](https://screenspan.net/blog/puppeteer-spof)
- [📝 The RUM Archive and Benford’s Law](https://calendar.perfplanet.com/2022/the-rum-archive-and-benfords-law)
- [📝 The Web Performance Engineer’s Swiss Army Knife](https://calendar.perfplanet.com/2022/the-web-performance-engineers-swiss-army-knife)
- [📝 Tracking CPU with Long Tasks API](https://calendar.perfplanet.com/2017/tracking-cpu-with-long-tasks-api)
- [📝 Tracking real Core Web Vitals scores](https://fershad.com/writing/tracking-real-core-web-vitals-scores)
- [📝 Visualize your resources with a free treemap tool](https://calendar.perfplanet.com/2022/visualize-your-resources-with-a-free-treemap-tool)
- [📝 Web Performance Calendar meets RUM](https://calendar.perfplanet.com/2022/web-performance-calendar-meets-rum)
- [📝 Why is CrUX data different from my RUM data?](https://web.dev/crux-and-rum-differences)
- [📝 Wikipedia’s Worldwide Web: CPU benchmark](https://calendar.perfplanet.com/2023/wikipedias-worldwide-web-cpu-benchmark)

### Runtime Performance

- [🎥 Performance Testing using Playwright](https://www.youtube.com/watch?v=IrK-XDH72bw&ab_channel=NYWebPerformanceMeetup)
- [🛠 A collection of performance tools](https://github.com/unlikelyzero/js-perf-toolkit)

### DevTools

- [🎥 Chrome DevTools: Performance Tab](https://www.youtube.com/watch?v=LGT4Qe7v0So)
- [🎥 Exploring the Frontend Performance of the National Rail Website with Chrome DevTools](https://www.youtube.com/watch?v=WRwxOonOYK0&ab_channel=UmarHansa)
- [🎥 Improving page performance with Chrome DevTools](https://www.youtube.com/watch?v=yRrrL0Mg1pM&ab_channel=UmarHansa)
- [🎥 Making images lazy load with Chrome DevTools](https://www.youtube.com/watch?v=D_M7LvDvlSg&ab_channel=UmarHansa)
- [🎥 Memory Management Masterclass](https://www.youtube.com/watch?v=LaxbdIyBkL0&ab_channel=GoogleDevelopers)
- [🎥 Running a performance profile on the YouTube search box](https://www.youtube.com/watch?v=E4KAWf_fKbM&ab_channel=UmarHansa)
- [🎥 Understanding Paint Performance with Chrome DevTools](https://www.youtube.com/watch?v=8-pkB2vGUKk&ab_channel=UmarHansa)
- [📝 Comprehensive guide to JavaScript performance analysis using Chrome DevTools](https://blog.jiayihu.net/comprenhensive-guide-chrome-performance/)
- [📝 CPU Flame Graphs](https://www.brendangregg.com/FlameGraphs/cpuflamegraphs.html)
- [📝 Network Throttling in Chrome DevTools](https://www.debugbear.com/blog/chrome-devtools-network-throttling)

### How to metric

- [📝 Faster data visualizations](https://calendar.perfplanet.com/2022/faster-data-visualizations)
- [📝 How to metric](https://medium.com/@djsmith42/how-to-metric-edafaf959fc7)
- [📝 How to read a RUM histogram](https://support.speedcurve.com/docs/how-to-read-a-histogram)
- [📝 Synthetic vs. real user monitoring](https://support.speedcurve.com/docs/synthetic-vs-real-user-monitoring-rum)
- [📝 What is Real User Monitoring? RUM explained](https://raygun.com/learn/what-is-real-user-monitoring)

### Benchmark

- [🛠 Adventures in Microbenchmarking](https://tomdale.net/2017/07/adventures-in-microbenchmarking)
- [🛠 react-benchmark](https://github.com/Rowno/react-benchmark)
- [🛠 Tachometer](https://github.com/Polymer/tachometer)
- [🛠 tinybench](https://github.com/tinylibs/tinybench)

### Measure Tools

- [📝 Web Performance Recipes With Puppeteer](https://addyosmani.com/blog/puppeteer-recipes)
- [🛠 boomerang](https://github.com/akamai/boomerang)
- [🛠 perfsee: a set of tool for measuring and debugging performance of frontend applications](https://github.com/perfsee/perfsee)
- [🛠 speedscope](https://github.com/jlfwong/speedscope)
- [🛠 Treo](https://treo.sh)

### Memory Management

- [📝 A crash course in memory management](https://hacks.mozilla.org/2017/06/a-crash-course-in-memory-management)
- [📝 Experiments with the JavaScript Garbage Collector](https://dev.to/codux/experiments-with-the-javascript-garbage-collector-2ae3)

## Performance Budget

- [🎥 Core Web Vitals - Measure what matters](https://www.youtube.com/watch?v=wGT9s6NW6hg&ab_channel=GoogleChromeDevelopers)
- [🎥 The Cost Of JavaScript](https://www.youtube.com/watch?v=63I-mEuSvGA)
- [📝 Chrome’s Paint Flashing Tool](https://engineering.entelo.com/chromes-paint-flashing-tool-b5c880849635)
- [📝 Operationalizing Performance with Performance Budgets](https://rigor.com/blog/operationalizing-performance-budgets)
- [📝 Optimizing startup performance](https://developer.mozilla.org/en-US/docs/Web/Performance/Optimizing_startup_performance)
- [📝 Performance budgets 101](https://web.dev/performance-budgets-101)
- [📝 Performance Budgets, Pragmatically](https://csswizardry.com/2020/01/performance-budgets-pragmatically)
- [📝 Responsive Design on a Budget](https://clearleft.com/posts/responsive-design-on-a-budget)
- [📝 Setting a performance budget](https://timkadlec.com/2013/01/setting-a-performance-budget)
- [📝 Start Performance Budgeting](https://medium.com/@addyosmani/start-performance-budgeting-dabde04cf6a3)
- [📝 The cost of JavaScript in 2019](https://v8.dev/blog/cost-of-javascript-2019)
- [📝 User-centric performance metrics](https://web.dev/user-centric-performance-metrics)
- [📝 Web Performance Budgets are more than mere thresholds](https://tobias.is/blogging/web-performance-budgets-as-currency)

### Performance Budget Tools

- [🛠 Browser Calories](https://browserdiet.com/calories)
- [🛠 Performance Budget Calculator](https://perf-budget-calculator.firebaseapp.com)
- [🛠 Performance Budget Calculator](https://www.performancebudget.io)

## Prefetching

- [🎥 The Art of Predictive Prefetch](https://www.youtube.com/watch?v=UwjzFGCAuLw)
- [📝 `<link rel=”prefetch/preload”>` in webpack](https://medium.com/webpack/link-rel-prefetch-preload-in-webpack-51a52358f84c)
- [📝 Instant And Consistent Page Load Through Prerendering](https://developers.cyberagent.co.jp/blog/archives/37264)
- [📝 Preload, Prefetch And Priorities in Chrome](https://medium.com/reloading/preload-prefetch-and-priorities-in-chrome-776165961bbf)
- [📝 Speed up next-page navigations with prefetching](https://dev.to/addyosmani/speed-up-next-page-navigations-with-prefetching-4285)
- [📝 Webpack Prefetching/Preloading modules](https://webpack.js.org/guides/code-splitting/#prefetchingpreloading-modules)
- [🛠 preload-webpack-plugin](https://github.com/GoogleChromeLabs/preload-webpack-plugin)

### Prefetching Tools

- [🛠 Faster subsequent page-loads by prefetching in-viewport links during idle time](https://github.com/GoogleChromeLabs/quicklink)

## Web Frameworks

### React

- [🎥 DOM as a Second-class Citizen](https://www.youtube.com/watch?v=Zemce4Y1Y-A)
- [🎥 React 18 Concurrency, Explained](https://www.youtube.com/watch?v=i-_6wyohduo&ab_channel=SmashingMagazine)
- [🎥 React Performance Debugging Masterclass](https://gitnation.com/contents/react-performance-debugging-masterclass)
- [📝 21 Performance Optimization Techniques for React Apps](https://www.codementor.io/blog/react-optimization-5wiwjnf9hj)
- [📝 Death by a thousand useCallbacks](https://royi-codes.vercel.app/thousand-usecallbacks)
- [📝 How does React 18 work inside?](https://dev.to/ktmouk/how-does-react-18-work-inside-1c8l)
- [📝 How to write performant React apps with Context](https://dev.to/adevnadia/how-to-write-performant-react-apps-with-context-24cp)
- [📝 How to write performant React code: rules, patterns, do's and don'ts](https://dev.to/adevnadia/how-to-write-performant-react-code-rules-patterns-dos-and-donts-40gk)
- [📝 How to write performant React code: rules, patterns, do's and don'ts](https://www.developerway.com/posts/how-to-write-performant-react-code)
- [📝 Improved Next.js and Gatsby page load performance with granular chunking](https://web.dev/granular-chunking-nextjs)
- [📝 Mobile Performance of Next.js Sites](https://calendar.perfplanet.com/2022/mobile-performance-of-next-js-sites)
- [📝 New Suspense SSR Architecture in React 18](https://github.com/reactwg/react-18/discussions/37)
- [📝 Next.js Performance: Making a Fast Framework Even Faster](https://calibreapp.com/blog/nextjs-performance)
- [📝 Optimize Data Fetching](https://medhatdawoud.net/blog/optimize-data-fetching)
- [📝 Optimizing third-party script loading in Next.js](https://web.dev/script-component)
- [📝 progressive react](https://houssein.me/progressive-react)
- [📝 React Concurrency, Explained](https://3perf.com/talks/react-concurrency)
- [📝 React Hooks and Tips to Avoid Useless Component Render Applied on Lists](https://blog.theodo.com/2022/01/react-list-hooks-avoid-render)
- [📝 React Performance – 13 Ways to Optimize Performance of your React App](https://www.simform.com/blog/react-performance)
- [📝 Reassure: Performance testing companion for React](https://github.com/callstack/reassure)
- [📝 SSR, Streaming, and CSS-in-JS](https://shud.in/posts/ssr-streaming-and-css-in-js)
- [📝 Updating React at Etsy](https://github.com/mq2thez/blog/blob/main/upgrade-react-etsy/preact-vs-react.md)
- [📚 Advanced React](https://www.advanced-react.com)
- [🛠 eslint-plugin-react-perf](https://github.com/cvazac/eslint-plugin-react-perf)

### React Rendering

- [🎥 A Cartoon Intro to Fiber](https://www.youtube.com/watch?v=ZCuYPiUIONs)
- [🎥 Data Fetching with React Server Components](https://www.youtube.com/watch?v=TQQPAU21ZUw&ab_channel=MetaOpenSource)
- [🎥 Deep diving on Concurrent React](https://www.youtube.com/watch?v=js7E1VKqIng&ab_channel=ReactIndia)
- [🎥 Inside Fiber: the in-depth overview you wanted](https://www.youtube.com/watch?v=jMZBhHzD3H8&ab_channel=ReactNext)
- [🎥 React Fiber Deep Dive](https://www.youtube.com/watch?v=aS41Y_eyNrU)
- [📝 In-depth explanation of state and props update in React](https://indepth.dev/posts/1009/in-depth-explanation-of-state-and-props-update-in-react)
- [📝 Inside Fiber: in-depth overview of the new reconciliation algorithm in React](https://indepth.dev/posts/1008/inside-fiber-in-depth-overview-of-the-new-reconciliation-algorithm-in-react)
- [📝 Learning the React reconciliation algorithm with performance measures](https://imkev.dev/react-reconciliation-performance-measures)
- [📝 React Performance: How to avoid redundant re-renders](https://itnext.io/react-performance-how-to-avoid-redundant-re-renders-6a33618d92a3)
- [📝 React re-renders guide: everything, all at once](https://www.developerway.com/posts/react-re-renders-guide)
- [📝 React Rendering Order](https://imkev.dev/react-rendering-order)
- [📝 Server and Client Components](https://beta.nextjs.org/docs/rendering/server-and-client-components)
- [📝 Should you optimize every re-render?](https://imkev.dev/optimizing-rerenders)
- [📝 Signal Boosting](https://preactjs.com/blog/signal-boosting)
- [📝 The future of rendering in React](https://prateeksurana.me/blog/future-of-rendering-in-react)
- [📝 Why React Re-Renders](https://www.joshwcomeau.com/react/why-react-re-renders)

### Measuring React

- [🎥 How to use the React Profiler to find and fix Performance Problems](https://www.youtube.com/watch?v=00RoZflFE34&ab_channel=BenAwad)
- [🎥 Profiling React Apps like a Pro](https://www.youtube.com/watch?v=uZn9tVIISeQ)
- [🎥 React Performance with React Dev Tools](https://www.youtube.com/watch?v=sFvOMc7W7k0&ab_channel=ReactNext)
- [📝 Get Fast, Stay Fast: How To Monitor React Render Performance](https://3perf.com/blog/react-monitoring)
- [📝 Measuring JS code performance. Part I: using react-benchmark](https://medium.com/@goooseman/measuring-js-code-performance-part-i-using-a-benchmark-f6fd45a5cea)
- [📝 Measuring JS code performance. Part II: interaction speed](https://medium.com/@goooseman/measuring-js-code-performance-part-ii-interaction-speed-b18cf2201a84)
- [📝 Measuring React app performance](https://www.debugbear.com/blog/measuring-react-app-performance)
- [📝 Performance Profiling a Redux App](https://medium.com/@vcarl/performance-profiling-a-redux-app-c85e67bf84ae)
- [📝 Profiling & Optimizing the runtime performance with the DevTools Performance tab](https://www.iamtk.co/profiling-and-optimizing-the-runtime-performance-with-the-devtools-performance-tab)
- [📝 Profiling React.js Performance](https://addyosmani.com/blog/profiling-react-js)

## Sustainability

- [📝 Core Web Vitals meets sustainability](https://ecoping.earth/blog/core-web-vitals-and-sustainability)
- [📝 How Improving Website Performance Can Help Save The Planet](https://www.smashingmagazine.com/2019/01/save-planet-improving-website-performance)
- [📝 Web Performance + Ecological Impact](https://bullhorncreative.com/blog/web-performance-ecological-impact)
- [📝 Website performance and the planet](https://blog.webpagetest.org/posts/website-performance-and-the-planet)

## Tweets

- [Another reason for not declaring React components inside other components](https://twitter.com/asidorenko_/status/1605313331740418051)
- [Blank page with an embedded tweet. How bad can it be?](https://twitter.com/mhevery/status/1606438382561026049)
- [Check out the new Priority Hints](https://twitter.com/tunetheweb/status/1615685225106767874)
- [ChromeDevTools Long Tasks](https://twitter.com/jebbacca/status/1608472228265345024)
- [Compile Code — Profiling](https://twitter.com/jebbacca/status/1618615238034874371)
- [CSS Selector Performance](https://twitter.com/csswizardry/status/1616906377829433351)
- [Frontend performance tips to keep top of mind](https://twitter.com/Steve8708/status/1549501457140830208)
- [Google Search Console warning the INP](https://twitter.com/tunetheweb/status/1679085260263366663)
- [How can I optimize my frontend for the fastest page load times?](https://twitter.com/leeerob/status/1481693352059973632)
- [How I typically test performance](https://twitter.com/iamakulov/status/1661475656050556930)
- [How Wix improved TTFB with 103 Early Hints](https://twitter.com/alonkochba/status/1584418867295965184)
- [Image performance cheatsheet](https://twitter.com/Steve8708/status/1506281613746917394)
- [img fetchpriority="high": LCP improvement of ~150ms](https://twitter.com/senthil_hi/status/1589676464215326720)
- [Investigating Core Web Vital issues](https://twitter.com/tunetheweb/status/1661699095025664004)
- [mobile performance for sites built with Next.js](https://mobile.twitter.com/clark_gunn/status/1593756237874839555/photo/1)
- [Optimize head and body separately](https://twitter.com/csswizardry/status/1504106607721988102)
- [Optimizing LCP](https://twitter.com/Steve8708/status/1508861192890044416)
- [Performance Insights by Builder.io](https://twitter.com/Steve8708/status/1501584994208153601)
- [React 18 Concurrency, Explained](https://twitter.com/iamakulov/status/1610652344164954114)
- [React 18 Concurrency](https://twitter.com/iamakulov/status/1566716820601466880)
- [React Perf: Causal Case Study](https://twitter.com/iamakulov/status/1600169184360398851)
- [React Time Slicing](https://twitter.com/heyImMapleLeaf/status/1567960223759093760)
- [Signals — Reactivity + UI](https://twitter.com/geoffreylitt/status/1632459743636717568)
- [Spotify Performance Profiling](https://twitter.com/iamakulov/status/1522008502398554113)
- [The difference between "On Load" and "Document Complete" in WebPageTest](https://twitter.com/stoyanstefanov/status/1617612093594939392)
- [The most important problems in Web Perf](https://twitter.com/amilajack/status/1478062246072754179)
- [Things I found in a slow React website today](https://twitter.com/nomsternom/status/1601587970792132608)
- [Tool: quantify what will make a real difference](https://twitter.com/Steve8708/status/1499906268781187077)
- [Use Map over object](https://twitter.com/Steve8708/status/1508502291170484224)
- [useCallback and useMemo: no perf effect](https://twitter.com/ProvablyFlarnie/status/1504223109439651841)
- [Video Compression](https://twitter.com/Greg_GLD/status/1771146684375896472)
- [Web Performance at Slack](https://twitter.com/zeigenvector/status/1448684941663948801)
- [React & Redux performance at Slack](https://twitter.com/wordsofteekay/status/1789713542993621165)
- [Performance Budget](https://x.com/wordsofteekay/status/1827716913293902078)

## UX

- [🎥 Adaptive Loading - Improving web performance on slow devices](https://www.youtube.com/watch?v=puUPpVrIRkc&t=488s)
- [🎥 Building The Web](https://www.youtube.com/watch?v=b2PaxNwr9nI)
- [🎥 Design Principles For The Web](https://vimeo.com/496918165)
- [🎥 Measuring User Perceived Performance to Prioritize Product Work](https://www.youtube.com/watch?v=tah_hbOc86w)
- [🎥 Perceived Performance: The only kind that really matters](https://www.youtube.com/watch?v=USH4iPQ44LQ)
- [🎥 Stephanie Walter on Cheating The UX When There Is Nothing More To Optimize](https://vimeo.com/251825705)
- [🎥 The Layers of the Web](https://www.youtube.com/watch?v=96DCTASFniI&list=PLgaHsrPMLcFBD8kHNmgeBstA3zOxY_x-j&index=3)
- [📝 A Bone to Pick with Skeleton Screens](https://www.viget.com/articles/a-bone-to-pick-with-skeleton-screens)
- [📝 A Designer’s Guide to Perceived Performance](https://marvelapp.com/blog/a-designers-guide-to-perceived-performance)
- [📝 An experimental responsiveness metric](https://web.dev/responsiveness)
- [📝 Designing for Performance](https://designingforperformance.com)
- [📝 Hands On with the new Responsiveness Metrics](https://calendar.perfplanet.com/2021/hands-on-with-the-new-responsiveness-metrics)
- [📝 How Much Faster is Fast Enough? User Perception of Latency & Latency Improvements in Direct and Indirect Touch](https://www.tactuallabs.com/papers/howMuchFasterIsFastEnoughCHI15.pdf)
- [📝 How to Improve Perceived Performance in Mobile Apps](https://instamobile.io/mobile-design/perceived-performance-mobile-apps)
- [📝 Improving Perceived Performance](resources/improve-perceived-performance.pdf)
- [📝 Optimistic UI Patterns for Improved Perceived Performance](https://simonhearne.com/2021/optimistic-ui-patterns)
- [📝 Performance Design: Designing for the illusion of speed](https://uxdesign.cc/performance-design-designing-for-the-illusion-of-speed-576110e9e558)
- [📝 Performance perception: Correlation to RUM metrics](https://techblog.wikimedia.org/2019/06/17/performance-perception-correlation-to-rum-metrics)
- [📝 Performance perception: How satisfied are Wikipedia users?](https://techblog.wikimedia.org/2019/05/29/performance-perception-how-satisfied-are-wikipedia-users)
- [📝 Performance perception: The effect of late-loading banners](https://techblog.wikimedia.org/2019/06/13/performance-perception-the-effect-of-late-loading-banners)
- [📝 Resilient web design](https://resilientwebdesign.com)
- [📝 The Art of UI Skeletons](http://farmdev.com/thoughts/108/the-art-of-ui-skeletons)
- [📝 Towards an animation smoothness metric](https://web.dev/smoothness)
- [📝 True Lies Of Optimistic User Interfaces](https://www.smashingmagazine.com/2016/11/true-lies-of-optimistic-user-interfaces)

## Web APIs

- [📝 Every Transition is a Page Transition?](https://www.oddbird.net/2022/06/29/shared-elements)
- [📝 Speed Up Resource Loading with Priority Hints and fetchpriority](https://nitropack.io/blog/post/priority-hints)
- [📝 Tracking CPU with Long Tasks API](https://calendar.perfplanet.com/2017/tracking-cpu-with-long-tasks-api)
- [📝 Web Performance APIs Appreciation Post](https://calendar.perfplanet.com/2022/web-performance-apis-appreciation-post)

## License

[MIT](/LICENSE) © [TK](https://iamtk.co)

</samp>
