import { UserEntity } from 'src/entities/user.entity';
import { UserAvatarColor, UserMetadataKey } from 'src/enum';
import { authStub } from 'test/fixtures/auth.stub';

export const userStub = {
  admin: Object.freeze<UserEntity>({
    ...authStub.admin.user,
    password: 'admin_password',
    name: 'admin_name',
    id: 'admin_id',
    storageLabel: 'admin',
    oauthId: '',
    shouldChangePassword: false,
    profileImagePath: '',
    createdAt: new Date('2021-01-01'),
    deletedAt: null,
    updatedAt: new Date('2021-01-01'),
    tags: [],
    assets: [],
    metadata: [],
    quotaSizeInBytes: null,
    quotaUsageInBytes: 0,
  }),
  user1: Object.freeze<UserEntity>({
    ...authStub.user1.user,
    password: 'immich_password',
    name: 'immich_name',
    storageLabel: null,
    oauthId: '',
    shouldChangePassword: false,
    profileImagePath: '',
    createdAt: new Date('2021-01-01'),
    deletedAt: null,
    updatedAt: new Date('2021-01-01'),
    tags: [],
    assets: [],
    metadata: [
      {
        user: authStub.user1.user,
        userId: authStub.user1.user.id,
        key: UserMetadataKey.PREFERENCES,
        value: { avatar: { color: UserAvatarColor.PRIMARY } },
      },
    ],
    quotaSizeInBytes: null,
    quotaUsageInBytes: 0,
  }),
  user2: Object.freeze<UserEntity>({
    ...authStub.user2.user,
    password: 'immich_password',
    name: 'immich_name',
    storageLabel: null,
    oauthId: '',
    shouldChangePassword: false,
    profileImagePath: '',
    createdAt: new Date('2021-01-01'),
    deletedAt: null,
    updatedAt: new Date('2021-01-01'),
    tags: [],
    assets: [],
    quotaSizeInBytes: null,
    quotaUsageInBytes: 0,
  }),
  storageLabel: Object.freeze<UserEntity>({
    ...authStub.user1.user,
    password: 'immich_password',
    name: 'immich_name',
    storageLabel: 'label-1',
    oauthId: '',
    shouldChangePassword: false,
    profileImagePath: '',
    createdAt: new Date('2021-01-01'),
    deletedAt: null,
    updatedAt: new Date('2021-01-01'),
    tags: [],
    assets: [],
    quotaSizeInBytes: null,
    quotaUsageInBytes: 0,
  }),
  profilePath: Object.freeze<UserEntity>({
    ...authStub.user1.user,
    password: 'immich_password',
    name: 'immich_name',
    storageLabel: 'label-1',
    oauthId: '',
    shouldChangePassword: false,
    profileImagePath: '/path/to/profile.jpg',
    createdAt: new Date('2021-01-01'),
    deletedAt: null,
    updatedAt: new Date('2021-01-01'),
    tags: [],
    assets: [],
    quotaSizeInBytes: null,
    quotaUsageInBytes: 0,
  }),
};
