import { PersonEntity } from 'src/entities/person.entity';
import { userStub } from 'test/fixtures/user.stub';

export const personStub = {
  noName: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
  hidden: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: true,
  }),
  withName: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: 'Person 1',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: 'assetFaceId',
    faceAsset: null,
    isHidden: false,
  }),
  withBirthDate: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: 'Person 1',
    birthDate: '1976-06-30',
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
  noThumbnail: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: '',
    birthDate: null,
    thumbnailPath: '',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
  newThumbnail: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: '',
    birthDate: null,
    thumbnailPath: '/new/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: 'asset-id',
    faceAsset: null,
    isHidden: false,
  }),
  primaryPerson: Object.freeze<PersonEntity>({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: 'Person 1',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
  mergePerson: Object.freeze<PersonEntity>({
    id: 'person-2',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: 'Person 2',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
  randomPerson: Object.freeze<PersonEntity>({
    id: 'person-3',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    ownerId: userStub.admin.id,
    owner: userStub.admin,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
  }),
};
