import { LibraryEntity } from 'src/entities/library.entity';
import { userStub } from 'test/fixtures/user.stub';

export const libraryStub = {
  externalLibrary1: Object.freeze<LibraryEntity>({
    id: 'library-id',
    name: 'test_library',
    assets: [],
    owner: userStub.admin,
    ownerId: 'admin_id',
    importPaths: [],
    createdAt: new Date('2023-01-01'),
    updatedAt: new Date('2023-01-01'),
    refreshedAt: null,
    exclusionPatterns: [],
  }),
  externalLibrary2: Object.freeze<LibraryEntity>({
    id: 'library-id2',
    name: 'test_library2',
    assets: [],
    owner: userStub.admin,
    ownerId: 'admin_id',
    importPaths: [],
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2022-01-01'),
    refreshedAt: null,
    exclusionPatterns: [],
  }),
  externalLibraryWithImportPaths1: Object.freeze<LibraryEntity>({
    id: 'library-id-with-paths1',
    name: 'library-with-import-paths1',
    assets: [],
    owner: userStub.admin,
    ownerId: 'admin_id',
    importPaths: ['/foo', '/bar'],
    createdAt: new Date('2023-01-01'),
    updatedAt: new Date('2023-01-01'),
    refreshedAt: null,
    exclusionPatterns: [],
  }),
  externalLibraryWithImportPaths2: Object.freeze<LibraryEntity>({
    id: 'library-id-with-paths2',
    name: 'library-with-import-paths2',
    assets: [],
    owner: userStub.admin,
    ownerId: 'admin_id',
    importPaths: ['/xyz', '/asdf'],
    createdAt: new Date('2023-01-01'),
    updatedAt: new Date('2023-01-01'),
    refreshedAt: null,
    exclusionPatterns: [],
  }),
  patternPath: Object.freeze<LibraryEntity>({
    id: 'library-id1337',
    name: 'importpath-exclusion-library1',
    assets: [],
    owner: userStub.admin,
    ownerId: 'user-id',
    importPaths: ['/xyz', '/asdf'],
    createdAt: new Date('2023-01-01'),
    updatedAt: new Date('2023-01-01'),
    refreshedAt: null,
    exclusionPatterns: ['**/dir1/**'],
  }),
  hasImmichPaths: Object.freeze<LibraryEntity>({
    id: 'library-id1337',
    name: 'importpath-exclusion-library1',
    assets: [],
    owner: userStub.admin,
    ownerId: 'user-id',
    importPaths: ['upload/thumbs', 'xyz', 'upload/library'],
    createdAt: new Date('2023-01-01'),
    updatedAt: new Date('2023-01-01'),
    refreshedAt: null,
    exclusionPatterns: ['**/dir1/**'],
  }),
};
