-- NOTE: This file is auto generated by ./sql-generator

-- PersonRepository.reassignFaces
UPDATE "asset_faces"
SET
  "personId" = $1
WHERE
  "personId" = $2

-- PersonRepository.getAllForUser
SELECT
  "person"."id" AS "person_id",
  "person"."createdAt" AS "person_createdAt",
  "person"."updatedAt" AS "person_updatedAt",
  "person"."ownerId" AS "person_ownerId",
  "person"."name" AS "person_name",
  "person"."birthDate" AS "person_birthDate",
  "person"."thumbnailPath" AS "person_thumbnailPath",
  "person"."faceAssetId" AS "person_faceAssetId",
  "person"."isHidden" AS "person_isHidden"
FROM
  "person" "person"
  LEFT JOIN "asset_faces" "face" ON "face"."personId" = "person"."id"
  INNER JOIN "assets" "asset" ON "asset"."id" = "face"."assetId"
  AND ("asset"."deletedAt" IS NULL)
WHERE
  "person"."ownerId" = $1
  AND "asset"."isArchived" = false
  AND "person"."thumbnailPath" != ''
  AND "person"."isHidden" = false
GROUP BY
  "person"."id"
HAVING
  "person"."name" != ''
  OR COUNT("face"."assetId") >= $2
ORDER BY
  "person"."isHidden" ASC,
  NULLIF("person"."name", '') IS NULL ASC,
  COUNT("face"."assetId") DESC,
  NULLIF("person"."name", '') ASC NULLS LAST,
  "person"."createdAt" ASC
LIMIT
  11
OFFSET
  10

-- PersonRepository.getAllWithoutFaces
SELECT
  "person"."id" AS "person_id",
  "person"."createdAt" AS "person_createdAt",
  "person"."updatedAt" AS "person_updatedAt",
  "person"."ownerId" AS "person_ownerId",
  "person"."name" AS "person_name",
  "person"."birthDate" AS "person_birthDate",
  "person"."thumbnailPath" AS "person_thumbnailPath",
  "person"."faceAssetId" AS "person_faceAssetId",
  "person"."isHidden" AS "person_isHidden"
FROM
  "person" "person"
  LEFT JOIN "asset_faces" "face" ON "face"."personId" = "person"."id"
GROUP BY
  "person"."id"
HAVING
  COUNT("face"."assetId") = 0

-- PersonRepository.getFaces
SELECT
  "AssetFaceEntity"."id" AS "AssetFaceEntity_id",
  "AssetFaceEntity"."assetId" AS "AssetFaceEntity_assetId",
  "AssetFaceEntity"."personId" AS "AssetFaceEntity_personId",
  "AssetFaceEntity"."imageWidth" AS "AssetFaceEntity_imageWidth",
  "AssetFaceEntity"."imageHeight" AS "AssetFaceEntity_imageHeight",
  "AssetFaceEntity"."boundingBoxX1" AS "AssetFaceEntity_boundingBoxX1",
  "AssetFaceEntity"."boundingBoxY1" AS "AssetFaceEntity_boundingBoxY1",
  "AssetFaceEntity"."boundingBoxX2" AS "AssetFaceEntity_boundingBoxX2",
  "AssetFaceEntity"."boundingBoxY2" AS "AssetFaceEntity_boundingBoxY2",
  "AssetFaceEntity"."sourceType" AS "AssetFaceEntity_sourceType",
  "AssetFaceEntity__AssetFaceEntity_person"."id" AS "AssetFaceEntity__AssetFaceEntity_person_id",
  "AssetFaceEntity__AssetFaceEntity_person"."createdAt" AS "AssetFaceEntity__AssetFaceEntity_person_createdAt",
  "AssetFaceEntity__AssetFaceEntity_person"."updatedAt" AS "AssetFaceEntity__AssetFaceEntity_person_updatedAt",
  "AssetFaceEntity__AssetFaceEntity_person"."ownerId" AS "AssetFaceEntity__AssetFaceEntity_person_ownerId",
  "AssetFaceEntity__AssetFaceEntity_person"."name" AS "AssetFaceEntity__AssetFaceEntity_person_name",
  "AssetFaceEntity__AssetFaceEntity_person"."birthDate" AS "AssetFaceEntity__AssetFaceEntity_person_birthDate",
  "AssetFaceEntity__AssetFaceEntity_person"."thumbnailPath" AS "AssetFaceEntity__AssetFaceEntity_person_thumbnailPath",
  "AssetFaceEntity__AssetFaceEntity_person"."faceAssetId" AS "AssetFaceEntity__AssetFaceEntity_person_faceAssetId",
  "AssetFaceEntity__AssetFaceEntity_person"."isHidden" AS "AssetFaceEntity__AssetFaceEntity_person_isHidden"
FROM
  "asset_faces" "AssetFaceEntity"
  LEFT JOIN "person" "AssetFaceEntity__AssetFaceEntity_person" ON "AssetFaceEntity__AssetFaceEntity_person"."id" = "AssetFaceEntity"."personId"
WHERE
  (("AssetFaceEntity"."assetId" = $1))
ORDER BY
  "AssetFaceEntity"."boundingBoxX1" ASC

-- PersonRepository.getFaceById
SELECT DISTINCT
  "distinctAlias"."AssetFaceEntity_id" AS "ids_AssetFaceEntity_id"
FROM
  (
    SELECT
      "AssetFaceEntity"."id" AS "AssetFaceEntity_id",
      "AssetFaceEntity"."assetId" AS "AssetFaceEntity_assetId",
      "AssetFaceEntity"."personId" AS "AssetFaceEntity_personId",
      "AssetFaceEntity"."imageWidth" AS "AssetFaceEntity_imageWidth",
      "AssetFaceEntity"."imageHeight" AS "AssetFaceEntity_imageHeight",
      "AssetFaceEntity"."boundingBoxX1" AS "AssetFaceEntity_boundingBoxX1",
      "AssetFaceEntity"."boundingBoxY1" AS "AssetFaceEntity_boundingBoxY1",
      "AssetFaceEntity"."boundingBoxX2" AS "AssetFaceEntity_boundingBoxX2",
      "AssetFaceEntity"."boundingBoxY2" AS "AssetFaceEntity_boundingBoxY2",
      "AssetFaceEntity"."sourceType" AS "AssetFaceEntity_sourceType",
      "AssetFaceEntity__AssetFaceEntity_person"."id" AS "AssetFaceEntity__AssetFaceEntity_person_id",
      "AssetFaceEntity__AssetFaceEntity_person"."createdAt" AS "AssetFaceEntity__AssetFaceEntity_person_createdAt",
      "AssetFaceEntity__AssetFaceEntity_person"."updatedAt" AS "AssetFaceEntity__AssetFaceEntity_person_updatedAt",
      "AssetFaceEntity__AssetFaceEntity_person"."ownerId" AS "AssetFaceEntity__AssetFaceEntity_person_ownerId",
      "AssetFaceEntity__AssetFaceEntity_person"."name" AS "AssetFaceEntity__AssetFaceEntity_person_name",
      "AssetFaceEntity__AssetFaceEntity_person"."birthDate" AS "AssetFaceEntity__AssetFaceEntity_person_birthDate",
      "AssetFaceEntity__AssetFaceEntity_person"."thumbnailPath" AS "AssetFaceEntity__AssetFaceEntity_person_thumbnailPath",
      "AssetFaceEntity__AssetFaceEntity_person"."faceAssetId" AS "AssetFaceEntity__AssetFaceEntity_person_faceAssetId",
      "AssetFaceEntity__AssetFaceEntity_person"."isHidden" AS "AssetFaceEntity__AssetFaceEntity_person_isHidden"
    FROM
      "asset_faces" "AssetFaceEntity"
      LEFT JOIN "person" "AssetFaceEntity__AssetFaceEntity_person" ON "AssetFaceEntity__AssetFaceEntity_person"."id" = "AssetFaceEntity"."personId"
    WHERE
      (("AssetFaceEntity"."id" = $1))
  ) "distinctAlias"
ORDER BY
  "AssetFaceEntity_id" ASC
LIMIT
  1

-- PersonRepository.getFaceByIdWithAssets
SELECT DISTINCT
  "distinctAlias"."AssetFaceEntity_id" AS "ids_AssetFaceEntity_id"
FROM
  (
    SELECT
      "AssetFaceEntity"."id" AS "AssetFaceEntity_id",
      "AssetFaceEntity"."assetId" AS "AssetFaceEntity_assetId",
      "AssetFaceEntity"."personId" AS "AssetFaceEntity_personId",
      "AssetFaceEntity"."imageWidth" AS "AssetFaceEntity_imageWidth",
      "AssetFaceEntity"."imageHeight" AS "AssetFaceEntity_imageHeight",
      "AssetFaceEntity"."boundingBoxX1" AS "AssetFaceEntity_boundingBoxX1",
      "AssetFaceEntity"."boundingBoxY1" AS "AssetFaceEntity_boundingBoxY1",
      "AssetFaceEntity"."boundingBoxX2" AS "AssetFaceEntity_boundingBoxX2",
      "AssetFaceEntity"."boundingBoxY2" AS "AssetFaceEntity_boundingBoxY2",
      "AssetFaceEntity"."sourceType" AS "AssetFaceEntity_sourceType",
      "AssetFaceEntity__AssetFaceEntity_person"."id" AS "AssetFaceEntity__AssetFaceEntity_person_id",
      "AssetFaceEntity__AssetFaceEntity_person"."createdAt" AS "AssetFaceEntity__AssetFaceEntity_person_createdAt",
      "AssetFaceEntity__AssetFaceEntity_person"."updatedAt" AS "AssetFaceEntity__AssetFaceEntity_person_updatedAt",
      "AssetFaceEntity__AssetFaceEntity_person"."ownerId" AS "AssetFaceEntity__AssetFaceEntity_person_ownerId",
      "AssetFaceEntity__AssetFaceEntity_person"."name" AS "AssetFaceEntity__AssetFaceEntity_person_name",
      "AssetFaceEntity__AssetFaceEntity_person"."birthDate" AS "AssetFaceEntity__AssetFaceEntity_person_birthDate",
      "AssetFaceEntity__AssetFaceEntity_person"."thumbnailPath" AS "AssetFaceEntity__AssetFaceEntity_person_thumbnailPath",
      "AssetFaceEntity__AssetFaceEntity_person"."faceAssetId" AS "AssetFaceEntity__AssetFaceEntity_person_faceAssetId",
      "AssetFaceEntity__AssetFaceEntity_person"."isHidden" AS "AssetFaceEntity__AssetFaceEntity_person_isHidden",
      "AssetFaceEntity__AssetFaceEntity_asset"."id" AS "AssetFaceEntity__AssetFaceEntity_asset_id",
      "AssetFaceEntity__AssetFaceEntity_asset"."deviceAssetId" AS "AssetFaceEntity__AssetFaceEntity_asset_deviceAssetId",
      "AssetFaceEntity__AssetFaceEntity_asset"."ownerId" AS "AssetFaceEntity__AssetFaceEntity_asset_ownerId",
      "AssetFaceEntity__AssetFaceEntity_asset"."libraryId" AS "AssetFaceEntity__AssetFaceEntity_asset_libraryId",
      "AssetFaceEntity__AssetFaceEntity_asset"."deviceId" AS "AssetFaceEntity__AssetFaceEntity_asset_deviceId",
      "AssetFaceEntity__AssetFaceEntity_asset"."type" AS "AssetFaceEntity__AssetFaceEntity_asset_type",
      "AssetFaceEntity__AssetFaceEntity_asset"."status" AS "AssetFaceEntity__AssetFaceEntity_asset_status",
      "AssetFaceEntity__AssetFaceEntity_asset"."originalPath" AS "AssetFaceEntity__AssetFaceEntity_asset_originalPath",
      "AssetFaceEntity__AssetFaceEntity_asset"."thumbhash" AS "AssetFaceEntity__AssetFaceEntity_asset_thumbhash",
      "AssetFaceEntity__AssetFaceEntity_asset"."encodedVideoPath" AS "AssetFaceEntity__AssetFaceEntity_asset_encodedVideoPath",
      "AssetFaceEntity__AssetFaceEntity_asset"."createdAt" AS "AssetFaceEntity__AssetFaceEntity_asset_createdAt",
      "AssetFaceEntity__AssetFaceEntity_asset"."updatedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_updatedAt",
      "AssetFaceEntity__AssetFaceEntity_asset"."deletedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_deletedAt",
      "AssetFaceEntity__AssetFaceEntity_asset"."fileCreatedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_fileCreatedAt",
      "AssetFaceEntity__AssetFaceEntity_asset"."localDateTime" AS "AssetFaceEntity__AssetFaceEntity_asset_localDateTime",
      "AssetFaceEntity__AssetFaceEntity_asset"."fileModifiedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_fileModifiedAt",
      "AssetFaceEntity__AssetFaceEntity_asset"."isFavorite" AS "AssetFaceEntity__AssetFaceEntity_asset_isFavorite",
      "AssetFaceEntity__AssetFaceEntity_asset"."isArchived" AS "AssetFaceEntity__AssetFaceEntity_asset_isArchived",
      "AssetFaceEntity__AssetFaceEntity_asset"."isExternal" AS "AssetFaceEntity__AssetFaceEntity_asset_isExternal",
      "AssetFaceEntity__AssetFaceEntity_asset"."isOffline" AS "AssetFaceEntity__AssetFaceEntity_asset_isOffline",
      "AssetFaceEntity__AssetFaceEntity_asset"."checksum" AS "AssetFaceEntity__AssetFaceEntity_asset_checksum",
      "AssetFaceEntity__AssetFaceEntity_asset"."duration" AS "AssetFaceEntity__AssetFaceEntity_asset_duration",
      "AssetFaceEntity__AssetFaceEntity_asset"."isVisible" AS "AssetFaceEntity__AssetFaceEntity_asset_isVisible",
      "AssetFaceEntity__AssetFaceEntity_asset"."livePhotoVideoId" AS "AssetFaceEntity__AssetFaceEntity_asset_livePhotoVideoId",
      "AssetFaceEntity__AssetFaceEntity_asset"."originalFileName" AS "AssetFaceEntity__AssetFaceEntity_asset_originalFileName",
      "AssetFaceEntity__AssetFaceEntity_asset"."sidecarPath" AS "AssetFaceEntity__AssetFaceEntity_asset_sidecarPath",
      "AssetFaceEntity__AssetFaceEntity_asset"."stackId" AS "AssetFaceEntity__AssetFaceEntity_asset_stackId",
      "AssetFaceEntity__AssetFaceEntity_asset"."duplicateId" AS "AssetFaceEntity__AssetFaceEntity_asset_duplicateId"
    FROM
      "asset_faces" "AssetFaceEntity"
      LEFT JOIN "person" "AssetFaceEntity__AssetFaceEntity_person" ON "AssetFaceEntity__AssetFaceEntity_person"."id" = "AssetFaceEntity"."personId"
      LEFT JOIN "assets" "AssetFaceEntity__AssetFaceEntity_asset" ON "AssetFaceEntity__AssetFaceEntity_asset"."id" = "AssetFaceEntity"."assetId"
      AND (
        "AssetFaceEntity__AssetFaceEntity_asset"."deletedAt" IS NULL
      )
    WHERE
      (("AssetFaceEntity"."id" = $1))
  ) "distinctAlias"
ORDER BY
  "AssetFaceEntity_id" ASC
LIMIT
  1

-- PersonRepository.reassignFace
UPDATE "asset_faces"
SET
  "personId" = $1
WHERE
  "id" = $2

-- PersonRepository.getByName
SELECT
  "person"."id" AS "person_id",
  "person"."createdAt" AS "person_createdAt",
  "person"."updatedAt" AS "person_updatedAt",
  "person"."ownerId" AS "person_ownerId",
  "person"."name" AS "person_name",
  "person"."birthDate" AS "person_birthDate",
  "person"."thumbnailPath" AS "person_thumbnailPath",
  "person"."faceAssetId" AS "person_faceAssetId",
  "person"."isHidden" AS "person_isHidden"
FROM
  "person" "person"
WHERE
  "person"."ownerId" = $1
  AND (
    LOWER("person"."name") LIKE $2
    OR LOWER("person"."name") LIKE $3
  )
LIMIT
  1000

-- PersonRepository.getDistinctNames
SELECT DISTINCT
  ON (lower("person"."name")) "person"."id" AS "person_id",
  "person"."name" AS "person_name"
FROM
  "person" "person"
WHERE
  "person"."ownerId" = $1
  AND "person"."name" != ''

-- PersonRepository.getStatistics
SELECT
  COUNT(DISTINCT ("asset"."id")) AS "count"
FROM
  "asset_faces" "face"
  LEFT JOIN "assets" "asset" ON "asset"."id" = "face"."assetId"
  AND ("asset"."deletedAt" IS NULL)
WHERE
  "face"."personId" = $1
  AND "asset"."isArchived" = false
  AND "asset"."deletedAt" IS NULL
  AND "asset"."livePhotoVideoId" IS NULL

-- PersonRepository.getNumberOfPeople
SELECT
  COUNT(DISTINCT ("person"."id")) AS "total",
  COUNT(DISTINCT ("person"."id")) FILTER (
    WHERE
      "person"."isHidden" = true
  ) AS "hidden"
FROM
  "person" "person"
  LEFT JOIN "asset_faces" "face" ON "face"."personId" = "person"."id"
  INNER JOIN "assets" "asset" ON "asset"."id" = "face"."assetId"
  AND ("asset"."deletedAt" IS NULL)
WHERE
  "person"."ownerId" = $1
  AND "asset"."isArchived" = false
  AND "person"."thumbnailPath" != ''
HAVING
  COUNT("face"."assetId") != 0

-- PersonRepository.getFacesByIds
SELECT
  "AssetFaceEntity"."id" AS "AssetFaceEntity_id",
  "AssetFaceEntity"."assetId" AS "AssetFaceEntity_assetId",
  "AssetFaceEntity"."personId" AS "AssetFaceEntity_personId",
  "AssetFaceEntity"."imageWidth" AS "AssetFaceEntity_imageWidth",
  "AssetFaceEntity"."imageHeight" AS "AssetFaceEntity_imageHeight",
  "AssetFaceEntity"."boundingBoxX1" AS "AssetFaceEntity_boundingBoxX1",
  "AssetFaceEntity"."boundingBoxY1" AS "AssetFaceEntity_boundingBoxY1",
  "AssetFaceEntity"."boundingBoxX2" AS "AssetFaceEntity_boundingBoxX2",
  "AssetFaceEntity"."boundingBoxY2" AS "AssetFaceEntity_boundingBoxY2",
  "AssetFaceEntity"."sourceType" AS "AssetFaceEntity_sourceType",
  "AssetFaceEntity__AssetFaceEntity_asset"."id" AS "AssetFaceEntity__AssetFaceEntity_asset_id",
  "AssetFaceEntity__AssetFaceEntity_asset"."deviceAssetId" AS "AssetFaceEntity__AssetFaceEntity_asset_deviceAssetId",
  "AssetFaceEntity__AssetFaceEntity_asset"."ownerId" AS "AssetFaceEntity__AssetFaceEntity_asset_ownerId",
  "AssetFaceEntity__AssetFaceEntity_asset"."libraryId" AS "AssetFaceEntity__AssetFaceEntity_asset_libraryId",
  "AssetFaceEntity__AssetFaceEntity_asset"."deviceId" AS "AssetFaceEntity__AssetFaceEntity_asset_deviceId",
  "AssetFaceEntity__AssetFaceEntity_asset"."type" AS "AssetFaceEntity__AssetFaceEntity_asset_type",
  "AssetFaceEntity__AssetFaceEntity_asset"."status" AS "AssetFaceEntity__AssetFaceEntity_asset_status",
  "AssetFaceEntity__AssetFaceEntity_asset"."originalPath" AS "AssetFaceEntity__AssetFaceEntity_asset_originalPath",
  "AssetFaceEntity__AssetFaceEntity_asset"."thumbhash" AS "AssetFaceEntity__AssetFaceEntity_asset_thumbhash",
  "AssetFaceEntity__AssetFaceEntity_asset"."encodedVideoPath" AS "AssetFaceEntity__AssetFaceEntity_asset_encodedVideoPath",
  "AssetFaceEntity__AssetFaceEntity_asset"."createdAt" AS "AssetFaceEntity__AssetFaceEntity_asset_createdAt",
  "AssetFaceEntity__AssetFaceEntity_asset"."updatedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_updatedAt",
  "AssetFaceEntity__AssetFaceEntity_asset"."deletedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_deletedAt",
  "AssetFaceEntity__AssetFaceEntity_asset"."fileCreatedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_fileCreatedAt",
  "AssetFaceEntity__AssetFaceEntity_asset"."localDateTime" AS "AssetFaceEntity__AssetFaceEntity_asset_localDateTime",
  "AssetFaceEntity__AssetFaceEntity_asset"."fileModifiedAt" AS "AssetFaceEntity__AssetFaceEntity_asset_fileModifiedAt",
  "AssetFaceEntity__AssetFaceEntity_asset"."isFavorite" AS "AssetFaceEntity__AssetFaceEntity_asset_isFavorite",
  "AssetFaceEntity__AssetFaceEntity_asset"."isArchived" AS "AssetFaceEntity__AssetFaceEntity_asset_isArchived",
  "AssetFaceEntity__AssetFaceEntity_asset"."isExternal" AS "AssetFaceEntity__AssetFaceEntity_asset_isExternal",
  "AssetFaceEntity__AssetFaceEntity_asset"."isOffline" AS "AssetFaceEntity__AssetFaceEntity_asset_isOffline",
  "AssetFaceEntity__AssetFaceEntity_asset"."checksum" AS "AssetFaceEntity__AssetFaceEntity_asset_checksum",
  "AssetFaceEntity__AssetFaceEntity_asset"."duration" AS "AssetFaceEntity__AssetFaceEntity_asset_duration",
  "AssetFaceEntity__AssetFaceEntity_asset"."isVisible" AS "AssetFaceEntity__AssetFaceEntity_asset_isVisible",
  "AssetFaceEntity__AssetFaceEntity_asset"."livePhotoVideoId" AS "AssetFaceEntity__AssetFaceEntity_asset_livePhotoVideoId",
  "AssetFaceEntity__AssetFaceEntity_asset"."originalFileName" AS "AssetFaceEntity__AssetFaceEntity_asset_originalFileName",
  "AssetFaceEntity__AssetFaceEntity_asset"."sidecarPath" AS "AssetFaceEntity__AssetFaceEntity_asset_sidecarPath",
  "AssetFaceEntity__AssetFaceEntity_asset"."stackId" AS "AssetFaceEntity__AssetFaceEntity_asset_stackId",
  "AssetFaceEntity__AssetFaceEntity_asset"."duplicateId" AS "AssetFaceEntity__AssetFaceEntity_asset_duplicateId"
FROM
  "asset_faces" "AssetFaceEntity"
  LEFT JOIN "assets" "AssetFaceEntity__AssetFaceEntity_asset" ON "AssetFaceEntity__AssetFaceEntity_asset"."id" = "AssetFaceEntity"."assetId"
WHERE
  (
    (
      (
        ("AssetFaceEntity"."assetId" = $1)
        AND ("AssetFaceEntity"."personId" = $2)
      )
    )
  )

-- PersonRepository.getRandomFace
SELECT
  "AssetFaceEntity"."id" AS "AssetFaceEntity_id",
  "AssetFaceEntity"."assetId" AS "AssetFaceEntity_assetId",
  "AssetFaceEntity"."personId" AS "AssetFaceEntity_personId",
  "AssetFaceEntity"."imageWidth" AS "AssetFaceEntity_imageWidth",
  "AssetFaceEntity"."imageHeight" AS "AssetFaceEntity_imageHeight",
  "AssetFaceEntity"."boundingBoxX1" AS "AssetFaceEntity_boundingBoxX1",
  "AssetFaceEntity"."boundingBoxY1" AS "AssetFaceEntity_boundingBoxY1",
  "AssetFaceEntity"."boundingBoxX2" AS "AssetFaceEntity_boundingBoxX2",
  "AssetFaceEntity"."boundingBoxY2" AS "AssetFaceEntity_boundingBoxY2",
  "AssetFaceEntity"."sourceType" AS "AssetFaceEntity_sourceType"
FROM
  "asset_faces" "AssetFaceEntity"
WHERE
  (("AssetFaceEntity"."personId" = $1))
LIMIT
  1

-- PersonRepository.getLatestFaceDate
SELECT
  MAX("jobStatus"."facesRecognizedAt")::text AS "latestDate"
FROM
  "asset_job_status" "jobStatus"
