-- NOTE: This file is auto generated by ./sql-generator

-- AccessRepository.activity.checkOwnerAccess
SELECT
  "ActivityEntity"."id" AS "ActivityEntity_id"
FROM
  "activity" "ActivityEntity"
WHERE
  (
    ("ActivityEntity"."id" IN ($1))
    AND ("ActivityEntity"."userId" = $2)
  )

-- AccessRepository.activity.checkAlbumOwnerAccess
SELECT
  "ActivityEntity"."id" AS "ActivityEntity_id"
FROM
  "activity" "ActivityEntity"
  LEFT JOIN "albums" "ActivityEntity__ActivityEntity_album" ON "ActivityEntity__ActivityEntity_album"."id" = "ActivityEntity"."albumId"
  AND (
    "ActivityEntity__ActivityEntity_album"."deletedAt" IS NULL
  )
WHERE
  (
    ("ActivityEntity"."id" IN ($1))
    AND (
      (
        (
          "ActivityEntity__ActivityEntity_album"."ownerId" = $2
        )
      )
    )
  )

-- AccessRepository.activity.checkCreateAccess
SELECT
  "album"."id" AS "album_id"
FROM
  "albums" "album"
  LEFT JOIN "albums_shared_users_users" "album_albumUsers_users" ON "album_albumUsers_users"."albumsId" = "album"."id"
  LEFT JOIN "users" "albumUsers" ON "albumUsers"."id" = "album_albumUsers_users"."usersId"
  AND ("albumUsers"."deletedAt" IS NULL)
WHERE
  (
    "album"."id" IN ($1)
    AND "album"."isActivityEnabled" = true
    AND (
      "album"."ownerId" = $2
      OR "albumUsers"."id" = $2
    )
  )
  AND ("album"."deletedAt" IS NULL)

-- AccessRepository.album.checkOwnerAccess
SELECT
  "AlbumEntity"."id" AS "AlbumEntity_id"
FROM
  "albums" "AlbumEntity"
WHERE
  (
    (
      ("AlbumEntity"."id" IN ($1))
      AND ("AlbumEntity"."ownerId" = $2)
    )
  )
  AND ("AlbumEntity"."deletedAt" IS NULL)

-- AccessRepository.album.checkSharedAlbumAccess
SELECT
  "AlbumEntity"."id" AS "AlbumEntity_id"
FROM
  "albums" "AlbumEntity"
  LEFT JOIN "albums_shared_users_users" "AlbumEntity__AlbumEntity_albumUsers" ON "AlbumEntity__AlbumEntity_albumUsers"."albumsId" = "AlbumEntity"."id"
  LEFT JOIN "users" "a641d58cf46d4a391ba060ac4dc337665c69ffea" ON "a641d58cf46d4a391ba060ac4dc337665c69ffea"."id" = "AlbumEntity__AlbumEntity_albumUsers"."usersId"
  AND (
    "a641d58cf46d4a391ba060ac4dc337665c69ffea"."deletedAt" IS NULL
  )
WHERE
  (
    (
      ("AlbumEntity"."id" IN ($1))
      AND (
        (
          (
            (
              (
                "a641d58cf46d4a391ba060ac4dc337665c69ffea"."id" = $2
              )
            )
          )
          AND (
            "AlbumEntity__AlbumEntity_albumUsers"."role" IN ($3, $4)
          )
        )
      )
    )
  )
  AND ("AlbumEntity"."deletedAt" IS NULL)

-- AccessRepository.album.checkSharedLinkAccess
SELECT
  "SharedLinkEntity"."albumId" AS "SharedLinkEntity_albumId",
  "SharedLinkEntity"."id" AS "SharedLinkEntity_id"
FROM
  "shared_links" "SharedLinkEntity"
WHERE
  (
    ("SharedLinkEntity"."id" = $1)
    AND ("SharedLinkEntity"."albumId" IN ($2))
  )

-- AccessRepository.asset.checkAlbumAccess
SELECT
  "asset"."id" AS "assetId",
  "asset"."livePhotoVideoId" AS "livePhotoVideoId"
FROM
  "albums" "album"
  INNER JOIN "albums_assets_assets" "album_asset" ON "album_asset"."albumsId" = "album"."id"
  INNER JOIN "assets" "asset" ON "asset"."id" = "album_asset"."assetsId"
  AND ("asset"."deletedAt" IS NULL)
  LEFT JOIN "albums_shared_users_users" "album_albumUsers_users" ON "album_albumUsers_users"."albumsId" = "album"."id"
  LEFT JOIN "users" "albumUsers" ON "albumUsers"."id" = "album_albumUsers_users"."usersId"
  AND ("albumUsers"."deletedAt" IS NULL)
WHERE
  (
    array["asset"."id", "asset"."livePhotoVideoId"] && array[$1]::uuid []
    AND (
      "album"."ownerId" = $2
      OR "albumUsers"."id" = $2
    )
  )
  AND ("album"."deletedAt" IS NULL)

-- AccessRepository.asset.checkOwnerAccess
SELECT
  "AssetEntity"."id" AS "AssetEntity_id"
FROM
  "assets" "AssetEntity"
WHERE
  (
    ("AssetEntity"."id" IN ($1))
    AND ("AssetEntity"."ownerId" = $2)
  )

-- AccessRepository.asset.checkPartnerAccess
SELECT
  "asset"."id" AS "assetId"
FROM
  "partners" "partner"
  INNER JOIN "users" "sharedBy" ON "sharedBy"."id" = "partner"."sharedById"
  AND ("sharedBy"."deletedAt" IS NULL)
  INNER JOIN "assets" "asset" ON "asset"."ownerId" = "sharedBy"."id"
  AND ("asset"."deletedAt" IS NULL)
WHERE
  "partner"."sharedWithId" = $1
  AND "asset"."isArchived" = false
  AND "asset"."id" IN ($2)

-- AccessRepository.asset.checkSharedLinkAccess
SELECT
  "assets"."id" AS "assetId",
  "assets"."livePhotoVideoId" AS "assetLivePhotoVideoId",
  "albumAssets"."id" AS "albumAssetId",
  "albumAssets"."livePhotoVideoId" AS "albumAssetLivePhotoVideoId"
FROM
  "shared_links" "sharedLink"
  LEFT JOIN "albums" "album" ON "album"."id" = "sharedLink"."albumId"
  AND ("album"."deletedAt" IS NULL)
  LEFT JOIN "shared_link__asset" "assets_sharedLink" ON "assets_sharedLink"."sharedLinksId" = "sharedLink"."id"
  LEFT JOIN "assets" "assets" ON "assets"."id" = "assets_sharedLink"."assetsId"
  AND ("assets"."deletedAt" IS NULL)
  LEFT JOIN "albums_assets_assets" "album_albumAssets" ON "album_albumAssets"."albumsId" = "album"."id"
  LEFT JOIN "assets" "albumAssets" ON "albumAssets"."id" = "album_albumAssets"."assetsId"
  AND ("albumAssets"."deletedAt" IS NULL)
WHERE
  "sharedLink"."id" = $1
  AND array[
    "assets"."id",
    "assets"."livePhotoVideoId",
    "albumAssets"."id",
    "albumAssets"."livePhotoVideoId"
  ] && array[$2]::uuid []

-- AccessRepository.authDevice.checkOwnerAccess
SELECT
  "SessionEntity"."id" AS "SessionEntity_id"
FROM
  "sessions" "SessionEntity"
WHERE
  (
    ("SessionEntity"."userId" = $1)
    AND ("SessionEntity"."id" IN ($2))
  )

-- AccessRepository.memory.checkOwnerAccess
SELECT
  "MemoryEntity"."id" AS "MemoryEntity_id"
FROM
  "memories" "MemoryEntity"
WHERE
  (
    (
      ("MemoryEntity"."id" IN ($1))
      AND ("MemoryEntity"."ownerId" = $2)
    )
  )
  AND ("MemoryEntity"."deletedAt" IS NULL)

-- AccessRepository.person.checkOwnerAccess
SELECT
  "PersonEntity"."id" AS "PersonEntity_id"
FROM
  "person" "PersonEntity"
WHERE
  (
    ("PersonEntity"."id" IN ($1))
    AND ("PersonEntity"."ownerId" = $2)
  )

-- AccessRepository.person.checkFaceOwnerAccess
SELECT
  "AssetFaceEntity"."id" AS "AssetFaceEntity_id"
FROM
  "asset_faces" "AssetFaceEntity"
  LEFT JOIN "assets" "AssetFaceEntity__AssetFaceEntity_asset" ON "AssetFaceEntity__AssetFaceEntity_asset"."id" = "AssetFaceEntity"."assetId"
  AND (
    "AssetFaceEntity__AssetFaceEntity_asset"."deletedAt" IS NULL
  )
WHERE
  (
    ("AssetFaceEntity"."id" IN ($1))
    AND (
      (
        (
          "AssetFaceEntity__AssetFaceEntity_asset"."ownerId" = $2
        )
      )
    )
  )

-- AccessRepository.partner.checkUpdateAccess
SELECT
  "partner"."sharedById" AS "partner_sharedById",
  "partner"."sharedWithId" AS "partner_sharedWithId"
FROM
  "partners" "partner"
WHERE
  "partner"."sharedById" IN ($1)
  AND "partner"."sharedWithId" = $2

-- AccessRepository.stack.checkOwnerAccess
SELECT
  "StackEntity"."id" AS "StackEntity_id"
FROM
  "asset_stack" "StackEntity"
WHERE
  (
    ("StackEntity"."id" IN ($1))
    AND ("StackEntity"."ownerId" = $2)
  )

-- AccessRepository.tag.checkOwnerAccess
SELECT
  "TagEntity"."id" AS "TagEntity_id"
FROM
  "tags" "TagEntity"
WHERE
  (
    ("TagEntity"."id" IN ($1))
    AND ("TagEntity"."userId" = $2)
  )

-- AccessRepository.timeline.checkPartnerAccess
SELECT
  "partner"."sharedById" AS "partner_sharedById",
  "partner"."sharedWithId" AS "partner_sharedWithId"
FROM
  "partners" "partner"
WHERE
  "partner"."sharedById" IN ($1)
  AND "partner"."sharedWithId" = $2
